/*
 * Decompiled with CFR 0.152.
 */
package jp.cafebabe.commons.xmlcli;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.cafebabe.commons.xmlcli.io.ArgfInputStream;
import jp.cafebabe.commons.xmlcli.io.ArgfReader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLinePlus {
    private static final Value EXISTS_VALUE = new Value(true);
    private Map<String, String> longOptionNames = new HashMap<String, String>();
    private CommandLine line;

    public CommandLinePlus(CommandLine line) {
        Option[] options = line.getOptions();
        int i = 0;
        while (i < options.length) {
            String longName = options[i].getLongOpt();
            String shortName = options[i].getOpt();
            if (longName != null && shortName != null && shortName.trim().length() > 0) {
                this.longOptionNames.put(longName, shortName);
            }
            ++i;
        }
        this.line = line;
    }

    public ArgfInputStream getArgfInputStream() {
        return new ArgfInputStream(this.getArgs());
    }

    public ArgfReader getArgfReader() {
        return new ArgfReader(this.getArgs());
    }

    public List getArgList() {
        return this.line.getArgList();
    }

    public String[] getArgs() {
        return this.line.getArgs();
    }

    public Object getOptionObject(char opt) {
        return this.getOptionObject(String.valueOf(opt));
    }

    public Object getOptionObject(String opt) {
        String n;
        String name = opt;
        if (opt.length() != 1 && (n = this.longOptionNames.get(name)) != null) {
            name = n;
        }
        return this.line.getOptionObject(name);
    }

    public Option[] getOptions() {
        return this.line.getOptions();
    }

    public String getOptionValue(char opt) {
        return this.getOptionValue(String.valueOf(opt));
    }

    public String getOptionValue(String opt) {
        String n;
        String name = opt;
        if (opt.length() != 1 && (n = this.longOptionNames.get(name)) != null) {
            name = n;
        }
        return this.line.getOptionValue(name);
    }

    public String getOptionValue(char opt, String defaultValue) {
        return this.getOptionValue(String.valueOf(opt));
    }

    public String getOptionValue(String opt, String defaultValue) {
        String value = this.getOptionValue(opt);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public String[] getOptionValues(char opt) {
        return this.getOptionValues(String.valueOf(opt));
    }

    public String[] getOptionValues(String opt) {
        String n;
        String name = opt;
        if (opt.length() != 1 && (n = this.longOptionNames.get(name)) != null) {
            name = n;
        }
        return this.line.getOptionValues(name);
    }

    public boolean hasOption(char opt) {
        return this.hasOption(String.valueOf(opt));
    }

    public boolean hasOption(String opt) {
        String n;
        String name = opt;
        if (opt.length() != 1 && (n = this.longOptionNames.get(name)) != null) {
            name = n;
        }
        return this.line.hasOption(name);
    }

    public Iterator iterator() {
        return this.line.iterator();
    }

    public Map<String, Object> getOptionValueMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Option[] option = this.getOptions();
        int i = 0;
        while (i < option.length) {
            String optionName = option[i].getLongOpt();
            if (optionName == null) {
                optionName = option[i].getOpt();
            }
            if (this.hasOption(optionName)) {
                if (option[i].hasArgs()) {
                    map.put(optionName, option[i].getValues());
                } else if (option[i].hasArg()) {
                    map.put(optionName, option[i].getValue());
                } else {
                    map.put(optionName, EXISTS_VALUE);
                }
            }
            ++i;
        }
        return map;
    }

    public static class Value {
        private boolean exists = true;

        private Value(boolean exists) {
            this.exists = exists;
        }

        public int hashCode() {
            if (this.exists) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object o) {
            return o instanceof Value && o.hashCode() == this.hashCode();
        }
    }
}

