/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import javax.imageio.spi.ServiceRegistry;
import jp.naist.se.stigmata.ApplicationInitializationError;
import jp.naist.se.stigmata.Birthmark;
import jp.naist.se.stigmata.BirthmarkComparator;
import jp.naist.se.stigmata.BirthmarkContext;
import jp.naist.se.stigmata.BirthmarkExtractionException;
import jp.naist.se.stigmata.BirthmarkExtractor;
import jp.naist.se.stigmata.BirthmarkSet;
import jp.naist.se.stigmata.ComparisonPairFilterSet;
import jp.naist.se.stigmata.ComparisonResultSet;
import jp.naist.se.stigmata.RoundRobinComparisonResultSet;
import jp.naist.se.stigmata.filter.ComparisonPairFilterManager;
import jp.naist.se.stigmata.filter.FilteredComparisonResultSet;
import jp.naist.se.stigmata.reader.ClassFileArchive;
import jp.naist.se.stigmata.reader.ClassFileEntry;
import jp.naist.se.stigmata.reader.ClasspathContext;
import jp.naist.se.stigmata.reader.DefaultClassFileArchive;
import jp.naist.se.stigmata.reader.JarClassFileArchive;
import jp.naist.se.stigmata.reader.WarClassFileArchive;
import jp.naist.se.stigmata.spi.BirthmarkSpi;
import jp.naist.se.stigmata.utils.ConfigFileImporter;
import org.apache.commons.beanutils.BeanUtils;

public class Stigmata {
    private static final Stigmata instance = new Stigmata();
    private BirthmarkContext defaultContext = BirthmarkContext.getDefaultContext();
    private boolean configDone = false;

    private Stigmata() {
    }

    public static Stigmata getInstance() {
        return instance;
    }

    public void configuration() {
        this.configuration(null);
    }

    public void configuration(String filePath) {
        InputStream target = null;
        if (filePath != null) {
            try {
                target = new FileInputStream(filePath);
            }
            catch (FileNotFoundException e) {
                filePath = null;
            }
        }
        if (filePath == null) {
            File file = new File("stigmata.xml");
            if (!file.exists() && !(file = new File(System.getProperty("user.home"), ".stigmata.xml")).exists()) {
                file = null;
            }
            if (file != null) {
                try {
                    target = new FileInputStream(file);
                }
                catch (FileNotFoundException ex) {
                    throw new InternalError(ex.getMessage());
                }
            }
        }
        if (target == null) {
            target = this.getClass().getResourceAsStream("/resources/stigmata.xml");
        }
        this.initConfiguration(target);
    }

    public BirthmarkContext createContext() {
        if (!this.configDone) {
            this.configuration();
        }
        return new BirthmarkContext();
    }

    public BirthmarkSet[] extract(String[] birthmarks, String[] files) throws BirthmarkExtractionException {
        if (!this.configDone) {
            this.configuration();
        }
        return this.extract(birthmarks, files, this.createContext());
    }

    public BirthmarkSet[] extract(String[] birthmarks, String[] files, BirthmarkContext context) throws BirthmarkExtractionException {
        if (!this.configDone) {
            this.configuration();
        }
        try {
            return this.extractImpl(birthmarks, files, context);
        }
        catch (IOException e) {
            throw new BirthmarkExtractionException(e);
        }
    }

    private BirthmarkSet[] extractImpl(String[] birthmarks, String[] files, BirthmarkContext context) throws IOException, BirthmarkExtractionException {
        ArrayList<ClassFileArchive> archives = new ArrayList<ClassFileArchive>();
        ArrayList<BirthmarkSet> list = new ArrayList<BirthmarkSet>();
        ClasspathContext bytecode = context.getBytecodeContext();
        int i = 0;
        while (i < files.length) {
            if (files[i].endsWith(".class")) {
                archives.add(new DefaultClassFileArchive(files[i]));
            } else if (files[i].endsWith(".jar") || files[i].endsWith(".zip")) {
                archives.add(new JarClassFileArchive(files[i]));
                bytecode.addClasspath(new File(files[i]).toURI().toURL());
            } else if (files[i].endsWith(".war")) {
                archives.add(new WarClassFileArchive(files[i]));
            }
            ++i;
        }
        for (ClassFileArchive archive : archives) {
            Iterator<ClassFileEntry> entries = archive.entries();
            while (entries.hasNext()) {
                ClassFileEntry entry = entries.next();
                BirthmarkSet holder = new BirthmarkSet(entry.getClassName(), entry.getLocation());
                this.extractBirthmark(birthmarks, holder.getLocation().openStream(), holder, context);
                list.add(holder);
            }
        }
        return list.toArray(new BirthmarkSet[list.size()]);
    }

    public ComparisonResultSet compare(BirthmarkSet[] holders) throws IOException {
        if (!this.configDone) {
            this.configuration();
        }
        return this.compare(holders, this.createContext());
    }

    public ComparisonResultSet compare(BirthmarkSet[] holders, BirthmarkContext context) throws IOException {
        if (!this.configDone) {
            this.configuration();
        }
        RoundRobinComparisonResultSet result = new RoundRobinComparisonResultSet(holders, context, true);
        return result;
    }

    public ComparisonResultSet compare(BirthmarkSet[] holders1, BirthmarkSet[] holders2) throws IOException {
        if (!this.configDone) {
            this.configuration();
        }
        return this.compare(holders1, holders2, this.createContext());
    }

    public ComparisonResultSet compare(BirthmarkSet[] holders1, BirthmarkSet[] holders2, BirthmarkContext context) throws IOException {
        if (!this.configDone) {
            this.configuration();
        }
        RoundRobinComparisonResultSet result = new RoundRobinComparisonResultSet(holders1, holders2, context);
        return result;
    }

    public ComparisonResultSet filter(ComparisonResultSet resultset, String[] filters) {
        return this.filter(resultset, filters, this.createContext());
    }

    public ComparisonResultSet filter(ComparisonResultSet resultset, String[] filters, BirthmarkContext context) {
        if (filters != null) {
            ArrayList<ComparisonPairFilterSet> filterList = new ArrayList<ComparisonPairFilterSet>();
            ComparisonPairFilterManager manager = context.getFilterManager();
            int i = 0;
            while (i < filters.length) {
                ComparisonPairFilterSet fset = manager.getFilterSet(filters[i]);
                if (fset != null) {
                    filterList.add(fset);
                } else {
                    Logger logger = Logger.getLogger(this.getClass().getName());
                    logger.warning(String.valueOf(filters[i]) + ": filter not found");
                }
                ++i;
            }
            return this.filter(resultset, filterList.toArray(new ComparisonPairFilterSet[filterList.size()]));
        }
        return resultset;
    }

    public ComparisonResultSet filter(ComparisonResultSet resultset, ComparisonPairFilterSet[] filters) {
        return this.filter(resultset, filters, this.createContext());
    }

    public ComparisonResultSet filter(ComparisonResultSet resultset, ComparisonPairFilterSet[] filters, BirthmarkContext context) {
        FilteredComparisonResultSet filterResultSet = new FilteredComparisonResultSet(resultset);
        return filterResultSet;
    }

    public double compare(BirthmarkSet h1, BirthmarkSet h2) {
        if (!this.configDone) {
            this.configuration();
        }
        return this.compare(h1, h2, this.createContext());
    }

    public double compare(BirthmarkSet h1, BirthmarkSet h2, BirthmarkContext context) {
        if (!this.configDone) {
            this.configuration();
        }
        ArrayList<Double> list = new ArrayList<Double>();
        int count = 0;
        Iterator<String> i = h1.birthmarkTypes();
        while (i.hasNext()) {
            String type = i.next();
            Birthmark b1 = h1.getBirthmark(type);
            Birthmark b2 = h2.getBirthmark(type);
            double similarity = Double.NaN;
            if (b1 != null && b2 != null) {
                BirthmarkSpi spi = context.getService(type);
                BirthmarkComparator comparator = spi.getComparator();
                similarity = comparator.compare(b1, b2);
                ++count;
            }
            list.add(similarity);
        }
        double similarity = 0.0;
        for (Double d : list) {
            if (d == Double.NaN) continue;
            similarity += d.doubleValue();
        }
        return similarity / (double)count;
    }

    private BirthmarkSet extractBirthmark(String[] birthmarks, InputStream in, BirthmarkSet holder, BirthmarkContext context) throws BirthmarkExtractionException, IOException {
        byte[] data = this.inputStreamToByteArray(in);
        return this.extractBirthmark(birthmarks, data, holder, context);
    }

    private BirthmarkSet extractBirthmark(String[] birthmarks, byte[] bytecode, BirthmarkSet holder, BirthmarkContext context) throws BirthmarkExtractionException, IOException {
        String[] stringArray = birthmarks;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String birthmark = stringArray[n];
            BirthmarkSpi spi = context.getService(birthmark);
            if (spi != null) {
                BirthmarkExtractor extractor = spi.getExtractor();
                try {
                    Map props = BeanUtils.describe((Object)extractor);
                    props.remove("class");
                    props.remove("provider");
                    for (Object keyObject : props.keySet()) {
                        String key = "extractor." + spi.getType() + "." + String.valueOf(keyObject);
                        if (context.getProperty(key) == null) continue;
                        BeanUtils.setProperty((Object)extractor, (String)((String)keyObject), (Object)context.getProperty(key));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                holder.addBirthmark(extractor.extract(new ByteArrayInputStream(bytecode), context));
            }
            ++n;
        }
        return holder;
    }

    private byte[] inputStreamToByteArray(InputStream in) throws IOException {
        int read;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] dataBuffer = new byte[512];
        while ((read = in.read(dataBuffer, 0, dataBuffer.length)) != -1) {
            bout.write(dataBuffer, 0, read);
        }
        byte[] data = bout.toByteArray();
        bout.close();
        return data;
    }

    private void initConfiguration(InputStream in) {
        try {
            ConfigFileImporter parser = new ConfigFileImporter(this.defaultContext);
            parser.parse(in);
        }
        catch (IOException e) {
            throw new ApplicationInitializationError(e);
        }
        Iterator<BirthmarkSpi> i = ServiceRegistry.lookupProviders(BirthmarkSpi.class);
        while (i.hasNext()) {
            BirthmarkSpi service = i.next();
            this.defaultContext.addService(service);
        }
        this.configDone = true;
    }
}

