/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.reader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import jp.naist.se.stigmata.reader.ClassFileArchive;
import jp.naist.se.stigmata.reader.ClassFileEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarClassFileArchive
implements ClassFileArchive {
    private JarFile jarfile;
    private URL jarfileLocation;

    public JarClassFileArchive(String jarfile) throws IOException {
        File file = new File(jarfile);
        this.jarfile = new JarFile(jarfile);
        this.jarfileLocation = file.toURI().toURL();
    }

    @Override
    public URL getLocation() {
        return this.jarfileLocation;
    }

    @Override
    public InputStream getInputStream(ClassFileEntry entry) throws IOException {
        if (this.hasEntry(entry.getClassName())) {
            return this.jarfile.getInputStream(this.jarfile.getEntry(entry.getClassName().replace('.', '/') + ".class"));
        }
        return null;
    }

    @Override
    public Iterator<ClassFileEntry> entries() {
        ArrayList<ClassFileEntry> list = new ArrayList<ClassFileEntry>();
        Enumeration<JarEntry> e = this.jarfile.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            if (!entry.getName().endsWith(".class")) continue;
            URL location = null;
            try {
                location = new URL("jar:" + this.getLocation() + "!/" + entry.getName());
                String className = entry.getName();
                className = className.substring(0, className.length() - ".class".length());
                className = className.replace('/', '.');
                list.add(new ClassFileEntry(className, location));
            }
            catch (MalformedURLException ex) {}
        }
        return list.iterator();
    }

    @Override
    public boolean hasEntry(String className) {
        return this.jarfile.getEntry(className.replace('.', '/') + ".class") != null;
    }

    @Override
    public ClassFileEntry getEntry(String className) throws ClassNotFoundException {
        if (this.hasEntry(className)) {
            String entryName = className.replace('.', '/') + ".class";
            try {
                URL location = new URL("jar:" + this.jarfile.getName() + "!/" + entryName);
                return new ClassFileEntry(className, location);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    Enumeration<JarEntry> jarentries() {
        return this.jarfile.entries();
    }

    boolean hasJarEntry(String entry) {
        return this.jarfile.getEntry(entry) != null;
    }
}

