/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.birthmarks.kgram;

import java.io.Serializable;
import java.util.Arrays;

public class KGram
implements Serializable {
    private static final long serialVersionUID = 273465874532523L;
    private int[] values;

    public KGram(int kvalue) {
        this.values = new int[kvalue];
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("{ ");
        int i = 0;
        while (i < this.values.length) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(this.values[i]);
            ++i;
        }
        buffer.append(" }");
        return new String(buffer);
    }

    public void set(int index, int value) {
        if (index < 0 || index >= this.values.length) {
            throw new ArrayIndexOutOfBoundsException("expected 0-" + this.values.length + ": " + index);
        }
        this.values[index] = value;
    }

    public int get(int index) {
        if (index < 0 || index >= this.values.length) {
            throw new ArrayIndexOutOfBoundsException("expected 0-" + this.values.length + ": " + index);
        }
        return this.values[index];
    }

    public boolean equals(Object o) {
        if (o instanceof KGram) {
            return Arrays.equals(this.values, ((KGram)o).values);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }
}

