package jp.naist.se.stigmata.ui.swing;

/*
 * $Id: ClassNameObfuscator.java 130 2007-06-13 10:08:01Z tama3 $
 */

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

import jp.naist.se.stigmata.Birthmark;
import jp.naist.se.stigmata.BirthmarkSet;

/**
 * 
 * @author Haruaki TAMADA
 * @version $Revision: 130 $ $Date: 2007-06-13 19:08:01 +0900 (Wed, 13 Jun 2007) $
 */
public class ClassNameObfuscator{
    private Map<String, String> nameMapping = new HashMap<String, String>();

    public void outputNameMappings(File file) throws IOException{
        PrintWriter out = null;
        try{
            out = new PrintWriter(new FileWriter(file));
            for(String oldName: nameMapping.keySet()){
                String newName = nameMapping.get(oldName);
                out.print(oldName);
                out.print(",");
                out.println(newName);
            }

        }finally{
            if(out != null){
                out.close();
            }
        }
    }

    public BirthmarkSet obfuscateClassName(BirthmarkSet orig){
        String newName = nameMapping.get(orig.getName());
        if(newName == null){
            newName = String.format("C%04d", new Object[] { new Integer(nameMapping.size() + 1), });
            nameMapping.put(orig.getName(), newName);
        }

        BirthmarkSet newSet = new BirthmarkSet(newName, orig.getLocation());
        for(Birthmark birthmark: orig){
            newSet.addBirthmark(birthmark);
        }
        return newSet;
    }

}
