package jp.naist.se.stigmata;

/*
 * $Id: BirthmarkElementClassNotFoundException.java 173 2007-07-16 02:24:32Z tama3 $
 */

import java.util.ArrayList;
import java.util.List;

/**
 * @author Haruaki TAMADA
 * @version $Revision: 173 $ $Date: 2007-07-16 11:24:32 +0900 (Mon, 16 Jul 2007) $
 */
public class BirthmarkElementClassNotFoundException extends
               BirthmarkExtractionFailedException {
    private static final long serialVersionUID = 3256723476854L;

    private List<String> classnames = new ArrayList<String>();

    public void addClassName(String name){
       classnames.add(name);
    }

    @Override
    public boolean isFailed(){
       return super.isFailed() || classnames.size() > 0;
    }

    public synchronized String[] getClassNames(){
       return classnames.toArray(new String[classnames.size()]);
    }

    public String getMessage(){
       StringBuffer sb = new StringBuffer();
       boolean first = true;
       for(String value: classnames){
               if(!first){
                       sb.append(", ");
               }
               sb.append(value);
       }
       return new String(sb);
    }
}