package jp.naist.se.stigmata;

/*
 * $Id: ExtractionResult.java 176 2007-08-28 06:43:49Z tama3 $
 */

import jp.naist.se.stigmata.BirthmarkContext.ExtractionTarget;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 176 $ $Date: 2007-08-28 15:43:49 +0900 (Tue, 28 Aug 2007) $
 */
public class ExtractionResult{
    private BirthmarkSet[] targetX;
    private BirthmarkSet[] targetY;
    private ExtractionTarget target = ExtractionTarget.TARGET_X;

    public BirthmarkSet[] getBirthmarkSetXY(){
        if(target != ExtractionTarget.TARGET_XY){
            throw new IllegalStateException("extraction mode is not XY");
        }
        return targetX;
    }

    public void setBirthmarkSetXY(BirthmarkSet[] targetXY){
        target = ExtractionTarget.TARGET_XY;
        this.targetX = targetXY;
    }

    public BirthmarkSet[] getBirthmarkSetX(){
        if(target == ExtractionTarget.TARGET_XY){
            throw new IllegalStateException("extraction mode is XY");
        }
        return targetX;
    }

    public void setBirthmarkSetX(BirthmarkSet[] targetX){
        target = ExtractionTarget.TARGET_X;
        this.targetX = targetX;
    }

    public BirthmarkSet[] getBirthmarkSetY(){
        if(target == ExtractionTarget.TARGET_XY){
            throw new IllegalStateException("extraction mode is XY");
        }
        return targetY;
    }

    public void setBirthmarkSetY(BirthmarkSet[] targetY){
        target = ExtractionTarget.TARGET_Y;
        this.targetY = targetY;
    }

    public ExtractionTarget getExtractionTarget(){
        return target;
    }

    public void setExtractionTarget(ExtractionTarget target){
        this.target = target;
    }
}
