package jp.naist.se.stigmata.ui.swing.mds.mark;

/*
 * $Id: RhombusDrawer.java 163 2007-07-13 04:18:27Z tama3 $
 */

import java.awt.Shape;
import java.awt.geom.GeneralPath;

/**
 * 
 * @author Haruaki TAMADA
 * @version $Revision: 163 $ $Date: 2007-07-13 13:18:27 +0900 (Fri, 13 Jul 2007) $
 */
class RhombusDrawer extends AbstractMarkDrawer{

    public RhombusDrawer(){
        super();
    }

    public RhombusDrawer(boolean fill){
        super(fill);
    }

    @Override
    public Shape getPlainShape(int w, int h){
        float ww = (float)w / 2f;
        float hh = (float)h / 2f;

        GeneralPath path = new GeneralPath();
        path.moveTo(ww,      hh - 2f);
        path.lineTo(ww + 2f, hh);
        path.lineTo(ww,      hh + 2f);
        path.lineTo(ww - 2f, hh);
        path.lineTo(ww,      hh - 2f);

        return path;
    }

    @Override
    public Shape getOveredShape(int w, int h){
        float ww = (float)w / 2f;
        float hh = (float)h / 2f;

        GeneralPath path = new GeneralPath();
        path.moveTo(ww,     0);
        path.lineTo(0,      hh);
        path.lineTo(ww,     h);
        path.lineTo(w,      hh);
        path.lineTo(ww,     0);

        return path;
    }

}
