/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.digger;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.sourceforge.stigmata.digger.ClassFileEntry;
import jp.sourceforge.stigmata.digger.util.WarClassLoader;

public class ClasspathContext
implements Iterable<URL> {
    private ClasspathContext parent;
    private List<URL> classpath = new ArrayList<URL>();
    private ClassLoader loader = null;
    private boolean includeSystemClass = true;

    public ClasspathContext() {
    }

    public ClasspathContext(ClasspathContext parent) {
        this.parent = parent;
        this.includeSystemClass = this.getParent().isIncludeSystemClasses();
    }

    public ClasspathContext getParent() {
        return this.parent;
    }

    public boolean isIncludeSystemClasses() {
        return this.includeSystemClass;
    }

    public synchronized void setIncludeSystemClasses(boolean flag) {
        if (this.includeSystemClass != flag) {
            this.loader = null;
        }
        this.includeSystemClass = flag;
        if (this.parent != null) {
            this.parent.setIncludeSystemClasses(flag);
        }
    }

    public synchronized void addClasspath(URL url) {
        if (!this.contains(url)) {
            this.classpath.add(url);
            this.loader = null;
        }
    }

    public synchronized boolean contains(URL url) {
        return this.parent != null && this.parent.contains(url) || this.classpath.contains(url);
    }

    public synchronized int getClasspathSize() {
        int count = this.classpath.size();
        if (this.parent != null) {
            count += this.parent.getClasspathSize();
        }
        return count;
    }

    public synchronized URL[] getClasspathList() {
        ArrayList<URL> list = new ArrayList<URL>();
        for (URL url : this) {
            list.add(url);
        }
        return list.toArray(new URL[list.size()]);
    }

    public synchronized void clear() {
        this.classpath.clear();
    }

    public synchronized void clearAll() {
        this.clear();
        if (this.parent != null) {
            this.parent.clearAll();
        }
    }

    @Override
    public synchronized Iterator<URL> iterator() {
        if (this.parent == null) {
            return this.classpath.iterator();
        }
        final Iterator<URL> parentIterator = this.parent.iterator();
        final Iterator<URL> thisIterator = this.classpath.iterator();
        return new Iterator<URL>(){

            @Override
            public boolean hasNext() {
                boolean next = parentIterator.hasNext();
                if (!next) {
                    next = thisIterator.hasNext();
                }
                return next;
            }

            @Override
            public URL next() {
                URL nextObject = null;
                nextObject = parentIterator.hasNext() ? (URL)parentIterator.next() : (URL)thisIterator.next();
                return nextObject;
            }

            @Override
            public void remove() {
            }
        };
    }

    public synchronized ClassLoader createClassLoader() {
        if (this.loader == null) {
            ArrayList<URL> list = new ArrayList<URL>();
            for (URL url : this) {
                list.add(url);
            }
            ClassLoader parentClassLoader = null;
            parentClassLoader = this.parent != null ? this.parent.createClassLoader() : (this.isIncludeSystemClasses() ? this.getClass().getClassLoader() : ClassLoader.getSystemClassLoader());
            this.loader = new WarClassLoader(list.toArray(new URL[list.size()]), parentClassLoader);
        }
        return this.loader;
    }

    public synchronized ClassFileEntry findEntry(String className) {
        ClassLoader loader = this.createClassLoader();
        URL resource = loader.getResource(className.replace('.', '/') + ".class");
        if (resource != null) {
            return new ClassFileEntry(className, resource);
        }
        return null;
    }

    public synchronized boolean hasEntry(String className) {
        ClassLoader loader = this.createClassLoader();
        return loader.getResource(className.replace('.', '/') + ".class") != null;
    }

    public synchronized Class<?> findClass(String className) throws ClassNotFoundException {
        try {
            ClassLoader loader = this.createClassLoader();
            Class<?> clazz = loader.loadClass(className);
            return clazz;
        }
        catch (NoClassDefFoundError e) {
            throw new ClassNotFoundException(e.getMessage(), e);
        }
    }
}

