/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.mds;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import jp.sourceforge.talisman.mds.Item;
import jp.sourceforge.talisman.mds.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MdsMethod<T>
implements Iterable<Item> {
    private boolean calculated = false;
    private Table<T> table;
    private int rank;
    private int limit = -1;
    private Map<String, Item> itemsMap = new LinkedHashMap<String, Item>();

    public MdsMethod() {
    }

    public MdsMethod(MdsMethod<T> mds) {
        this(mds.getTable());
    }

    public MdsMethod(Table<T> table) {
        this.table = table;
    }

    public int getRank() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.rank;
    }

    public boolean isLimitted() {
        return this.limit > 0;
    }

    public void setLimit(int limit) {
        if (limit <= 0) {
            throw new IllegalArgumentException();
        }
        this.limit = limit;
        if (!this.calculated) {
            this.calculate();
        }
        for (Item item : this) {
            item.setLimit(limit);
        }
    }

    public void removeLimit() {
        this.limit = -1;
        for (Item item : this) {
            item.removeLimit();
        }
    }

    public int getLimit() {
        if (!this.isLimitted()) {
            throw new IllegalStateException();
        }
        return this.limit;
    }

    public void calculate() {
        Table<T> table = this.getTable();
        if (table == null) {
            throw new IllegalStateException();
        }
        if (!table.isValid()) {
            throw new IllegalStateException();
        }
        Matrix target = this.constructTargetMatrix(table);
        Matrix mat = this.getCenteredInnerProductMatrix(target);
        EigenvalueDecomposition eigen = mat.eig();
        Matrix eigenVectors = eigen.getV();
        Matrix eigenValues = eigen.getD();
        Matrix itemMatrix = (Matrix)eigenVectors.clone();
        int col = mat.getColumnDimension();
        int row = mat.getRowDimension();
        for (int i = 0; i < row; ++i) {
            for (int j = 0; j < col; ++j) {
                double v = itemMatrix.get(i, j);
                itemMatrix.set(i, j, v *= Math.sqrt(eigenValues.get(j, j)));
            }
        }
        int[] indexes = this.sortValues(eigenValues);
        this.rank = target.rank();
        Object[] labels = table.getKeys();
        for (int i = 0; i < labels.length; ++i) {
            Item c = new Item(String.valueOf(labels[i]));
            this.itemsMap.put(c.getName(), c);
            for (int j = 0; j < this.rank; ++j) {
                c.add(itemMatrix.get(i, indexes[j]));
            }
        }
        this.calculated = true;
    }

    public Item getItem(String label) {
        if (!this.calculated) {
            this.calculate();
        }
        return this.itemsMap.get(label);
    }

    public int getItemCount() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.itemsMap.size();
    }

    public synchronized Item[] getItems() {
        Item[] items = new Item[this.getItemCount()];
        int index = 0;
        Iterator<Item> i$ = this.iterator();
        while (i$.hasNext()) {
            Item c;
            items[index] = c = i$.next();
            ++index;
        }
        return items;
    }

    public Table<T> getTable() {
        return this.table;
    }

    @Override
    public Iterator<Item> iterator() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.itemsMap.values().iterator();
    }

    public Iterator<String> names() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.itemsMap.keySet().iterator();
    }

    public void setTable(Table<T> table) {
        this.table = table;
        this.itemsMap.clear();
        this.calculated = false;
    }

    private Matrix constructTargetMatrix(Table<T> table) {
        Matrix matrix = new Matrix(table.getKeySize(), table.getKeySize());
        Set<T> names = table.getKeySet();
        int indexX = 0;
        for (T nameX : names) {
            int indexY = 0;
            for (T nameY : names) {
                if (nameX.equals(nameY)) {
                    matrix.set(indexX, indexY, 0.0);
                } else {
                    Number number = table.getValue(nameX, nameY);
                    matrix.set(indexX, indexY, number.doubleValue());
                }
                ++indexY;
            }
            ++indexX;
        }
        return matrix;
    }

    private Matrix getCenteredInnerProductMatrix(Matrix target) {
        int size = target.getColumnDimension();
        assert (target.getRowDimension() == target.getColumnDimension());
        Matrix m = new Matrix(target.getColumnDimension(), target.getRowDimension());
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                double v1 = 0.0;
                for (int k = 0; k < size; ++k) {
                    v1 += target.get(k, j) * target.get(k, j) / (double)size;
                }
                double v2 = 0.0;
                for (int k = 0; k < size; ++k) {
                    v2 += target.get(i, k) * target.get(i, k) / (double)size;
                }
                double v3 = 0.0;
                for (int k = 0; k < size; ++k) {
                    for (int l = 0; l < size; ++l) {
                        v3 += target.get(k, l) * target.get(k, l) / (double)(size * size);
                    }
                }
                double v4 = target.get(i, j);
                m.set(i, j, (v1 + v2 - v3 - v4 * v4) / 2.0);
            }
        }
        return m;
    }

    private int[] sortValues(Matrix m) {
        int i;
        double[] v = new double[m.getColumnDimension()];
        int[] index = new int[v.length];
        for (i = 0; i < v.length; ++i) {
            v[i] = m.get(i, i);
            index[i] = i;
        }
        for (i = 0; i < v.length; ++i) {
            for (int j = i + 1; j < v.length; ++j) {
                if (!(Math.abs(v[i]) < Math.abs(v[j]))) continue;
                double tmpValue = v[j];
                v[j] = v[i];
                v[i] = tmpValue;
                int tmpIndex = index[j];
                index[j] = index[i];
                index[i] = tmpIndex;
            }
        }
        return index;
    }
}

