/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.mds.distance;

import jp.sourceforge.talisman.mds.distance.AbstractItemDistanceCalculator;
import jp.sourceforge.talisman.mds.distance.ItemDistanceAlgorithm;

public class MinkowskyItemDistanceCalculator
extends AbstractItemDistanceCalculator {
    private int pvalue;

    public MinkowskyItemDistanceCalculator() {
        this(3);
    }

    public MinkowskyItemDistanceCalculator(int pvalue) {
        this.setPValue(pvalue);
    }

    public double getPValue() {
        return this.pvalue;
    }

    public void setPValue(int pvalue) {
        this.pvalue = pvalue;
    }

    public ItemDistanceAlgorithm getAlgorithm() {
        return ItemDistanceAlgorithm.MINKOWSKY_DISTANCE;
    }

    public synchronized double calculate(double[] x, double[] y) {
        this.validateArguments(x, y);
        double value = 0.0;
        for (int i = 0; i < x.length; ++i) {
            if (Double.isNaN(x[i]) || Double.isNaN(y[i])) continue;
            double diff = Math.abs(x[i] - y[i]);
            value += Math.pow(diff, this.getPValue());
        }
        return Math.pow(value, 1.0 / this.getPValue());
    }
}

