/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.mds.ui.swing.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import jp.sourceforge.talisman.mds.Item;
import jp.sourceforge.talisman.mds.MdsMethod;
import jp.sourceforge.talisman.mds.ui.swing.MdsPane;
import jp.sourceforge.talisman.mds.ui.swing.actions.TableSorter;
import jp.sourceforge.talisman.mds.ui.swing.actions.UneditableDefaultTableModel;

public class ShowItemsAction
extends AbstractAction {
    private static final long serialVersionUID = 445562293718912259L;
    private MdsPane mds;
    private Component parent;

    public ShowItemsAction(MdsPane mds) {
        this(mds, mds);
    }

    public ShowItemsAction(Component parent, MdsPane mds) {
        super(mds.getMessages().get("show.coordinates.label"));
        this.parent = parent;
        this.mds = mds;
        if (mds.getMessages().hasValue("show.coordinates.tooltip")) {
            this.putValue("ShortDescription", mds.getMessages().get("show.coordinates.tooltip"));
        }
        if (mds.getMessages().hasValue("show.coordinates.icon")) {
            Icon icon = mds.getMessages().getIcon("show.coordinates.icon");
            this.putValue("SmallIcon", icon);
        }
    }

    public void actionPerformed(ActionEvent e) {
        JOptionPane.showMessageDialog(this.parent, this.createPane(), this.mds.getMessages().get("show.coordinates.title"), 1);
    }

    private Component createPane() {
        UneditableDefaultTableModel model = new UneditableDefaultTableModel();
        TableSorter sorter = new TableSorter(model);
        MdsMethod method = this.mds.getMdsMethod();
        Object[] identifiers = new String[method.getRank() + 1];
        identifiers[0] = "";
        for (int i = 1; i < identifiers.length; ++i) {
            identifiers[i] = this.mds.getMessages().get("show.coordinate.xaxis.label") + i;
        }
        model.setColumnIdentifiers(identifiers);
        Item[] items = method.getItems();
        for (int i = 0; i < items.length; ++i) {
            Object[] values = new String[identifiers.length];
            values[0] = items[i].getName();
            for (int j = 1; j < values.length; ++j) {
                values[j] = String.valueOf(items[i].get(j - 1));
            }
            model.addRow(values);
        }
        JTable table = new JTable(sorter);
        sorter.setTableHeader(table.getTableHeader());
        JScrollPane scroll = new JScrollPane(table, 22, 32);
        scroll.setSize(new Dimension(300, 300));
        Box north = Box.createHorizontalBox();
        north.add(Box.createHorizontalGlue());
        north.add(new JLabel(String.format("%s: %d", this.mds.getMessages().get("show.coordinate.rank.label"), method.getRank())));
        north.add(Box.createHorizontalGlue());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)scroll, "Center");
        panel.add((Component)north, "North");
        return panel;
    }
}

