/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata;

import java.util.ArrayList;
import java.util.Iterator;
import jp.sourceforge.stigmata.Birthmark;
import jp.sourceforge.stigmata.BirthmarkContext;
import jp.sourceforge.stigmata.BirthmarkEnvironment;
import jp.sourceforge.stigmata.BirthmarkSet;
import jp.sourceforge.stigmata.ComparisonPairElement;

public class ComparisonPair
implements Iterable<ComparisonPairElement> {
    private BirthmarkSet target1;
    private BirthmarkSet target2;
    private BirthmarkContext context;

    public ComparisonPair(BirthmarkSet target1, BirthmarkSet target2, BirthmarkContext context) {
        this.target1 = target1;
        this.target2 = target2;
        this.context = context;
        if (target1.getBirthmarksCount() != target2.getBirthmarksCount()) {
            throw new IllegalArgumentException("birthmark count is not matched");
        }
    }

    public BirthmarkSet getTarget1() {
        return this.target1;
    }

    public BirthmarkSet getTarget2() {
        return this.target2;
    }

    public double calculateSimilarity() {
        double similarity = 0.0;
        int count = 0;
        for (ComparisonPairElement elem : this) {
            double sim = elem.getSimilarity();
            if (Double.isNaN(sim) || Double.isInfinite(sim)) continue;
            similarity += sim;
            ++count;
        }
        return similarity / (double)count;
    }

    public int getBirthmarksCount() {
        return this.target1.getBirthmarksCount();
    }

    @Override
    public synchronized Iterator<ComparisonPairElement> iterator() {
        ArrayList<ComparisonPairElement> list = new ArrayList<ComparisonPairElement>();
        BirthmarkEnvironment env = this.context.getEnvironment();
        Iterator<String> i = this.target1.birthmarkTypes();
        while (i.hasNext()) {
            String type = i.next();
            Birthmark b1 = this.target1.getBirthmark(type);
            Birthmark b2 = this.target2.getBirthmark(type);
            if (b1 == null || b2 == null) continue;
            list.add(new ComparisonPairElement(b1, b2, env.getService(type).getComparator(), this.context));
        }
        return list.iterator();
    }
}

