/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.birthmarks;

import java.io.IOException;
import java.io.InputStream;
import jp.sourceforge.stigmata.Birthmark;
import jp.sourceforge.stigmata.BirthmarkContext;
import jp.sourceforge.stigmata.BirthmarkExtractionFailedException;
import jp.sourceforge.stigmata.birthmarks.AbstractBirthmarkExtractor;
import jp.sourceforge.stigmata.birthmarks.BirthmarkExtractVisitor;
import jp.sourceforge.stigmata.spi.BirthmarkSpi;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;

public abstract class ASMBirthmarkExtractor
extends AbstractBirthmarkExtractor {
    public ASMBirthmarkExtractor(BirthmarkSpi spi) {
        super(spi);
    }

    public ASMBirthmarkExtractor() {
    }

    public abstract BirthmarkExtractVisitor createExtractVisitor(ClassWriter var1, Birthmark var2, BirthmarkContext var3);

    @Override
    public Birthmark extract(Birthmark birthmark, InputStream in, BirthmarkContext context) throws BirthmarkExtractionFailedException {
        BirthmarkExtractionFailedException bee = new BirthmarkExtractionFailedException();
        try {
            ClassReader reader = new ClassReader(in);
            ClassWriter writer = new ClassWriter(0);
            BirthmarkExtractVisitor visitor = this.createExtractVisitor(writer, birthmark, context);
            reader.accept(visitor, 0);
            if (!visitor.isSuccess()) {
                bee.addCauses(visitor.getCauses());
            }
            return visitor.getBirthmark();
        }
        catch (IOException e) {
            bee.addCause(e);
            throw bee;
        }
    }
}

