/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.birthmarks;

import java.util.Locale;
import jp.sourceforge.stigmata.Birthmark;
import jp.sourceforge.stigmata.BirthmarkComparator;
import jp.sourceforge.stigmata.BirthmarkElement;
import jp.sourceforge.stigmata.BirthmarkExtractor;
import jp.sourceforge.stigmata.BirthmarkPreprocessor;
import jp.sourceforge.stigmata.birthmarks.NullBirthmarkElement;
import jp.sourceforge.stigmata.spi.BirthmarkSpi;
import jp.sourceforge.stigmata.utils.LocalizedDescriptionManager;

public abstract class AbstractBirthmarkService
implements BirthmarkSpi {
    @Override
    public String getDisplayType() {
        return this.getDisplayType(Locale.getDefault());
    }

    @Override
    public String getDisplayType(Locale locale) {
        LocalizedDescriptionManager manager = LocalizedDescriptionManager.getInstance();
        String type = manager.getDisplayType(locale, this.getType());
        if (type == null) {
            type = this.getType();
        }
        return type;
    }

    @Override
    public String getDescription() {
        return this.getDescription(Locale.getDefault());
    }

    @Override
    public String getDescription(Locale locale) {
        LocalizedDescriptionManager manager = LocalizedDescriptionManager.getInstance();
        String description = manager.getDescription(locale, this.getType());
        if (description == null) {
            description = this.getDefaultDescription();
        }
        return description;
    }

    @Override
    public abstract BirthmarkComparator getComparator();

    @Override
    public String getComparatorClassName() {
        return this.getComparator().getClass().getName();
    }

    @Override
    public abstract BirthmarkExtractor getExtractor();

    @Override
    public String getExtractorClassName() {
        return this.getExtractor().getClass().getName();
    }

    @Override
    public BirthmarkPreprocessor getPreprocessor() {
        return null;
    }

    @Override
    public String getPreprocessorClassName() {
        BirthmarkPreprocessor preprocessor = this.getPreprocessor();
        String name = null;
        if (preprocessor != null) {
            name = preprocessor.getClass().getName();
        }
        return name;
    }

    @Override
    public abstract String getType();

    @Override
    public abstract String getDefaultDescription();

    @Override
    public boolean isExpert() {
        return true;
    }

    @Override
    public boolean isUserDefined() {
        return true;
    }

    @Override
    public String getVersion() {
        return this.getClass().getPackage().getImplementationVersion();
    }

    @Override
    public String getVendorName() {
        return this.getClass().getPackage().getImplementationVendor();
    }

    @Override
    public Birthmark buildBirthmark() {
        return this.getExtractor().createBirthmark();
    }

    @Override
    public BirthmarkElement buildBirthmarkElement(String value) {
        if (value == null || value.equals("<null>")) {
            return NullBirthmarkElement.getInstance();
        }
        return new BirthmarkElement(value);
    }
}

