/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.birthmarks;

import java.lang.reflect.Constructor;
import jp.sourceforge.stigmata.BirthmarkComparator;
import jp.sourceforge.stigmata.BirthmarkEnvironment;
import jp.sourceforge.stigmata.BirthmarkExtractor;
import jp.sourceforge.stigmata.birthmarks.AbstractBirthmarkService;
import jp.sourceforge.stigmata.spi.BirthmarkSpi;

public class BirthmarkService
extends AbstractBirthmarkService
implements BirthmarkSpi {
    private Class<? extends BirthmarkExtractor> extractorClass;
    private Class<? extends BirthmarkComparator> comparatorClass;
    private String type;
    private String displayType;
    private String description;
    private BirthmarkExtractor extractorObject;
    private BirthmarkComparator comparatorObject;
    private boolean userDefined = true;
    private BirthmarkEnvironment environment;

    public BirthmarkService(BirthmarkEnvironment environment) {
        this.environment = environment;
    }

    public BirthmarkService() {
    }

    public void setBirthmarkEnvironment(BirthmarkEnvironment environment) {
        this.environment = environment;
    }

    public void setExtractorClassName(String extractor) {
        try {
            Class c = this.environment == null ? Class.forName(extractor) : this.environment.getClasspathContext().findClass(extractor);
            this.extractorClass = c.asSubclass(BirthmarkExtractor.class);
            this.extractorObject = null;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void setComparatorClassName(String comparator) {
        try {
            Class c = this.environment == null ? Class.forName(comparator) : this.environment.getClasspathContext().findClass(comparator);
            this.comparatorClass = c.asSubclass(BirthmarkComparator.class);
            this.comparatorObject = null;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setDisplayType(String displayType) {
        this.displayType = displayType;
    }

    @Override
    public String getDisplayType() {
        return this.displayType;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        String desc = this.description;
        if (this.description == null) {
            desc = "";
        }
        return desc;
    }

    @Override
    public String getDefaultDescription() {
        return this.description;
    }

    @Override
    public String getExtractorClassName() {
        return this.extractorClass.getName();
    }

    @Override
    public BirthmarkExtractor getExtractor() {
        if (this.extractorObject == null) {
            try {
                Constructor<? extends BirthmarkExtractor> c = this.extractorClass.getConstructor(BirthmarkSpi.class);
                this.extractorObject = c.newInstance(this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.extractorObject;
    }

    @Override
    public String getComparatorClassName() {
        return this.comparatorClass.getName();
    }

    @Override
    public BirthmarkComparator getComparator() {
        if (this.comparatorObject == null) {
            try {
                Constructor<? extends BirthmarkComparator> c = this.comparatorClass.getConstructor(BirthmarkSpi.class);
                this.comparatorObject = c.newInstance(this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.comparatorObject;
    }

    @Override
    public boolean isUserDefined() {
        return this.userDefined;
    }

    public void setUserDefined(boolean userDefined) {
        this.userDefined = userDefined;
    }
}

