/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.birthmarks.kgram;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;

public class KGram<T>
implements Serializable {
    private static final long serialVersionUID = 273465874532523L;
    private int maxLength = 4;
    private T[] values;

    public KGram(int kvalue) {
        this.setKValue(kvalue);
    }

    public void setKValue(int kvalue) {
        this.maxLength = kvalue;
    }

    public int getKValue() {
        return this.maxLength;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("{ ");
        for (int i = 0; i < this.maxLength; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(this.get(i));
        }
        buffer.append(" }");
        return new String(buffer);
    }

    public void set(int index, T value) {
        if (index < 0 || index >= this.maxLength) {
            throw new ArrayIndexOutOfBoundsException("expected 0-" + (this.maxLength - 1) + ": " + index);
        }
        if (value == null) {
            throw new NullPointerException("null value");
        }
        if (this.values == null) {
            this.values = (Object[])Array.newInstance(value.getClass(), this.getKValue());
        }
        this.values[index] = value;
    }

    public T get(int index) {
        T returnValue = null;
        if (index < 0 || index >= this.maxLength) {
            throw new ArrayIndexOutOfBoundsException("expected 0-" + (this.maxLength - 1) + ": " + index);
        }
        if (this.values != null) {
            returnValue = this.values[index];
        }
        return returnValue;
    }

    public int add(T value) {
        int index = -1;
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] != null) continue;
            index = i;
            this.values[i] = value;
            break;
        }
        return index;
    }

    public T[] toArray() {
        if (this.values == null) {
            throw new IllegalStateException("this object has no elements.");
        }
        Object[] newarray = (Object[])Array.newInstance(this.values[0].getClass(), this.getKValue());
        System.arraycopy(this.values, 0, newarray, 0, this.getKValue());
        return newarray;
    }

    public boolean equals(Object o) {
        if (o instanceof KGram) {
            KGram kgram = (KGram)o;
            boolean flag = this.getKValue() == kgram.getKValue();
            for (int i = 0; !flag && i < this.maxLength; ++i) {
                if (this.get(i).equals(kgram.get(i))) continue;
                flag = false;
                break;
            }
            return flag;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }
}

