/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.birthmarks.kgram;

import java.util.LinkedHashSet;
import java.util.List;
import jp.sourceforge.stigmata.birthmarks.kgram.KGram;

public class KGramBuilder {
    private static final KGramBuilder builder = new KGramBuilder();

    private KGramBuilder() {
    }

    public static KGramBuilder getInstance() {
        return builder;
    }

    public <T> KGram<T>[] buildKGram(T[] values, int kvalue) {
        LinkedHashSet kgrams = new LinkedHashSet();
        if (values.length >= kvalue) {
            int max = values.length - (kvalue - 1);
            for (int i = 0; i < max; ++i) {
                KGram<T> kgram = new KGram<T>(kvalue);
                for (int j = 0; j < kvalue; ++j) {
                    kgram.set(j, values[i + j]);
                }
                kgrams.add(kgram);
            }
        }
        return kgrams.toArray(new KGram[kgrams.size()]);
    }

    public <T> KGram<T>[] buildKGram(List<T> values, int kvalue) {
        LinkedHashSet kgrams = new LinkedHashSet();
        if (values.size() >= kvalue) {
            int max = values.size() - (kvalue - 1);
            for (int i = 0; i < max; ++i) {
                KGram<T> kgram = new KGram<T>(kvalue);
                for (int j = 0; j < kvalue; ++j) {
                    kgram.set(j, values.get(i + j));
                }
                kgrams.add(kgram);
            }
        }
        return kgrams.toArray(new KGram[kgrams.size()]);
    }
}

