/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.command;

import java.io.PrintWriter;
import java.util.Iterator;
import jp.sourceforge.stigmata.BirthmarkContext;
import jp.sourceforge.stigmata.BirthmarkEngine;
import jp.sourceforge.stigmata.ComparisonMethod;
import jp.sourceforge.stigmata.ExtractionResultSet;
import jp.sourceforge.stigmata.Stigmata;
import jp.sourceforge.stigmata.command.AbstractStigmataCommand;
import jp.sourceforge.stigmata.event.BirthmarkEngineAdapter;
import jp.sourceforge.stigmata.event.BirthmarkEngineEvent;
import jp.sourceforge.stigmata.event.WarningMessages;
import jp.sourceforge.stigmata.printer.ExtractionResultSetPrinter;
import jp.sourceforge.stigmata.spi.ResultPrinterSpi;

public class ExtractCommand
extends AbstractStigmataCommand {
    @Override
    public boolean isAvailableArguments(String[] args) {
        return args.length > 0;
    }

    @Override
    public String getCommandString() {
        return "extract";
    }

    @Override
    public void perform(Stigmata stigmata, BirthmarkContext context, String[] args) {
        try {
            context.setComparisonMethod(ComparisonMethod.ROUND_ROBIN_SAME_PAIR);
            BirthmarkEngine engine = new BirthmarkEngine(context.getEnvironment());
            engine.addBirthmarkEngineListener(new BirthmarkEngineAdapter(){

                @Override
                public void operationDone(BirthmarkEngineEvent e) {
                    WarningMessages warnings = e.getMessage();
                    Iterator<Exception> i = warnings.exceptions();
                    while (i.hasNext()) {
                        i.next().printStackTrace();
                    }
                }
            });
            ExtractionResultSet ers = engine.extract(args, context);
            ResultPrinterSpi spi = stigmata.getPrinterManager().getService(context.getFormat());
            ExtractionResultSetPrinter formatter = spi.getExtractionResultSetPrinter();
            formatter.printResult(new PrintWriter(System.out), ers);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

