/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.hook;

import java.util.Iterator;
import jp.sourceforge.stigmata.BirthmarkContext;
import jp.sourceforge.stigmata.BirthmarkEnvironment;
import jp.sourceforge.stigmata.hook.MultipleStigmataHook;
import jp.sourceforge.stigmata.hook.Phase;
import jp.sourceforge.stigmata.spi.StigmataHookSpi;

public class StigmataHookManager {
    private static final StigmataHookManager manager = new StigmataHookManager();

    private StigmataHookManager() {
    }

    public static StigmataHookManager getInstance() {
        return manager;
    }

    public void runHook(Phase phase, BirthmarkContext context) {
        MultipleStigmataHook hook = this.buildHook(phase, context.getEnvironment());
        hook.onHook(phase, context);
    }

    public void runHook(Phase phase, BirthmarkEnvironment env) {
        MultipleStigmataHook hook = this.buildHook(phase, env);
        hook.onHook(phase, env);
    }

    private MultipleStigmataHook buildHook(Phase phase, BirthmarkEnvironment env) {
        MultipleStigmataHook hooks = new MultipleStigmataHook();
        Iterator<StigmataHookSpi> i = env.lookupProviders(StigmataHookSpi.class);
        block10: while (i.hasNext()) {
            StigmataHookSpi service = i.next();
            switch (phase) {
                case SETUP: {
                    hooks.addHook(service.onSetup());
                    continue block10;
                }
                case TEAR_DOWN: {
                    hooks.addHook(service.onTearDown());
                    continue block10;
                }
                case BEFORE_EXTRACTION: {
                    hooks.addRuntimeHook(service.beforeExtraction());
                    continue block10;
                }
                case AFTER_EXTRACTION: {
                    hooks.addRuntimeHook(service.afterExtraction());
                    continue block10;
                }
                case BEFORE_COMPARISON: {
                    hooks.addRuntimeHook(service.beforeComparison());
                    continue block10;
                }
                case AFTER_COMPARISON: {
                    hooks.addRuntimeHook(service.afterComparison());
                    continue block10;
                }
                case BEFORE_FILTERING: {
                    hooks.addRuntimeHook(service.beforeFiltering());
                    continue block10;
                }
                case AFTER_FILTERING: {
                    hooks.addRuntimeHook(service.afterFiltering());
                    continue block10;
                }
            }
            throw new InternalError("invalid phase: " + (Object)((Object)phase));
        }
        return hooks;
    }
}

