/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.result;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import jp.sourceforge.stigmata.BirthmarkContext;
import jp.sourceforge.stigmata.BirthmarkEnvironment;
import jp.sourceforge.stigmata.BirthmarkSet;
import jp.sourceforge.stigmata.ComparisonPair;
import jp.sourceforge.stigmata.ComparisonResultSet;
import jp.sourceforge.stigmata.ExtractionResultSet;

public abstract class AbstractComparisonResultSet
implements ComparisonResultSet {
    protected ExtractionResultSet extraction;
    private int count = -1;

    public AbstractComparisonResultSet(ExtractionResultSet extraction) {
        this.extraction = extraction;
    }

    @Override
    public abstract Iterator<ComparisonPair> iterator();

    @Override
    public abstract Iterator<BirthmarkSet> pairSources();

    @Override
    public synchronized BirthmarkSet[] getPairSources() {
        return AbstractComparisonResultSet.getArrays(this.pairSources(), new BirthmarkSet[0]);
    }

    @Override
    public int getPairCount() {
        if (this.count < 0) {
            int calculateCount = 0;
            Iterator<ComparisonPair> i = this.iterator();
            while (i.hasNext()) {
                ++calculateCount;
                i.next();
            }
            this.count = calculateCount;
        }
        return this.count;
    }

    @Override
    public synchronized ComparisonPair[] getPairs() {
        return AbstractComparisonResultSet.getArrays(this.iterator(), new ComparisonPair[0]);
    }

    @Override
    public ComparisonPair getPairAt(int index) {
        int currentIndex = 0;
        for (ComparisonPair pair : this) {
            if (currentIndex == index) {
                return pair;
            }
            ++currentIndex;
        }
        return null;
    }

    @Override
    public BirthmarkContext getContext() {
        return this.extraction.getContext();
    }

    @Override
    public BirthmarkEnvironment getEnvironment() {
        return this.extraction.getEnvironment();
    }

    static synchronized <T> T[] getArrays(Iterator<T> i, T[] array) {
        ArrayList<T> list = new ArrayList<T>();
        while (i.hasNext()) {
            list.add(i.next());
        }
        if (list.size() > array.length) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), list.size());
        }
        for (int index = 0; index < list.size(); ++index) {
            array[index] = list.get(index);
        }
        return array;
    }
}

