/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.ui.swing;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import jp.sourceforge.stigmata.BirthmarkEnvironment;

public class CompareTableCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 234557758658567345L;
    private static final double EPSILON = 1.0E-8;
    private BirthmarkEnvironment environment;

    public CompareTableCellRenderer(BirthmarkEnvironment environment) {
        this.environment = environment;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasForcus, int row, int col) {
        Object value = table.getValueAt(row, col);
        Component c = super.getTableCellRendererComponent(table, obj, isSelected, hasForcus, row, col);
        if (value instanceof Double && !isSelected) {
            double d = (Double)value;
            int rank = 0;
            if (d < 1.0E-8) {
                rank = 0;
            } else if (d - 0.2 < 1.0E-8) {
                rank = 1;
            } else if (d - 0.4 < 1.0E-8) {
                rank = 2;
            } else if (d - 0.6 < 1.0E-8) {
                rank = 3;
            } else if (d - 0.8 < 1.0E-8) {
                rank = 4;
            } else if (d - 1.0 < 1.0E-8) {
                rank = 5;
            }
            c.setBackground(CompareTableCellRenderer.getBackgroundColor(rank, this.environment));
            c.setForeground(CompareTableCellRenderer.getForegroundColor(rank, this.environment));
        }
        return c;
    }

    public static Color getDefaultForegroundColor(int rank) {
        int c = 180 - 36 * rank;
        return new Color(c, c, c);
    }

    public static Color getDefaultBackgroundColor(int rank) {
        Color c;
        switch (rank) {
            case 5: {
                c = Color.RED;
                break;
            }
            default: {
                c = Color.WHITE;
            }
        }
        return c;
    }

    public static Color getBackgroundColor(int rank, BirthmarkEnvironment environment) {
        Color c = CompareTableCellRenderer.getColor("backcolor_" + rank, environment);
        if (c == null) {
            return CompareTableCellRenderer.getDefaultBackgroundColor(rank);
        }
        return c;
    }

    public static Color getForegroundColor(int rank, BirthmarkEnvironment environment) {
        Color c = CompareTableCellRenderer.getColor("forecolor_" + rank, environment);
        if (c == null) {
            c = CompareTableCellRenderer.getDefaultForegroundColor(rank);
        }
        return c;
    }

    private static Color getColor(String key, BirthmarkEnvironment environment) {
        String v = environment.getProperty(key);
        try {
            int color = Integer.parseInt(v, 16);
            return new Color(color >>> 16 & 0xFF, color >>> 8 & 0xFF, color & 0xFF);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

