/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import jp.sourceforge.stigmata.Birthmark;
import jp.sourceforge.stigmata.BirthmarkComparator;
import jp.sourceforge.stigmata.BirthmarkContext;
import jp.sourceforge.stigmata.BirthmarkEnvironment;
import jp.sourceforge.stigmata.BirthmarkSet;
import jp.sourceforge.stigmata.BirthmarkStoreException;
import jp.sourceforge.stigmata.ExtractionResultSet;
import jp.sourceforge.stigmata.ExtractionTarget;
import jp.sourceforge.stigmata.filter.FilteredComparisonResultSet;
import jp.sourceforge.stigmata.printer.PrinterManager;
import jp.sourceforge.stigmata.result.CertainPairComparisonResultSet;
import jp.sourceforge.stigmata.result.RoundRobinComparisonResultSet;
import jp.sourceforge.stigmata.spi.ResultPrinterSpi;
import jp.sourceforge.stigmata.ui.swing.ClassNameObfuscator;
import jp.sourceforge.stigmata.ui.swing.CompareTableCellRenderer;
import jp.sourceforge.stigmata.ui.swing.FilterSelectionPane;
import jp.sourceforge.stigmata.ui.swing.GUIUtility;
import jp.sourceforge.stigmata.ui.swing.PopupButton;
import jp.sourceforge.stigmata.ui.swing.StigmataFrame;
import jp.sourceforge.stigmata.ui.swing.actions.SaveAction;
import jp.sourceforge.stigmata.ui.swing.actions.UpdateBirthmarkCellColorAction;
import jp.sourceforge.stigmata.utils.AsciiDataWritable;
import jp.sourceforge.talisman.i18n.Messages;

public class RoundRobinComparisonResultPane
extends JPanel {
    private static final long serialVersionUID = 2134574576543623L;
    private StigmataFrame stigmata;
    private ExtractionResultSet extraction;
    private JTable table;
    private DefaultTableModel model;
    private JLabel classCount;
    private JLabel comparisonCount;
    private JLabel distinctionRatio;
    private JLabel average;
    private JLabel minimum;
    private JLabel maximum;

    public RoundRobinComparisonResultPane(StigmataFrame stigmata, ExtractionResultSet resultset) {
        this.stigmata = stigmata;
        this.extraction = resultset;
        this.initialize();
        this.compare(this.model);
    }

    private void compare(DefaultTableModel model) {
        ExtractionTarget targetX = ExtractionTarget.TARGET_X;
        ExtractionTarget targetY = ExtractionTarget.TARGET_Y;
        int countX = this.extraction.getBirthmarkSetSize(targetX);
        int countY = this.extraction.getBirthmarkSetSize(targetY);
        int comparisonCount = countX * countY;
        if (countX == 0 && countY == 0) {
            targetX = ExtractionTarget.TARGET_XY;
            targetY = ExtractionTarget.TARGET_XY;
            countX = this.extraction.getBirthmarkSetSize(targetX);
            countY = this.extraction.getBirthmarkSetSize(targetY);
            comparisonCount = countX * (countY - 1) / 2;
        } else if (countX == 0 || countY == 0) {
            targetX = ExtractionTarget.TARGET_BOTH;
            targetY = ExtractionTarget.TARGET_BOTH;
            countX = this.extraction.getBirthmarkSetSize(targetX);
            countY = this.extraction.getBirthmarkSetSize(targetY);
            comparisonCount = countX * (countY - 1) / 2;
        }
        this.classCount.setText(Integer.toString(countX + countY));
        this.comparisonCount.setText(Integer.toString(comparisonCount));
        int correct = 0;
        double avg = 0.0;
        double max = 0.0;
        double min = 100.0;
        model.addColumn("");
        Iterator<BirthmarkSet> i = this.extraction.birthmarkSets(targetX);
        while (i.hasNext()) {
            BirthmarkSet x = i.next();
            model.addColumn(x.getName());
        }
        int sizeX = this.extraction.getBirthmarkSetSize(targetX);
        Iterator<BirthmarkSet> i2 = this.extraction.birthmarkSets(targetY);
        while (i2.hasNext()) {
            Object[] rows = new Object[sizeX + 1];
            BirthmarkSet setY = i2.next();
            rows[0] = setY.getName();
            int index = 0;
            Iterator<BirthmarkSet> j = this.extraction.birthmarkSets(targetX);
            while (j.hasNext()) {
                BirthmarkSet setX = j.next();
                double similarity = this.compare(setX, setY, this.extraction.getContext());
                rows[index + 1] = new Double(similarity);
                if (Math.abs(similarity - 1.0) < 1.0E-8) {
                    ++correct;
                }
                avg += similarity;
                if (max < similarity) {
                    max = similarity;
                }
                if (min > similarity) {
                    min = similarity;
                }
                ++index;
            }
            model.addRow(rows);
        }
        this.distinctionRatio.setText(Double.toString((double)(comparisonCount - correct) / (double)comparisonCount));
        this.average.setText(Double.toString(avg /= (double)comparisonCount));
        this.minimum.setText(Double.toString(min));
        this.maximum.setText(Double.toString(max));
    }

    private double compare(BirthmarkSet x, BirthmarkSet y, BirthmarkContext context) {
        double similarity = 0.0;
        int count = 0;
        for (String type : x.getBirthmarkTypes()) {
            BirthmarkComparator comparator;
            double result;
            Birthmark b1 = x.getBirthmark(type);
            Birthmark b2 = y.getBirthmark(type);
            if (b1 == null || b2 == null || Double.isNaN(result = (comparator = context.getEnvironment().getService(type).getComparator()).compare(b1, b2, context))) continue;
            similarity += result;
            ++count;
        }
        return similarity / (double)count;
    }

    private Component getMainPane() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.model = new RoundRobinComparisonResultSetTableModel();
        this.table = new JTable(this.model);
        this.table.setDefaultRenderer(Double.class, new CompareTableCellRenderer(this.extraction.getEnvironment()));
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int row = RoundRobinComparisonResultPane.this.table.rowAtPoint(e.getPoint());
                    int col = RoundRobinComparisonResultPane.this.table.columnAtPoint(e.getPoint());
                    if (col >= 1 && col < RoundRobinComparisonResultPane.this.table.getColumnCount() && row >= 0 && row < RoundRobinComparisonResultPane.this.table.getRowCount()) {
                        BirthmarkSet b1 = RoundRobinComparisonResultPane.this.extraction.getBirthmarkSet(ExtractionTarget.TARGET_X, col - 1);
                        BirthmarkSet b2 = RoundRobinComparisonResultPane.this.extraction.getBirthmarkSet(ExtractionTarget.TARGET_Y, row);
                        RoundRobinComparisonResultPane.this.stigmata.compareDetails(b1, b2, RoundRobinComparisonResultPane.this.extraction.getContext());
                    }
                }
            }
        });
        this.table.setAutoResizeMode(0);
        this.table.setCellSelectionEnabled(true);
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(this.table);
        scroll.setWheelScrollingEnabled(true);
        panel.add((Component)scroll, "Center");
        Box south = Box.createVerticalBox();
        JPanel box1 = new JPanel(new GridLayout(1, 3));
        this.classCount = new JLabel();
        box1.add(this.classCount);
        this.comparisonCount = new JLabel();
        box1.add(this.comparisonCount);
        this.distinctionRatio = new JLabel();
        box1.add(this.distinctionRatio);
        south.add(box1);
        JPanel box2 = new JPanel(new GridLayout(1, 3));
        box2.setBorder(new TitledBorder(this.stigmata.getMessages().get("similarity.border")));
        this.average = new JLabel();
        box2.add(this.average);
        this.minimum = new JLabel();
        box2.add(this.minimum);
        this.maximum = new JLabel();
        box2.add(this.maximum);
        south.add(box2);
        this.classCount.setBorder(new TitledBorder(this.stigmata.getMessages().get("numberofclasses.border")));
        this.comparisonCount.setBorder(new TitledBorder(this.stigmata.getMessages().get("comparisoncount.border")));
        this.distinctionRatio.setBorder(new TitledBorder(this.stigmata.getMessages().get("distinctionratio.border")));
        this.average.setBorder(new TitledBorder(this.stigmata.getMessages().get("average.border")));
        this.minimum.setBorder(new TitledBorder(this.stigmata.getMessages().get("minimum.border")));
        this.maximum.setBorder(new TitledBorder(this.stigmata.getMessages().get("maximum.border")));
        panel.add((Component)south, "South");
        return panel;
    }

    private void mdsButtonActionPerformed(ActionEvent e) {
        BirthmarkSet bs;
        HashMap<URL, BirthmarkSet> map = new HashMap<URL, BirthmarkSet>();
        Iterator<BirthmarkSet> i = this.extraction.birthmarkSets(ExtractionTarget.TARGET_X);
        while (i.hasNext()) {
            bs = i.next();
            map.put(bs.getLocation(), bs);
        }
        i = this.extraction.birthmarkSets(ExtractionTarget.TARGET_Y);
        while (i.hasNext()) {
            bs = i.next();
            map.put(bs.getLocation(), bs);
        }
        int index = 0;
        BirthmarkSet[] set = new BirthmarkSet[map.size()];
        for (Map.Entry entry : map.entrySet()) {
            set[index] = (BirthmarkSet)entry.getValue();
            ++index;
        }
        this.stigmata.showMdsGraph(set, this.extraction.getContext());
    }

    private void graphButtonActionPerformed(ActionEvent e) {
        HashMap<Integer, Integer> values = new HashMap<Integer, Integer>();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            for (int j = 1; j < this.table.getColumnCount(); ++j) {
                Double d = (Double)this.table.getValueAt(i, j);
                int similarity = (int)Math.round(d * 100.0);
                Integer dist = (Integer)values.get(new Integer(similarity));
                if (dist == null) {
                    dist = new Integer(0);
                }
                dist = new Integer(dist + 1);
                values.put(new Integer(similarity), dist);
            }
        }
        this.stigmata.showSimilarityDistributionGraph(values);
    }

    private void initialize() {
        Messages messages = this.stigmata.getMessages();
        JButton save = GUIUtility.createButton(messages, "savecomparison", new SaveAction(this.stigmata, new AsciiDataWritable(){

            @Override
            public void writeAsciiData(PrintWriter out, String format) {
                ResultPrinterSpi service = PrinterManager.getInstance().getService(format);
                if (service == null) {
                    service = PrinterManager.getDefaultFormatService();
                }
                service.getComparisonResultSetPrinter().printResult(out, new RoundRobinComparisonResultSet(RoundRobinComparisonResultPane.this.extraction));
            }
        }));
        JButton graph = GUIUtility.createButton(messages, "showgraph");
        JButton obfuscate = GUIUtility.createButton(messages, "obfuscate");
        JButton compare = GUIUtility.createButton(messages, "guessedpair");
        JButton updateColor = GUIUtility.createButton(messages, "updatecellcolor", new UpdateBirthmarkCellColorAction(this.stigmata, this.extraction.getEnvironment()));
        JMenuItem mdsMenu = GUIUtility.createJMenuItem(messages, "mdsmap");
        PopupButton comparePopup = new PopupButton(compare);
        PopupButton graphPopup = new PopupButton(graph);
        Box southPanel = Box.createHorizontalBox();
        this.setLayout(new BorderLayout());
        this.add(this.getMainPane(), "Center");
        this.add((Component)southPanel, "South");
        southPanel.add(Box.createHorizontalGlue());
        southPanel.add(save);
        southPanel.add(Box.createHorizontalGlue());
        southPanel.add(updateColor);
        southPanel.add(Box.createHorizontalGlue());
        southPanel.add(graphPopup);
        southPanel.add(Box.createHorizontalGlue());
        southPanel.add(obfuscate);
        southPanel.add(Box.createHorizontalGlue());
        southPanel.add(comparePopup);
        southPanel.add(Box.createHorizontalGlue());
        graph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RoundRobinComparisonResultPane.this.graphButtonActionPerformed(e);
            }
        });
        mdsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RoundRobinComparisonResultPane.this.mdsButtonActionPerformed(e);
            }
        });
        obfuscate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RoundRobinComparisonResultPane.this.obfuscateClassNames();
            }
        });
        ActionListener compareListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String item = e.getActionCommand();
                if (item.equals("guessedpair")) {
                    RoundRobinComparisonResultPane.this.compareGuessedPair();
                } else if (item.equals("specifiedpair")) {
                    RoundRobinComparisonResultPane.this.compareSpecifiedPair();
                } else if (item.equals("roundrobin.filtering")) {
                    RoundRobinComparisonResultPane.this.compareRoundRobinWithFiltering();
                }
            }
        };
        compare.addActionListener(compareListener);
        String[] comparisonMethods = this.stigmata.getMessages().getArray("comparison.methods.inroundrobinresult");
        for (int i = 1; i < comparisonMethods.length; ++i) {
            JMenuItem item = GUIUtility.createJMenuItem(messages, comparisonMethods[i]);
            comparePopup.addMenuItem(item);
            item.addActionListener(compareListener);
        }
        graphPopup.addMenuItem(mdsMenu);
    }

    private void compareRoundRobinWithFiltering() {
        FilterSelectionPane pane = new FilterSelectionPane(this.stigmata, this.extraction.getEnvironment().getFilterManager());
        int returnValue = JOptionPane.showConfirmDialog(this.stigmata, pane, this.stigmata.getMessages().get("filterselection.dialog.title"), 2, 3);
        if (returnValue == 0) {
            String[] filterSetList = pane.getSelectedFilters();
            RoundRobinComparisonResultSet rs = new RoundRobinComparisonResultSet(this.extraction);
            FilteredComparisonResultSet filterResultSet = new FilteredComparisonResultSet(rs, this.extraction.getEnvironment().getFilterManager().getFilterSets(filterSetList));
            this.stigmata.showComparisonResultSet(filterResultSet);
        }
    }

    private void compareGuessedPair() {
        CertainPairComparisonResultSet rs = new CertainPairComparisonResultSet(this.extraction);
        this.stigmata.showComparisonResultSet(rs);
    }

    private void compareSpecifiedPair() {
        File file = this.stigmata.getOpenFile(this.stigmata.getMessages().getArray("comparemapping.extension"), this.stigmata.getMessages().get("comparemapping.description"));
        if (file != null) {
            Map<String, String> mapping = this.stigmata.constructMapping(file);
            CertainPairComparisonResultSet comparison = new CertainPairComparisonResultSet(this.extraction, mapping);
            this.stigmata.showComparisonResultSet(comparison);
        }
    }

    private void obfuscateClassNames() {
        block6: {
            ClassNameObfuscator obfuscator = new ClassNameObfuscator();
            try {
                File file = this.stigmata.getSaveFile(this.stigmata.getMessages().getArray("obfuscationmapping.extension"), this.stigmata.getMessages().get("obfuscationmapping.description"));
                if (file == null) break block6;
                BirthmarkContext context = this.extraction.getContext();
                BirthmarkEnvironment env = context.getEnvironment();
                ExtractionResultSet ers = env.getHistoryManager().createDefaultResultSet(context);
                try {
                    BirthmarkSet bs;
                    Iterator<BirthmarkSet> i = this.extraction.birthmarkSets(ExtractionTarget.TARGET_X);
                    while (i.hasNext()) {
                        bs = i.next();
                        ers.addBirthmarkSet(ExtractionTarget.TARGET_X, obfuscator.obfuscateClassName(bs));
                    }
                    i = this.extraction.birthmarkSets(ExtractionTarget.TARGET_Y);
                    while (i.hasNext()) {
                        bs = i.next();
                        ers.addBirthmarkSet(ExtractionTarget.TARGET_Y, obfuscator.obfuscateClassName(bs));
                    }
                }
                catch (BirthmarkStoreException e) {
                    // empty catch block
                }
                this.extraction = ers;
                obfuscator.outputNameMappings(file);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), this.stigmata.getMessages().get("error.dialog.title"), 0);
                return;
            }
        }
        RoundRobinComparisonResultSetTableModel model = new RoundRobinComparisonResultSetTableModel();
        this.compare(model);
        this.table.setModel(model);
        this.model = model;
    }

    private static class RoundRobinComparisonResultSetTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 765435324523543242L;

        private RoundRobinComparisonResultSetTableModel() {
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            if (column == 0) {
                return String.class;
            }
            return Double.class;
        }
    }
}

