/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import jp.sourceforge.stigmata.ui.swing.DataChangeListener;
import jp.sourceforge.stigmata.ui.swing.ExtensionFilter;
import jp.sourceforge.stigmata.ui.swing.GUIUtility;
import jp.sourceforge.stigmata.ui.swing.StigmataFrame;
import jp.sourceforge.stigmata.ui.swing.actions.PopupShowAction;
import jp.sourceforge.talisman.i18n.Messages;

public class TargetSelectionPane
extends JPanel {
    private static final long serialVersionUID = 3209435745432235432L;
    private StigmataFrame stigmata;
    private FileFilter[] filters;
    private List<String> extensions = new ArrayList<String>();
    private String description;
    private DefaultListModel model = new DefaultListModel();
    private List<DataChangeListener> listeners = new ArrayList<DataChangeListener>();
    private boolean directorySelectable = false;
    private boolean multipleSelectable = true;
    private JList list;
    private Action addAction;
    private Action removeAction;

    public TargetSelectionPane(StigmataFrame stigmata) {
        this.stigmata = stigmata;
        this.initComponents();
        this.list.setModel(this.model);
        TargetSelectionDropTarget dropTarget = new TargetSelectionDropTarget();
        this.list.setDropTarget(dropTarget);
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this.list, 2, new TargetDragGestureListener(this.list, this.model));
    }

    public void addDataChangeListener(DataChangeListener listener) {
        this.listeners.add(listener);
    }

    public void addTargetExtension(String ext) {
        if (this.filters != null) {
            this.filters = null;
        }
        this.extensions.add(ext);
    }

    public void addTargetExtensions(String[] exts) {
        if (this.filters != null) {
            this.filters = null;
        }
        for (String ext : exts) {
            this.extensions.add(ext);
        }
    }

    public void addValue(String value) {
        this.model.addElement(value);
        this.fireEvent();
    }

    public void addValues(String[] values) {
        for (String value : values) {
            this.addValue(value);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public synchronized String[] getExtensions() {
        return this.extensions.toArray(new String[this.extensions.size()]);
    }

    public FileFilter[] getFileFilters() {
        if (this.filters == null) {
            String[] exts = this.getExtensions();
            this.filters = new FileFilter[exts.length];
            for (int i = 0; i < exts.length; ++i) {
                this.filters[i] = new ExtensionFilter(exts[i], MessageFormat.format(this.getSelectDescription(), exts[i]));
            }
        }
        return this.filters;
    }

    public String getSelectDescription() {
        return this.description;
    }

    public String[] getSelectedValues() {
        int[] indeces = this.list.getSelectedIndices();
        String[] strings = new String[indeces.length];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = (String)this.model.getElementAt(indeces[i]);
        }
        return strings;
    }

    public String[] getValues() {
        String[] strings = new String[this.model.getSize()];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = (String)this.model.getElementAt(i);
        }
        return strings;
    }

    public boolean isDirectorySelectable() {
        return this.directorySelectable;
    }

    public boolean isMultipleSelectable() {
        return this.multipleSelectable;
    }

    public void removeAllElements() {
        this.model.removeAllElements();
        this.fireEvent();
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDirectorySelectable(boolean flag) {
        this.directorySelectable = flag;
    }

    @Override
    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        this.addAction.setEnabled(flag);
        this.removeAction.setEnabled(false);
        this.list.setEnabled(flag);
    }

    public void setFileFilter(FileFilter filter) {
        this.setFileFilters(new FileFilter[]{filter});
    }

    public void setFileFilters(FileFilter[] filters) {
        this.filters = filters;
    }

    public void setMultipleSelectable(boolean flag) {
        this.multipleSelectable = flag;
    }

    public void setSelectDescription(String description) {
        this.description = description;
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        File[] files;
        for (File file : files = this.stigmata.openFiles(this.getFileFilters(), true, true)) {
            this.addValue(file.getPath());
        }
    }

    private void fireEvent() {
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            DataChangeListener listener = this.listeners.get(i);
            listener.valueChanged(this.model);
        }
    }

    private void initComponents() {
        Messages messages = this.stigmata.getMessages();
        JScrollPane scroll = new JScrollPane();
        Box south = Box.createHorizontalBox();
        this.list = new JList();
        this.addAction = new AbstractAction(){
            private static final long serialVersionUID = 1406018312294328837L;

            @Override
            public void actionPerformed(ActionEvent e) {
                TargetSelectionPane.this.addButtonActionPerformed(e);
            }
        };
        this.removeAction = new AbstractAction(){
            private static final long serialVersionUID = 7910621850068803554L;

            @Override
            public void actionPerformed(ActionEvent e) {
                TargetSelectionPane.this.removeButtonActionPerformed(e);
            }
        };
        JButton addButton = GUIUtility.createButton(messages, "addpackage", this.addAction);
        JButton removeButton = GUIUtility.createButton(messages, "removepackage", this.removeAction);
        this.removeAction.setEnabled(false);
        JPopupMenu popup = new JPopupMenu();
        popup.add(GUIUtility.createJMenuItem(messages, "addpackage", this.addAction));
        popup.add(GUIUtility.createJMenuItem(messages, "removepackage", this.removeAction));
        this.setLayout(new BorderLayout());
        scroll.setViewportView(this.list);
        south.add(Box.createHorizontalGlue());
        south.add(addButton);
        south.add(Box.createHorizontalGlue());
        south.add(removeButton);
        south.add(Box.createHorizontalGlue());
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                TargetSelectionPane.this.listValueChanged(evt);
            }
        });
        this.list.addMouseListener(new PopupShowAction(popup));
        this.add((Component)scroll, "Center");
        this.add((Component)south, "South");
    }

    private void listValueChanged(ListSelectionEvent evt) {
        int[] indeces = this.list.getSelectedIndices();
        this.removeAction.setEnabled(this.isEnabled() && indeces != null);
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int[] indeces = this.list.getSelectedIndices();
        if (indeces != null && indeces.length >= 1) {
            for (int i = indeces.length - 1; i >= 0; --i) {
                this.model.removeElementAt(indeces[i]);
                this.fireEvent();
            }
        }
        this.removeAction.setEnabled(false);
    }

    private class TargetTransferable
    implements Transferable {
        private String[] strings;

        public TargetTransferable(String[] strings) {
            this.strings = strings;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            ArrayList<File> list = new ArrayList<File>();
            for (int i = 0; i < this.strings.length; ++i) {
                list.add(new File(this.strings[i]));
            }
            return list;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.javaFileListFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(DataFlavor.javaFileListFlavor);
        }
    }

    private class TargetSelectionDropTarget
    extends DropTarget {
        private static final long serialVersionUID = 3204457621345L;

        private TargetSelectionDropTarget() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent arg0) {
        }

        @Override
        public void dragExit(DropTargetEvent arg0) {
        }

        @Override
        public void dragOver(DropTargetDragEvent arg0) {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            dtde.acceptDrop(0x40000000);
            Transferable trans = dtde.getTransferable();
            try {
                List list;
                List<String> errorList;
                if (trans.isDataFlavorSupported(DataFlavor.javaFileListFlavor) && (errorList = this.checkAndAddDroppedFile(list = (List)trans.getTransferData(DataFlavor.javaFileListFlavor))).size() > 0) {
                    this.showError(errorList);
                }
            }
            catch (UnsupportedFlavorException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent arg0) {
        }

        private List<String> checkAndAddDroppedFile(List list) {
            ArrayList<String> errorList = new ArrayList<String>();
            FileFilter[] filters = TargetSelectionPane.this.getFileFilters();
            for (int i = 0; i < list.size(); ++i) {
                File file = (File)list.get(i);
                boolean neverAddedFlag = true;
                for (FileFilter filter : filters) {
                    if (!filter.accept(file)) continue;
                    TargetSelectionPane.this.addValue(file.getPath());
                    neverAddedFlag = false;
                }
                if (!neverAddedFlag) continue;
                errorList.add(file.getName());
            }
            return errorList;
        }

        private void showError(List<String> errorList) {
            StringBuilder builder = new StringBuilder("<html><body>");
            builder.append(TargetSelectionPane.this.stigmata.getMessages().get("unsupportedfiletype.dialog.message"));
            builder.append("<ul>");
            for (int i = 0; i < errorList.size(); ++i) {
                builder.append("<li>").append(errorList.get(i)).append("</li>");
            }
            builder.append("</ul></body></html>");
            JOptionPane.showMessageDialog(TargetSelectionPane.this, new String(builder), TargetSelectionPane.this.stigmata.getMessages().get("unsupportedfiletype.dialog.title"), 0);
        }
    }

    private class TargetDragGestureListener
    implements DragGestureListener {
        private JList list;

        public TargetDragGestureListener(JList list, DefaultListModel model) {
            this.list = list;
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            int[] indeces = this.list.getSelectedIndices();
            if (indeces.length > 0) {
                String[] strings = new String[indeces.length];
                for (int i = 0; i < strings.length; ++i) {
                    strings[i] = (String)TargetSelectionPane.this.model.getElementAt(indeces[i]);
                }
                TargetTransferable transferable = new TargetTransferable(strings);
                DataRemoveWhenDragSuccessfulAdapter listener = new DataRemoveWhenDragSuccessfulAdapter(TargetSelectionPane.this.model, indeces);
                dge.startDrag(DragSource.DefaultMoveDrop, transferable, listener);
            }
        }
    }

    private class DataRemoveWhenDragSuccessfulAdapter
    extends DragSourceAdapter {
        private DefaultListModel model;
        private int[] indeces;

        public DataRemoveWhenDragSuccessfulAdapter(DefaultListModel model, int[] indeces) {
            this.model = model;
            this.indeces = indeces;
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            for (int i = this.indeces.length - 1; i >= 0; --i) {
                this.model.removeElementAt(this.indeces[i]);
            }
            TargetSelectionPane.this.fireEvent();
            super.dragDropEnd(dsde);
        }
    }
}

