/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.ui.swing.graph;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jp.sourceforge.stigmata.ui.swing.GUIUtility;
import jp.sourceforge.stigmata.ui.swing.StigmataFrame;
import jp.sourceforge.stigmata.ui.swing.actions.ChangeColorAction;

public class SimilarityDistributionGraphPane
extends JPanel {
    private static final long serialVersionUID = 2314463453465L;
    private StigmataFrame stigmata;
    private Map<Integer, Integer> distributions;
    private int totalCount = 0;
    private int maxFrequency = 0;
    private JLabel iconLabel;
    private BufferedImage image;

    public SimilarityDistributionGraphPane(StigmataFrame stigmata, Map<Integer, Integer> distributions) {
        this.stigmata = stigmata;
        this.distributions = distributions;
        this.initializeLayouts();
        this.initializeData();
        this.drawGraph(Color.RED);
    }

    public String[] getSupportedFormats() {
        String[] formats = ImageIO.getWriterFormatNames();
        HashSet<String> set = new HashSet<String>();
        for (String f : formats) {
            if (f == null) continue;
            set.add(f.toLowerCase());
        }
        return set.toArray(new String[set.size()]);
    }

    private void drawGraph(Color color) {
        Graphics2D g = this.image.createGraphics();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.image.getWidth(), this.image.getHeight());
        int width = this.image.getWidth();
        int height = this.image.getHeight();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.drawBorder(g, width, height);
        g.setColor(color);
        Dimension d = new Dimension(width - 20, height - 20);
        double w = (double)d.width / 100.0;
        Integer v1 = this.distributions.get(0);
        if (v1 == null) {
            v1 = new Integer(0);
        }
        double x = 20.0;
        for (int i = 0; i <= 100; ++i) {
            Integer v2 = this.distributions.get(i);
            if (v2 == null) {
                new Integer(0);
            }
            double hh1 = (double)v1.intValue() * ((double)height / (double)this.totalCount);
            double hh2 = (double)v2.intValue() * ((double)height / (double)this.totalCount);
            g.draw(new Line2D.Double(x, (double)d.height - hh1, x + w, (double)d.height - hh2));
            x += w;
            v1 = v2;
        }
        this.iconLabel.setIcon(new ImageIcon(this.image));
    }

    private void drawBorder(Graphics2D g, int width, int height) {
        g.setColor(Color.BLACK);
        g.draw(new Line2D.Double(0.0, height - 20, width, height - 20));
        g.draw(new Line2D.Double(20.0, 0.0, 20.0, height));
        g.setColor(Color.GRAY);
        double h = (double)(height - 20) / 2.0;
        g.draw(new Line2D.Double(20.0, h, width, h));
        g.draw(new Line2D.Double(20.0, h /= 2.0, width, h));
        g.draw(new Line2D.Double(20.0, h * 3.0, width, h * 3.0));
        double w = ((double)width - 20.0) / 2.0;
        g.draw(new Line2D.Double(w + 20.0, 0.0, w + 20.0, height - 20));
        g.draw(new Line2D.Double((w /= 2.0) + 20.0, 0.0, w + 20.0, height - 20));
        g.draw(new Line2D.Double(w * 3.0 + 20.0, 0.0, w * 3.0 + 20.0, height - 20));
        g.drawString("0", 10, height - 5);
        g.drawString("50%", (width - 20) / 2 + 10, height - 5);
        g.drawString(this.stigmata.getMessages().get("similarity.label"), width - 60, height - 5);
        g.drawString("50%", 0, (height - 20) / 2);
    }

    private void initializeData() {
        this.maxFrequency = 0;
        for (int i = 0; i <= 100; ++i) {
            Integer frequency = this.distributions.get(new Integer(i));
            if (frequency == null) {
                frequency = new Integer(0);
                this.distributions.put(new Integer(i), frequency);
            }
            if (this.maxFrequency < frequency) {
                this.maxFrequency = frequency;
            }
            this.totalCount += frequency.intValue();
        }
    }

    private void initializeLayouts() {
        this.image = new BufferedImage(300, 300, 2);
        JPanel center = new JPanel(new FlowLayout(1));
        this.iconLabel = new JLabel();
        Box south = Box.createHorizontalBox();
        JButton storeImageButton = GUIUtility.createButton(this.stigmata.getMessages(), "savegraph");
        JButton switchColorButton = new JButton(new ChangeColorAction(this.stigmata, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChangeColorAction action = (ChangeColorAction)e.getSource();
                if (action.isColorSelected()) {
                    SimilarityDistributionGraphPane.this.drawGraph(action.getColor());
                }
            }
        }));
        storeImageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimilarityDistributionGraphPane.this.storeGraphImage();
            }
        });
        this.setLayout(new BorderLayout());
        this.iconLabel = new JLabel();
        center.add(this.iconLabel);
        south.add(Box.createHorizontalGlue());
        south.add(switchColorButton);
        south.add(Box.createHorizontalGlue());
        south.add(storeImageButton);
        south.add(Box.createHorizontalGlue());
        this.add((Component)center, "Center");
        this.add((Component)south, "South");
    }

    private void storeGraphImage() {
        String[] exts = this.getSupportedFormats();
        File file = this.stigmata.getSaveFile(exts, this.stigmata.getMessages().get("savegraph.description"));
        try {
            if (file != null) {
                String format = file.getName();
                format = format.substring(format.lastIndexOf(46) + 1);
                ImageIO.write((RenderedImage)this.image, format, file);
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, this.stigmata.getMessages().get("error.io", e.getMessage()), this.stigmata.getMessages().get("error.dialog.title"), 0);
        }
    }
}

