/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.ui.swing.mds;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import jp.sourceforge.talisman.i18n.MessageManager;
import jp.sourceforge.talisman.mds.Item;
import jp.sourceforge.talisman.mds.ui.swing.ItemsOpenEvent;
import jp.sourceforge.talisman.mds.ui.swing.ItemsOpenListener;
import jp.sourceforge.talisman.mds.ui.swing.ItemsSelectionEvent;
import jp.sourceforge.talisman.mds.ui.swing.ItemsSelectionListener;
import jp.sourceforge.talisman.mds.ui.swing.MdsPane;

public class OpenItemsAction
extends AbstractAction {
    private static final long serialVersionUID = 5956900396146338537L;
    private MdsPane mdsPane;
    private MessageManager mm;
    private boolean selectedItemFlag = false;

    public OpenItemsAction(MdsPane initMdsPane, MessageManager initMm) {
        super(initMm.getMessages().get("openallitems.label"));
        this.mdsPane = initMdsPane;
        this.mm = initMm;
        if (initMm.getMessages().hasValue("openitems.icon")) {
            Icon icon = initMm.getMessages().getIcon("openitems.icon");
            this.putValue("SmallIcon", icon);
        }
        initMdsPane.addItemsSelectionListener(new ItemsSelectionListener(){

            public void valueChanged(ItemsSelectionEvent e) {
                Item[] items = OpenItemsAction.this.mdsPane.getSelectedItems();
                OpenItemsAction.this.selectedItemFlag = items.length != 0;
                if (OpenItemsAction.this.selectedItemFlag) {
                    OpenItemsAction.this.putValue("Name", OpenItemsAction.this.mm.getMessages().get("openitems.label"));
                } else {
                    OpenItemsAction.this.putValue("Name", OpenItemsAction.this.mm.getMessages().get("openallitems.label"));
                }
            }
        });
        initMdsPane.addItemsOpenListener(new ItemsOpenListener(){

            public void itemOpened(ItemsOpenEvent e) {
                OpenItemsAction.this.showItems(e.getItems());
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Item[] items = this.selectedItemFlag ? this.mdsPane.getSelectedItems() : this.mdsPane.getItems();
        if (items.length > 0) {
            this.showItems(items);
        }
    }

    private void showItems(Item[] items) {
        DefaultTableModel model = new DefaultTableModel();
        model.addColumn(this.mm.getMessages().get("openitems.namelabel"));
        model.addColumn(this.mm.getMessages().get("openitems.xlabel"));
        model.addColumn(this.mm.getMessages().get("openitems.ylabel"));
        for (Item item : items) {
            Object[] values = new Object[]{item.getName(), item.get(0), item.get(1)};
            model.addRow(values);
        }
        JTable table = new JTable(model);
        JScrollPane scroll = new JScrollPane(table, 22, 32);
        JOptionPane.showMessageDialog((Component)this.mdsPane, scroll, this.mm.getMessages().get("selected.items.title"), 1);
    }
}

