/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.utils;

public final class WellknownClassJudgeRule {
    private MatchType matchType;
    private MatchPartType partType;
    private boolean excludeFlag;
    private String pattern;

    public WellknownClassJudgeRule(String pattern, MatchType matchType, MatchPartType partType) {
        this(pattern, matchType, partType, false);
    }

    public WellknownClassJudgeRule(String pattern, MatchType matchType, MatchPartType partType, boolean excludeFlag) {
        this.pattern = pattern;
        this.matchType = matchType;
        this.partType = partType;
        this.excludeFlag = excludeFlag;
    }

    public void setExclude(boolean excludeFlag) {
        this.excludeFlag = excludeFlag;
    }

    public boolean isExclude() {
        return this.excludeFlag;
    }

    public String getPattern() {
        return this.pattern;
    }

    public MatchType getMatchType() {
        return this.matchType;
    }

    public MatchPartType getMatchPartType() {
        return this.partType;
    }

    public int hashCode() {
        int m = this.getMatchType().hashCode();
        int p = this.getMatchPartType().hashCode();
        int s = this.getPattern().hashCode();
        return m + p + s;
    }

    public boolean equals(Object o) {
        if (o instanceof WellknownClassJudgeRule) {
            WellknownClassJudgeRule wcjr = (WellknownClassJudgeRule)o;
            return this.getPattern().equals(wcjr.getPattern()) && this.getMatchPartType() == wcjr.getMatchPartType() && this.getMatchType() == wcjr.getMatchType();
        }
        return false;
    }

    public String toString() {
        String string = null;
        switch (this.getMatchType()) {
            case PREFIX: {
                string = String.format("<prefix>%s</prefix>", this.getPattern());
                break;
            }
            case SUFFIX: {
                string = String.format("<suffix>%s</suffix>", this.getPattern());
                break;
            }
            case EXACT: {
                string = String.format("<match>%s</match>", this.getPattern());
                break;
            }
            case NOT_MATCH: {
                string = String.format("<not-match>%s</not-match>", this.getPattern());
            }
        }
        switch (this.getMatchPartType()) {
            case CLASS_NAME: {
                string = String.format("<class-name>%s</class-name>", string);
                break;
            }
            case FULLY_NAME: {
                string = String.format("<fully-name>%s</fully-name>", string);
                break;
            }
            case PACKAGE_NAME: {
                string = String.format("<package-name>%s</package-name>", string);
            }
        }
        if (this.isExclude()) {
            string = "<exclude>" + string + "</exclude>";
        }
        return string;
    }

    public static enum MatchPartType {
        FULLY_NAME,
        PACKAGE_NAME,
        CLASS_NAME;

    }

    public static enum MatchType {
        PREFIX,
        SUFFIX,
        EXACT,
        NOT_MATCH;

    }
}

