#version 330 core

// sandy island frag shader

in vec2 UV;
in vec4 aPos;
in float dist2obj;

out vec4 color;

uniform sampler2D myTextureSampler;
uniform int darkness=0; // 0...4=darkest (=bkgd#)
const vec4 night = vec4(0.0,0.0,0.0,1.0);






//////// insert 20dec17 begin /////////////////////////////////////
uniform int fogcolr=1; //  0=>noFog, 1=>white, 2=>brownish, 3=>purple, 4=>gray
uniform int foglevl=0; // 0=>noFog, 1=>light, 1=>Fog, 2=>heavy

const vec4 vFogColor=vec4(0.9,0.9,0.9,1.0); //normal white
const vec4 vDfogColor=vec4(0.7,0.7,0.7,1.0); //normal gray
const vec4 vSootColor=vec4(50.0/255,30.0/255,10.0/255,1.0); // brown
const vec4 vMystColor=vec4(0.7,0.5,0.7,1.0); // purple
//////// insert 20dec17 end /////////////////////////////////////




const float fStart=0.0;
const float lEnd=20.0; // light fog
const float fEnd=12.0; // normal fog
const float hEnd= 8.0; // heavy fog

float getFogFactor(float rng)
{

	float fResult = (lEnd-rng)/(lEnd-fStart);
	if( foglevl>1 ) fResult = (fEnd-rng)/(fEnd-fStart);
	if( foglevl>2 ) fResult = (hEnd-rng)/(hEnd-fStart);
	
	fResult = 1.0-clamp(fResult, 0.0, 1.0);
	
	return sqrt(fResult);
}



// this is primarily for sandy island atoll


void main(){
	color = texture( myTextureSampler, UV).rgba;
	if( color.a < 0.1 ) discard;

	float df=0;
	if( darkness < 1 ) df=0.2;
	else if( darkness==1 ) df=0.4;
	else if( darkness==2 ) df=0.5;
	else if( darkness==3 ) df=0.6;
	else if( darkness>3 ) df=0.7;
	float asave=color.a;
	color = mix(color, night, df);

	if(foglevl>0) {
		const float yc=-1.0;
		float dist = exp(-1.0*abs(aPos.y-yc)) * dist2obj;

		if( fogcolr==4 )
			color = mix(color,  vDfogColor, getFogFactor(dist)); //gray
		else if( fogcolr==3 )
			color = mix(color, vMystColor, getFogFactor(dist)); //purple
		else if( fogcolr==2 )
			color = mix(color, vSootColor, getFogFactor(dist)); //brown
		else if( fogcolr==1 )
			color = mix(color,  vFogColor, getFogFactor(dist)); //white

	}

	color.a = asave;

}


//--
//-- Copyright (C) 2018  <fastrgv@gmail.com>
//--
//-- This program is free software: you can redistribute it and/or modify
//-- it under the terms of the GNU General Public License as published by
//-- the Free Software Foundation, either version 3 of the License, or
//-- (at your option) any later version.
//--
//-- This program is distributed in the hope that it will be useful,
//-- but WITHOUT ANY WARRANTY; without even the implied warranty of
//-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//-- GNU General Public License for more details.
//--
//-- You may read the full text of the GNU General Public License
//-- at <http://www.gnu.org/licenses/>.
//--

