
separate (gameutils)

procedure island_texture_setup is 

-- prepares beach textures
-- only called once...which implies any
-- keepouts must be redefined in main.


	use cubemapobj;
	use myrockobj;
	use mylean2obj;



	use interfaces.c;
	use interfaces.c.strings;
	use glext;
	use glext.pointers;
	use glext.binding;
	use gl.binding;
	use gl.pointers;

	fi : float;



	-- facilitates addition of flora:
	procedure initpalm( ptype: plant_type; xc,yc,zc, xr,yr,zr: float) is
		i : integer;
	begin
		myassert( npt >= 0, 109 );
		myassert( npt <= npalms-1, 110 );
		i:=npt+1;

		pxc(i):=xc; pyc(i):=yc; pzc(i):=zc;
		pxr(i):=xr; pyr(i):=yr; pzr(i):=zr;

		plant(i):=ptype;

		npt := npt+1;

	end initpalm;

	zz,bb: float;

begin ---------- setup ---------------------


----- prepare skybox, reflective water


	moon_cubemap_texid := loadCubePng(
	"data/skyBoxes/moon/lf.png",	"data/skyBoxes/moon/rt.png",
	"data/skyBoxes/moon/up.png",	"data/skyBoxes/moon/dn.png",
	"data/skyBoxes/moon/fr.png",	"data/skyBoxes/moon/bk.png");

	-- very nice colorful Sargasso Sea Sky:
	sargas_cubemap_texid := loadCubePng(
	"data/skyBoxes/sargasso/ss_ft.png",	"data/skyBoxes/sargasso/ss_bk.png",
	"data/skyBoxes/sargasso/ss_up.png",	"data/skyBoxes/sargasso/ss_dn.png",
	"data/skyBoxes/sargasso/ss_rt.png",	"data/skyBoxes/sargasso/ss_lf.png" );



	-- lovely...Best daytime.
	tropical_cubemap_texid := loadCubePng(
	"data/skyBoxes/tropicalsun/slt.png",	"data/skyBoxes/tropicalsun/srt.png",
	"data/skyBoxes/tropicalsun/supb.png",	"data/skyBoxes/tropicalsun/sdn.png",
	"data/skyBoxes/tropicalsun/sfr.png",	"data/skyBoxes/tropicalsun/sbk.png"	);

	-- extended by 100 pix then trimmed to 1024:
	-- blue clouds, pre-tropical-rainstorm day (nice ocean color)
	blue_cubemap_texid := loadCubePng(
	"data/skyBoxes/clouds/bluft.png",	"data/skyBoxes/clouds/blubk.png",
	"data/skyBoxes/clouds/bluup.png",	"data/skyBoxes/clouds/bludn.png",
	"data/skyBoxes/clouds/blurt.png",	"data/skyBoxes/clouds/blulf.png" ); --Ok



	-- interesting but makes water an ugly brownish:
	sunset_cubemap_texid := loadCubePng(
	"data/skyBoxes/sunset/lt.png",	"data/skyBoxes/sunset/rt.png",
	"data/skyBoxes/sunset/up.png",	"data/skyBoxes/sunset/dn.png",
	"data/skyBoxes/sunset/fr.png",	"data/skyBoxes/sunset/bk.png" );






	--mpidSkyB
	pidskyb31:= LoadShaders( "data/oskyFog.vs", "data/sky.fs" ); --13dec17
	imvp31 := glGetUniformLocation( pidskyb31, pmvp );     
	cmap31 := glGetUniformLocation( pidskyb31, pcubemap );     
	flev31  := glgetuniformlocation(pidskyb31, pmylev); -- 13dec17
	fcol31  := glgetuniformlocation(pidskyb31, pmyclr); -- 13dec17


	-- awesome sinusoidal beach foam:  disappearing blobs,
	-- now with positional phase-offset, green @ shallows
	-- foam trailing wave peaks plus beach foam
	-- this variation adds a dominant circular wave
	--perfect on all hardware, new:
	--mpidSkyW 
	pidskyw32:= LoadShaders( "data/aoiwater.vs", "data/aoiwater.fs" ); 

	cubemapobj.setrect( skybox, mxpcen,mypcen,mzpcen, mrad,myrad,mrad );

	hmax32 := glgetuniformlocation(pidskyw32, phmax);
	r1id32 := glgetuniformlocation(pidskyw32, pr1);
	r2id32 := glgetuniformlocation(pidskyw32, pr2);

	imvp32  := glgetuniformlocation(pidskyw32, pmvp);
	envm32   := glgetuniformlocation(pidskyw32, penvMap);
	time32  := glgetuniformlocation(pidskyw32, pmytime);
	wlev32  := glgetuniformlocation(pidskyw32, pwaterlevel);
	irad32  := glgetuniformlocation(pidskyw32, pwRad);
	icen32  := glgetuniformlocation(pidskyw32, pwPos);
	ieye32  := glgetuniformlocation(pidskyw32, peyePos);

	flev32  := glgetuniformlocation(pidskyw32, pmylev); -- 13dec17
	fcol32  := glgetuniformlocation(pidskyw32, pmyclr); -- 13dec17

	sea.setround(ocean, 0.0, r3); --now used for lagoon too






	-- ZPM setup:
	--bary0 := -0.035 + sandht(barx,barz,hmax,mwaterlevel,r1,r2);
	bary0 := sandht(barx,barz,hmax,mwaterlevel,r1,r2); --25may18

	mposbar(1):=barx-1.0*mrolldist;
	mposbar(3):=barz+2.0*mrolldist;
	--bary := -0.04 + barad + 
	bary := -0.02 + barad +  --25may18
		sandht( mposbar(1), mposbar(3), hmax,mwaterlevel,r1,r2);
	mposbar(2):= bary;

	cyl2obj.setcyl2( mbarrel, mposbar(1),mposbar(2),mposbar(3), barad );
	pictobj.setrect( msokrcpt, barx,bary0,barz, 
		barad*1.5,0.0001,barad*1.5, 
		xm,xp,ym,yp,zm,zp); --discard these last 6


---------- prepare textured objects begin ----------- 
-----------------------------------------------------

	-- fish.  Now only 1 object for each type of fish.

	-- orbit center:
	fishx:= -7.0;  fishy:= mwaterlevel-0.04;  fishz:= -7.0;


	-- school of piranha
	fdx:= 0.00001; fdy:= 0.04; fdz:= 0.08;
	myfish.setrect( pfish,  fdx,fdy,fdz );




	-- dimensions:
	-- tropical fish:  the narrow dimension is X
	fdx:= 0.00001; fdy:= 0.015; fdz:= 0.05;

	myfish.setrect( mfish, fdx,fdy,fdz );

	myfish.setrect( bfish, fdx,fdy,fdz );

	-- stingray:  the narrow dimension is Y
	myfish.setrect( rfish,  0.05, 0.0001, 0.15 );

	-- shark swimming around entire island
	sharky := mwaterlevel-0.02;
	myfish.setrect( sfish,  0.0001, 0.06, 0.3 );

	-- serpent (thinner to hide upper texture edge 21aug16)
	longfish.setrect( serpent,  0.00001, 0.05, 0.5 );



	-- snake
	--snake_texid := loadPng(pngloader.clamp,"data/hb2.png");
	snake_texid := loadPng(pngloader.clamp,"data/mamba.png");
	longtube.setrect( snake, 0.005, 0.005, 0.2);
	-- note that I will need 3 or more segments in each of the 
	-- X and Y directions in order that fishw.vs be able to
	-- "round out" the rectangular coords to a cylinder.




	mfish_texid := loadPng(pngloader.clamp,"data/multi_tropical_fish.png");
	bfish_texid := loadPng(pngloader.clamp,"data/blue_tropical_fish.png");
	pfish_texid := loadPng(pngloader.mirror,"data/p1.png");
	rfish_texid := loadPng(pngloader.mirror,"data/stingrayt.png");
	sfish_texid := loadPng(pngloader.clamp,"data/shark1c.png");
	serpent_texid := loadPng(pngloader.clamp,"data/serpent.png");





	-- SOS message on sand
	sosx:=0.0;
	sosz:=7.0;
	sosy:= 0.00 + sandht(sosx,sosz,hmax,mwaterlevel,r1,r2);
	pictobj.setrect(sos, sosx,sosy,sosz, 0.5,0.01,0.5, j1,j2,j3,j4,j5,j6 );
	sos_texid := loadPng(pngloader.mirror,"data/sos2.png");

	-- stargate:
	pbase := -0.01 + sandht(gatex,gatez,hmax,mwaterlevel,r1,r2);
	gatey := pbase+gdy+0.04;
	pictobj.setrect(gate,gatex,gatey,gatez,gdx,gdy,gdz,j1,j2,j3,j4,j5,j6);
	gate0_texid := loadPng(pngloader.mirror,"data/stargate_off.png");
	gate_texid := loadPng(pngloader.mirror,"data/stargate_texture.png");

	--gateTexShadID 
	pidgate33:= LoadShaders( "data/stgate.vs", "data/stgate.fs" );
	imvp33 := glGetUniformLocation( pidgate33, pmvp );     
	samp33 := glGetUniformLocation( pidgate33, pmyts );
	dark33 := glGetUniformLocation( pidgate33, pdark );



---------- insert begin kwhoosh -------------------------------------------

	--3apr18
	xxkwh:=glfloat(gatex);
	yykwh:=glfloat(gatey);
	zzkwh:=glfloat(gatez);

---------- insert end kwhoosh -------------------------------------------

-- begin setup framework for stargate:

	pcy := pdy + pbase;
	topy := pcy+pdy+pdr2;
	boty := pcy-pdy;

	pictobj.setrect( pillar1, -- side pillar
		gatex-gdx-pdr2, pcy, gatez, 
			pdr2,pdy,pdr2, j1,j2,j3,j4,j5,j6);

	pictobj.setrect( pillar2, -- side pillar
		gatex+gdx+pdr2, pcy, gatez, 
			pdr2,pdy,pdr2, j1,j2,j3,j4,j5,j6);

	pictobj.setrect( pillar3,  -- top cross bar
		gatex, topy, gatez, 
			(gdx+pdr2+pdr2),pdr2,pdr2, j1,j2,j3,j4,j5,j6);

	pictobj.setrect( pillar4, --broad bottom step
		gatex, boty, gatez, 
			(gdx),pdx,12.0*pdx, j1,j2,j3,j4,j5,j6);

	pictobj.setrect( pillar5, -- narrower top step
		gatex, boty+pdx, gatez, 
			(gdx-0.01),pdx,6.0*pdx, j1,j2,j3,j4,j5,j6);
			-- give this top step slightly different width
			-- to avoid texture flipping

	pillar1_texid := loadPng(pngloader.mirror,"data/wick3t.png");
	pillar2_texid := loadPng(pngloader.mirror,"data/wick3w.png");



-- end setup framework for stargate:



-- begin DHD ----------------------------------------

	--dhdx:=gatex;
	dhdx:=gatex-0.5; --4apr18
	--dhdz:=gatez+0.9;
	dhdz:=gatez+0.5; --4apr18
	dhdr:=pdr2;
	dhdh:=0.05; -- this is 1/2 height [= vertical radius] of DHD

	dhdy:= dhdh + sandht(dhdx,dhdz,hmax,mwaterlevel,r1,r2) - 0.02;


	myassert( dhdy+dhdh < 0.0, 111 ); -- assumption made in pickleft

	pictobj.setrect( dhdface,  -- DHD face
		dhdx, dhdy+dhdh+0.001, dhdz, 
			0.7*dhdr,0.0001,0.7*dhdr, j1,j2,j3,j4,j5,j6);

	dhd0_texid := loadPng(pngloader.mirror,"data/offdhd0.png");
	dhdo_texid := loadPng(pngloader.mirror,"data/ondhd0.png");

	dhd1_texid := loadPng(pngloader.mirror,"data/on1dhd0.png"); --alpha adobe
	dhd2_texid := loadPng(pngloader.mirror,"data/on2dhd0.png"); --lambda lumber
	dhd3_texid := loadPng(pngloader.mirror,"data/on3dhd0.png"); --beta brick
	dhd4_texid := loadPng(pngloader.mirror,"data/on4dhd0.png"); --gamma granite

	adobe2_texid := loadPng(pngloader.mirror,"data/myadobeT.png");

	wood_texid := loadPng(pngloader.mirror,"data/woodenceiling.png");--woodenpillar

	brick_texid:= loadPng(pngloader.mirror,"data/bricksf.png");

	dhdrad:=0.5*dhdr;
	pictobj.setrect( dhdp1,  -- alpha (adobe)
		dhdx+dhdrad, dhdy, dhdz+dhdrad, 
			dhdrad,dhdh,dhdrad, j1,j2,j3,j4,j5,j6);

	pictobj.setrect( dhdp2,  -- beta (wood)
		dhdx-dhdrad, dhdy, dhdz+dhdrad, 
			dhdrad,dhdh,dhdrad, j1,j2,j3,j4,j5,j6);

	pictobj.setrect( dhdp3,  -- gamma (brick)
		dhdx-dhdrad, dhdy, dhdz-dhdrad, 
			dhdrad,dhdh,dhdrad, j1,j2,j3,j4,j5,j6);

	pictobj.setrect( dhdp4,  -- delta (granite)
		dhdx+dhdrad, dhdy, dhdz-dhdrad, 
			dhdrad,dhdh,dhdrad, j1,j2,j3,j4,j5,j6);



-- end DHD ----------------------------------------




	-- sandy island:
	isandy.setround( island,  0.0,0.0, r3, hmax,mwaterlevel,r1,r2 );
	island_texid := loadPng(pngloader.mirror,"data/sand_texture2.png");
	-- note that loadPng uses mirrored_repeat texture wrapping


	--mystnonTexShadID 
	pidzpm34:= LoadShaders( "data/nontex.vs", "data/nontex.fs" );
	imvp34 := glGetUniformLocation( pidzpm34, pmvp );     


	--mystpgmTexShadID 
	pidpgm35 := LoadShaders( "data/island.vs", "data/island.fs" );
	ieye35 := glGetUniformLocation( pidpgm35, pme );     
	imvp35 := glGetUniformLocation( pidpgm35, pmvp );     
	samp35 := glGetUniformLocation( pidpgm35, pmyts );     
	dark35 := glGetUniformLocation( pidpgm35, pdark );     
	flev35 := glGetUniformLocation( pidpgm35, pmylev ); --14dec17
	fcol35 := glGetUniformLocation( pidpgm35, pmyclr ); --14dec17

	-- rocks&coconut:
	--rockTexShadID 
	pidrock36:= LoadShaders( "data/rockFog.vs", "data/island.fs" );

	ieye36 := glGetUniformLocation( pidrock36, pme );     
	flev36 := glGetUniformLocation( pidrock36, pmylev ); --14dec17
	fcol36 := glGetUniformLocation( pidrock36, pmyclr ); --14dec17

	imvp36 := glGetUniformLocation( pidrock36, pmvp );     
	samp36 := glGetUniformLocation( pidrock36, pmyts );     
	dark36 := glGetUniformLocation( pidrock36, pdark );     
	rock_texid := loadPng(pngloader.mirror,"data/granitergb.png"); --granite
	coco_texid := loadPng(pngloader.mirror,"data/coconut.png"); --coconut
	skull_texid := loadPng(pngloader.mirror,"data/skully.png"); --humanskull
	arm_texid := loadPng(pngloader.mirror,"data/humerus.png"); --arm
	fishbones_texid := loadPng(pngloader.mirror,"data/fishbone5.png"); --fishbones
	log_texid := loadPng(pngloader.mirror,"data/burntlog3.png"); --burntlog

	-- sign (Gardner Island):
	gard_texid := loadPng(pngloader.mirror,"data/sign0.png"); --sign
	irad36 := glGetUniformLocation( pidrock36, pwrad );
	icen36 := glGetUniformLocation( pidrock36, pwpos );


	stexsurf.setrect(item);

	-- skull:
	--skcy := -2.0*skry + sandht(skcx,skcz,hmax,mwaterlevel,r1,r2);
	skcy := -1.0*skry + sandht(skcx,skcz,hmax,mwaterlevel,r1,r2); --25may18

	-- arm:
	--lgcy := -2.2*lgry + sandht(lgcx,lgcz,hmax,mwaterlevel,r1,r2);
	lgcy := -1.0*lgry + sandht(lgcx,lgcz,hmax,mwaterlevel,r1,r2); --25may18


	-- fishbones:
	fbcy := -0.7*fbry + sandht(fbcx,fbcz,hmax,mwaterlevel,r1,r2);


	-- burntlog:
	blcy :=  -0.9*blry + sandht(blcx,blcz,hmax,mwaterlevel,r1,r2);



	-- coconut:
	r1cy := 0.75*r1ry+sandht(r1cx,r1cz,hmax,mwaterlevel,r1,r2);
	myrockobj.setrect(rococo, j1,j2,j3,j4,j5,j6);

	-- the 2 rocks are setup in island_ftn

-- begin 2 small palm trees & 1 tall palm & 2 bamboo clumps =========


-- begin 1st small palm
	--mxc:=3.0;  mzc:=4.0;  
	mxc:=2.5;  mzc:=3.5;  
	slev := sandht(mxc,mzc,hmax,mwaterlevel,r1,r2);
	rr:=0.4;  myr:=0.4;
	myc := myr + slev - 0.06;
	initpalm(spalm, mxc,myc,mzc, rr, myr, rr);

-- end 1st palm

-- begin 2nd small palm
	mxc:=3.3;  mzc:=4.3;  --same short,wide
	slev := sandht(mxc,mzc,hmax,mwaterlevel,r1,r2);
	myc := myr + slev - 0.02;
	initpalm(spalm, mxc,myc,mzc, rr, myr, rr);

-- end 2nd palm


-- begin 3rd [fat] palm
	--mxc:=-4.0;  mzc:=3.0;
	mxc:=-1.4;  mzc:=4.2;
	slev := sandht(mxc,mzc,hmax,mwaterlevel,r1,r2);
	rr:=0.4;   
	myr:=0.4;
	myc:=myr+slev -0.05;
	initpalm(fpalm, mxc,myc,mzc, rr, myr, rr);

-- end 3rd palm

	-- begin tall palm 4..8
	for i in 1..5 loop
		fi := float(i)/5.0;
		mxc:= r1*fmath.sin(fi*twopi+0.5);
		mzc:= r1*fmath.cos(fi*twopi+0.5);
		slev := sandht(mxc,mzc,hmax,mwaterlevel,r1,r2);
		rr:=0.41;
		myr:=0.7;
		myc:=myr+slev - 0.02;
		initpalm(tpalm, mxc,myc,mzc, rr, myr, rr);

-- reminder:  r1r*==0.01

		if i=1 or i=5 then -- precludes flying coconuts?
			ccx(i):=mxc+0.1;
			ccz(i):=mzc+0.1;
		else
			ccx(i):=mxc-0.1;
			ccz(i):=mzc-0.1;
		end if;
		ccy(i):=0.5*r1ry+sandht(ccx(i),ccz(i),hmax,mwaterlevel,r1,r2);

	end loop;


-----------------------------------------
-- nprng => i in [ 1..16] 
-----------------------------------------
-- spalm => i in [ 1.. 2]		 
-- fpalm => i in [ 3.. 3]
-- tpalm => i in [ 4.. 8]		 
-- bamboo=> i in [ 9..11]		
-- grass => i in [12..14]		
-- tgrass=> i in [15..16]		
-----------------------------------------



-- begin 1st bamboo
	mxc:=-3.5;  mzc:=-3.5;  
	slev := sandht(mxc,mzc,hmax,mwaterlevel,r1,r2);
	rr:=0.3;   myr:=0.4;
	myc:=myr+slev -0.02;
	initpalm(bamboo, mxc,myc,mzc, rr, myr, rr);
-- end 1st bamboo

-- begin 2nd bamboo
	mxc:=-4.5;  mzc:=-2.5;
	slev := sandht(mxc,mzc,hmax,mwaterlevel,r1,r2);
	myc:=myr+slev -0.02;
	initpalm(bamboo, mxc,myc,mzc, rr, myr, rr);
-- end 2nd bamboo

-- begin 3rd bamboo
	mxc:=-3.5;  mzc:=-2.5;
	slev := sandht(mxc,mzc,hmax,mwaterlevel,r1,r2);
	myc:=myr+slev -0.04;
	initpalm(bamboo, mxc,myc,mzc, rr, myr, rr);
-- end 3rd bamboo




--25may18: raised most grasses from -0.05 to -0.02

-- begin 1st grass clump
	mxc:=4.8;  mzc:=0.0;  
	rr:=0.08;   myr:=0.1;  -- same as 1st palms ( rr=0.3 | y: [sand..0.8] )
	myc:=-0.02 + myr+sandht(mxc,mzc,hmax,mwaterlevel,r1,r2);
	initpalm(cgrass, mxc,myc,mzc, rr, myr, rr);

-- begin 2nd grass clump
	mxc:=4.5;  mzc:=-1.0;
	myr:=0.08;  
	myc:= -0.02 + myr + sandht(mxc,mzc,hmax,mwaterlevel,r1,r2);
	initpalm(cgrass, mxc,myc,mzc, rr, myr, rr);

-- begin 3rd grass clump
	mxc:=4.35;  mzc:=-1.5;
	myr:=0.07;  
	myc:= -0.02 + myr + sandht(mxc,mzc,hmax,mwaterlevel,r1,r2);
	initpalm(cgrass, mxc,myc,mzc, rr, myr, rr);




-- begin 1st tall grass
	mxc:=-1.5;  mzc:=-4.6;  
	rr:=0.05;   myr:=0.06;  -- same as 1st palms ( rr=0.3 | y: [sand..0.8] )
	myc:= -0.02 + myr + sandht(mxc,mzc,hmax,mwaterlevel,r1,r2);
	initpalm(tgrass, mxc,myc,mzc, rr, myr, rr);


-- begin 2nd tall grass
	mxc:=-1.7;  mzc:=-4.65;
	myr:=0.07; 
	myc:= -0.02 + myr + sandht(mxc,mzc,hmax,mwaterlevel,r1,r2);
	initpalm(tgrass, mxc,myc,mzc, rr, myr, rr);

-- end 2nd tall grass





-- begin seaweed prep: ---------------------------------------

------------------------------
-- nwrng = [1..69] seaweed
------------------------------

	rr := 0.12;
	myr := 0.09;

	-- new coords centered on Electra nose:
	mxc := r4cx; -- -3.8;
	mzc := r4cz; -- -3.3;

	rad := 0.25;
	ddr := 0.005;

	xtreeobj.setrect( seaweed );

	for i in nwrng loop

		rad := rad + ddr;
		angl := twopi * (float(i)-1.0-7.0*rad)/9.0;
		ddxx := fmath.sin(angl)*rad;
		ddzz := fmath.cos(angl)*rad;

		yysw := sandht(mxc+ddxx,mzc+ddzz,hmax,mwaterlevel,r1,r2);
		weedbase(i):=glfloat(yysw);

		nwx(i):= mxc+ddxx-rr;
		pwx(i):= mxc+ddxx+rr;
		nwy(i):= myr+yysw-myr;
		pwy(i):= myr+yysw+myr;
		nwz(i):= mzc+ddzz-rr;
		pwz(i):= mzc+ddzz+rr;

	end loop; -- for i

-- end seaweed prep: ---------------------------------------


-- begin sandweed prep: ---------------------------------------

------------------------------
-- nsrng = [1..30] sanweed
------------------------------

	rr := 0.08; --0.12;
	xtreeobj.setrect( sanweed );

	for i in nsrng loop
		ddr := -0.5 + (float(i)-1.0)/float(nsanweed); -- -.5,+.5
		angl := -eighthpi + 0.2 * ddr; --anglspread*ddr
		zz:=1.0-abs(ddr); --size factor [0.5..1.0..0.5]

		if i mod 3 = 0 then
			rad:=4.25; --4.4;
			myr := 0.09*zz;
			bb:=-0.02; -- -0.04;
		elsif i mod 3 = 1 then
			rad:=4.2;
			myr := 0.08*zz;
			bb:=-0.01; -- -0.03; 25may18 adjustment
		else
			rad:=4.3; --4.6;
			myr := 0.07*zz;
			bb:=-0.02; -- -0.05;
		end if;

		sxc:=rad*fmath.sin(angl);
		szc:=rad*fmath.cos(angl);

		yysw := sandht(sxc,szc,hmax,mwaterlevel,r1,r2);
		seedbase(i):=glfloat(yysw+bb);

		nsx(i):= sxc-rr*zz;
		psx(i):= sxc+rr*zz;
		nsy(i):= bb+yysw;
		psy(i):= bb+yysw+2.0*myr;
		nsz(i):= szc-rr*zz;
		psz(i):= szc+rr*zz;

	end loop; -- for i

-- end sandweed prep: ---------------------------------------







--myassert( 15 = nprng'last, 112 );

	w3treeobj.setrect(palm); 

	for i in nprng loop
		palmbase(i):= glfloat(pyc(i)-pyr(i));
		nx(i):=pxc(i)-pxr(i);
		px(i):=pxc(i)+pxr(i);
		ny(i):=pyc(i)-pyr(i);
		py(i):=pyc(i)+pyr(i);
		nz(i):=pzc(i)-pzr(i);
		pz(i):=pzc(i)+pzr(i);
	end loop; -- for i

	palm_texid := loadPng(pngloader.mirror,"data/palm2.png");
	tpalm_texid := loadPng(pngloader.mirror,"data/tallpalm1.png");
	fpalm_texid := loadPng(pngloader.mirror,"data/palm3s.png");
	--bamb_texid := loadPng(pngloader.mirror,"data/bamboo5.png");tooTransparent
	bamb_texid := loadPng(pngloader.mirror,"data/bamboo6.png");
	cgrass_texid := loadPng(pngloader.mirror,"data/grass_clump.png");
	tgrass_texid := loadPng(pngloader.mirror,"data/grass_tall.png");


	--palmTexShadID 
	pidpalm37 := LoadShaders( "./data/windtree.vs", "./data/otex.fs" );

	ieye37 := glGetUniformLocation( pidpalm37, pme );     
	flev37 := glGetUniformLocation( pidpalm37, pmylev );     
	fcol37 := glGetUniformLocation( pidpalm37, pmyclr );     

	imvp37 := glGetUniformLocation( pidpalm37, pmvp );     
	samp37 := glGetUniformLocation( pidpalm37, pmyts );     
	dark37 := glGetUniformLocation( pidpalm37, pdark );     
	time37 := glGetUniformLocation( pidpalm37, pmytime );     
	trid37 := glGetUniformLocation( pidpalm37, ppid );     
	base37 := glGetUniformLocation( pidpalm37, psand );     
	irad37 := glGetUniformLocation(pidpalm37, pwrad); --// vec3
	icen37 := glGetUniformLocation(pidpalm37, pwpos); --// vec3

-- end 2 small palm trees & 1 tall palm & 2 bamboo clumps ==========



-- begin lean-to ===================================================

	--lean2TexShadID 
	pidlean38:= LoadShaders( "data/rockoFog.vs", "data/island.fs" );

	ieye38 := glGetUniformLocation( pidlean38, pme );     
	flev38  := glGetUniformLocation(pidlean38, pmylev);
	fcol38  := glGetUniformLocation(pidlean38, pmyclr);

	imvp38  := glGetUniformLocation(pidlean38, pmvp);
	samp38   := glGetUniformLocation(pidlean38, pmyts );
	dark38   := glGetUniformLocation(pidlean38, pdark );
	irad38 := glGetUniformLocation(pidlean38, pwrad); --// vec3
	icen38 := glGetUniformLocation(pidlean38, pwpos); --// vec3

	--lean2_texid := loadPNG(pngloader.mirror,"./data/roof2w.png");
	lean2_texid := loadPNG(pngloader.mirror,"./data/roof2.png");

	l2yc:= -0.06 + 0.5*l2xr + sandht(l2xc,l2zc, hmax, mwaterlevel, r1,r2);

-- end lean-to =====================================================



-- begin burnt logs ==================================================

	--logTexShadID 
	pidlog39 := LoadShaders( "data/rockz.vs", "data/islandobj.fs" );
	imvp39 := glGetUniformLocation(pidlog39, pmvp);
	samp39 := glGetUniformLocation(pidlog39, pmyts );
	dark39 := glGetUniformLocation(pidlog39, pdark );
	irad39 := glGetUniformLocation(pidlog39, pwrad); --// vec3
	icen39 := glGetUniformLocation(pidlog39, pwpos); --// vec3

-- end burnt logs ===================================================



-- begin starfish/crab ==============================================

	--crabTexShadID 
	pidcrab40 := LoadShaders( "data/rocky2.vs", "data/islandobj.fs" );
	imvp40  := glGetUniformLocation(pidcrab40, pmvp);
	samp40   := glGetUniformLocation(pidcrab40, pmyts );
	dark40   := glGetUniformLocation(pidcrab40, pdark );
	irad40 := glGetUniformLocation(pidcrab40, pwrad); --// vec3
	icen40 := glGetUniformLocation(pidcrab40, pwpos); --// vec3
	angl40 := glGetUniformLocation(pidcrab40, pangl); -- float 0..twopi

	crab_texid := loadPNG(pngloader.mirror,"./data/Crab.png");
	star_texid := loadPNG(pngloader.mirror,"./data/starfish2.png");

	mxc:=-5.0;	   mzc:=-5.0;
	mxr:=0.05;	mzr:=0.05;	myr:=0.02;
	myc := -0.5*myr + sandht(mxc,mzc, hmax, mwaterlevel, r1, r2);

	c1cx:=(mxc); c1cy:=(myc); c1cz:=(mzc);
	c1rx:=(mxr); c1ry:=(myr); c1rz:=(mzr);
	--stexsurf.setRect(crab, mxc,myc,mzc, mxr,myr,mzr); -- crab

	mxc:=-4.6;	mzc:=-5.2;  
	myr:=0.02;
	myc := -0.5*myr + sandht(mxc,mzc, hmax, mwaterlevel, r1, r2);
	s1cx:=(mxc);  s1cy:=(myc);  s1cz:=(mzc);
	s1rx:=(mxr);  s1ry:=(myr);  s1rz:=(mzr);
	--stexsurf.setRect(star, s1cx,s1cy,s1cz, s1rx,s1ry,s1rz); -- starfish


	-- jar of freckle cream
	fxr:=0.02; 	fzr:=0.02; 	
	fyr:=0.02; -- use -0.93*fyr

	fxc:=4.2; 	fzc:=3.0; 	
	fyc := -0.5*fyr + sandht(fxc,fzc, hmax, mwaterlevel, r1, r2);

	frek_texid := loadPng(pngloader.mirror,"data/freckle.png");

-- end starfish/crab =================================================


	-- nose:
	--noseTexShadID 
	pidnose41 := LoadShaders( "./data/nose.vs", "./data/islandobj.fs" );
	imvp41 := glGetUniformLocation( pidnose41, pmvp );     
	samp41 := glGetUniformLocation( pidnose41, pmyts );     
	dark41 := glGetUniformLocation( pidnose41, pdark );     
	nose_texid := loadPng(pngloader.mirror,"data/nose3.png"); --LockheedElectraNose
	irad41 := glGetUniformLocation( pidnose41, pwrad );
	icen41 := glGetUniformLocation( pidnose41, pwpos );

	-- note:  sandht(r4cx,r4cz)= -0.3197 versus r4cy=-1.48=water-1.23
	r4cxn:=r4cx-0.0;
	r4czn:=r4cz-0.05;
	r4cyn:=r4cy+0.05;

	ntexsurf.setrect(nose);
	ctexsurf.setrect(cpit);

	-- cockpit:
	--cpitTexShadID 
	pidcpit42 := LoadShaders( "./data/cockpit.vs", "./data/islandobj.fs" );
	imvp42 := glGetUniformLocation( pidcpit42, pmvp );     
	samp42 := glGetUniformLocation( pidcpit42, pmyts );     
	dark42 := glGetUniformLocation( pidcpit42, pdark );     
	cpit_texid := loadPng(pngloader.mirror,"data/cockpit2.png"); --LockheedElectraNose
	irad42 := glGetUniformLocation( pidcpit42, pwrad );
	icen42 := glGetUniformLocation( pidcpit42, pwpos );




	-- sandht@sign= -0.23
	--sign
	sxr:=0.05;
	syr:=0.01;
	szr:=0.15;
	sxc:=-4.7;
	szc:=-1.7;
	--syc:= -0.03 + syr + sandht(sxc,szc,hmax,mwaterlevel,r1,r2);
	syc:=  -0.5*syr + sandht(sxc,szc,hmax,mwaterlevel,r1,r2);
	pictobj.setrect( sign, sxc,syc,szc, sxr, syr, szr, j1,j2,j3,j4,j5,j6);

	-- lean-to
	mylean2obj.setRect(lean2, 
		j1,j2,j3,j4,j5,j6 );
	--warning...KO set here would be overwritten


	r2cy := sandht(r2cx,r2cz, hmax,mwaterlevel,r1,r2);
	r3cy := -r3ry*0.1 + sandht(r3cx,r3cz, hmax,mwaterlevel,r1,r2);

---------- prepare textured objects end ----------- 
-----------------------------------------------------


end island_texture_setup; -- prepare textures


