
separate (adagate.drawisland)

procedure redefineKOs is
begin

-- these keepout zones must be
-- reinitialized here at each return to the island since the
-- same ko arrays are also used in the dungeon rooms:
	nko:=0;


	-- rock2 (smaller-higher)
	nko:=nko+1;
	koxlo(nko):=r2cx-r2rx;
	koxhi(nko):=r2cx+r2rx;
	koylo(nko):=r2cy-r2ry;
	koyhi(nko):=r2cy+r2ry;
	kozlo(nko):=r2cz-r2rz;
	kozhi(nko):=r2cz+r2rz;


	-- rock3 (bigger-lower)
	nko:=nko+1;
	koxlo(nko):=r3cx-r3rx;
	koxhi(nko):=r3cx+r3rx;
	koylo(nko):=r3cy-r3ry;
	koyhi(nko):=r3cy+r3ry;
	kozlo(nko):=r3cz-r3rz;
	kozhi(nko):=r3cz+r3rz;





	-- 3rd keepout for cockpit, nose
	nko:=nko+1;
	koxlo(nko):= r4cx-r4rx;
	koxhi(nko):= r4cx+r4rx;
	koylo(nko):= -1.0;
	koyhi(nko):= +1.0;
	kozlo(nko):= r4cz-r4rz;
	kozhi(nko):= r4cz+r4rz;

	-- 4th, 5th keepouts, 2 SG pillars (#1,2):

	nko:=nko+1;
	koxlo(nko):= gatex-gdx-pdr2-pdr2-0.15;
	koxhi(nko):= gatex-gdx+0.15;
	koylo(nko):= -1.0;
	koyhi(nko):= +1.0;
	kozlo(nko):= gatez-pdr2-0.15;
	kozhi(nko):= gatez+pdr2+0.15;

	nko:=nko+1;
	koxlo(nko):= gatex+gdx-0.15;
	koxhi(nko):= gatex+gdx+pdr2+pdr2+0.15;
	koylo(nko):= -1.0;
	koyhi(nko):= +1.0;
	kozlo(nko):= gatez-pdr2-0.15;
	kozhi(nko):= gatez+pdr2+0.15;


	-- 6th KO for lean-to
	nko:=nko+1;
	koxlo(nko):= l2xc-l2xr;
	koxhi(nko):= l2xc+l2xr+0.3; -- needs Xtra margin @ high edge
	koylo(nko):= l2yc-1.0;
	koyhi(nko):= l2yc+1.0;
	kozlo(nko):= l2zc-l2zr;
	kozhi(nko):= l2zc+l2zr;




	-- 8 more KOs for palms, + 3 bamboo
	for ii in 1..11 loop

		-- rr=radius of canopy...need radius of trunk
		rr:=pzr(ii)+pxr(ii);
		if ii>8 then --bamboo
			rr:=0.2*rr; 
		else
			rr:=0.15*rr;
		end if;

		nko:=nko+1;
		koxlo(nko):= pxc(ii)-rr;
		koxhi(nko):= pxc(ii)+rr;
		koylo(nko):= -1.0;
		koyhi(nko):= +1.0;
		kozlo(nko):= pzc(ii)-rr;
		kozhi(nko):= pzc(ii)+rr;

	end loop;
-----------------------------------------
-- spalm => i in [ 1.. 2]		 
-- tpalm => i in [ 3.. 8]		 
-- bamboo=> i in [ 9..11]		
-- grass => i in [12..14]		
-- tgrass=> i in [15..16]		
-----------------------------------------


	--DHD : (MUST be last KO)
	nko:=nko+1;
	koxlo(nko):=dhdx-2.0*dhdr;
	koxhi(nko):=dhdx+2.0*dhdr;
	koylo(nko):=dhdy-2.0*dhdh;
	koyhi(nko):=dhdy+2.0*dhdh+aheight;
	kozlo(nko):=dhdz-2.0*dhdr;
	kozhi(nko):=dhdz+2.0*dhdr;


-------------- end KO zone definition -----------------------------------


end redefineKOs;


