
# Auxillary build script for OSX using 
# AdaCore g++ [not Xcore g++]

# In nov2021 my Xcode was upgraded to 10.1, which
# caused my TBD files to become "out-of-sync"
# with SDK libraries (subsequently fixed).

# This script gives specific paths
# to libraries & frameworks, if needed.



#!/bin/sh
#
# Mac OS-X compile script 
#
# note:
# on linux, gcc requires libstdc++ but here on OSX,
# gcc == clang++, which requires libc++
#
# If trying to use GNU g++ or AdaCore g++, then
# one should use libstdc++ (-lstdc++).
#
#==================================================




if [ -d ./obj/ ]; then
	rm ./obj/*
else
	mkdir obj
fi


# this is newest compiler from AdaCore:
export PATH=$HOME/opt/GNAT/2020/bin:$PATH

# using AdaCore g++ compiler...
# first, create oal.o:
g++ src/adabindings/adaOpenAL/OalBinding/oal.cpp -c \
-D obj \
-Isrc/adabindings/adaOpenAL/OalBinding \
-Isrc/adabindings/adaOpenAL/OalBinding/incoal


#--------------------------------------------------------


export SDKROOT=$(xcrun --show-sdk-path)

export FWROOT=/System/Library/Frameworks




gnatmake  adagate -O3  \
-o adagate_osx \
-D $PWD/obj \
-I$PWD/src \
-I$PWD/src/adautils \
-I$PWD/src/adabindings/gl \
-I$PWD/src/adabindings/glfwada \
-I$PWD/src/adabindings/AdaPngLib \
-I$PWD/src/adabindings/adaOpenAL \
-I$PWD/src/adabindings/adaOpenAL/OalBinding \
-largs \
oal.o \
-L$SDKROOT/usr/lib \
-lm -lz -lstdc++ \
$PWD/libs/osx/libglfw3.a \
\
-F$FWROOT \
-framework OpenGL \
-framework ForceFeedback \
-framework CoreFoundation \
-framework Carbon \
-framework Cocoa \
-framework QuartzCore \
-framework IOKit \
-framework CoreAudio \
-framework AudioUnit \
-framework AudioToolBox \
-framework Metal \
-framework OpenAL \
-pthread 


