pragma Style_Checks (Off);

with Interfaces.C; use Interfaces.C;
with bits_types_h;
with bits_time_h;

package bits_timex_h is

   --  unsupported macro: ADJ_OFFSET 0x0001
   --  unsupported macro: ADJ_FREQUENCY 0x0002
   --  unsupported macro: ADJ_MAXERROR 0x0004
   --  unsupported macro: ADJ_ESTERROR 0x0008
   --  unsupported macro: ADJ_STATUS 0x0010
   --  unsupported macro: ADJ_TIMECONST 0x0020
   --  unsupported macro: ADJ_TAI 0x0080
   --  unsupported macro: ADJ_MICRO 0x1000
   --  unsupported macro: ADJ_NANO 0x2000
   --  unsupported macro: ADJ_TICK 0x4000
   --  unsupported macro: ADJ_OFFSET_SINGLESHOT 0x8001
   --  unsupported macro: ADJ_OFFSET_SS_READ 0xa001
   --  unsupported macro: MOD_OFFSET ADJ_OFFSET
   --  unsupported macro: MOD_FREQUENCY ADJ_FREQUENCY
   --  unsupported macro: MOD_MAXERROR ADJ_MAXERROR
   --  unsupported macro: MOD_ESTERROR ADJ_ESTERROR
   --  unsupported macro: MOD_STATUS ADJ_STATUS
   --  unsupported macro: MOD_TIMECONST ADJ_TIMECONST
   --  unsupported macro: MOD_CLKB ADJ_TICK
   --  unsupported macro: MOD_CLKA ADJ_OFFSET_SINGLESHOT
   --  unsupported macro: MOD_TAI ADJ_TAI
   --  unsupported macro: MOD_MICRO ADJ_MICRO
   --  unsupported macro: MOD_NANO ADJ_NANO
   --  unsupported macro: STA_PLL 0x0001
   --  unsupported macro: STA_PPSFREQ 0x0002
   --  unsupported macro: STA_PPSTIME 0x0004
   --  unsupported macro: STA_FLL 0x0008
   --  unsupported macro: STA_INS 0x0010
   --  unsupported macro: STA_DEL 0x0020
   --  unsupported macro: STA_UNSYNC 0x0040
   --  unsupported macro: STA_FREQHOLD 0x0080
   --  unsupported macro: STA_PPSSIGNAL 0x0100
   --  unsupported macro: STA_PPSJITTER 0x0200
   --  unsupported macro: STA_PPSWANDER 0x0400
   --  unsupported macro: STA_PPSERROR 0x0800
   --  unsupported macro: STA_CLOCKERR 0x1000
   --  unsupported macro: STA_NANO 0x2000
   --  unsupported macro: STA_MODE 0x4000
   --  unsupported macro: STA_CLK 0x8000
   --  unsupported macro: STA_RONLY (STA_PPSSIGNAL | STA_PPSJITTER | STA_PPSWANDER | STA_PPSERROR | STA_CLOCKERR | STA_NANO | STA_MODE | STA_CLK)
  -- Copyright (C) 1995-2012 Free Software Foundation, Inc.
  --   This file is part of the GNU C Library.
  --   The GNU C Library is free software; you can redistribute it and/or
  --   modify it under the terms of the GNU Lesser General Public
  --   License as published by the Free Software Foundation; either
  --   version 2.1 of the License, or (at your option) any later version.
  --   The GNU C Library is distributed in the hope that it will be useful,
  --   but WITHOUT ANY WARRANTY; without even the implied warranty of
  --   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  --   Lesser General Public License for more details.
  --   You should have received a copy of the GNU Lesser General Public
  --   License along with the GNU C Library; if not, see
  --   <http://www.gnu.org/licenses/>.   

  -- These definitions from linux/timex.h as of 2.6.30.   
  -- mode selector  
   type timex is record
      modes : aliased unsigned;  -- /usr/include/bits/timex.h:27
      offset : aliased bits_types_h.uu_syscall_slong_t;  -- /usr/include/bits/timex.h:28
      freq : aliased bits_types_h.uu_syscall_slong_t;  -- /usr/include/bits/timex.h:29
      maxerror : aliased bits_types_h.uu_syscall_slong_t;  -- /usr/include/bits/timex.h:30
      esterror : aliased bits_types_h.uu_syscall_slong_t;  -- /usr/include/bits/timex.h:31
      status : aliased int;  -- /usr/include/bits/timex.h:32
      c_constant : aliased bits_types_h.uu_syscall_slong_t;  -- /usr/include/bits/timex.h:33
      precision : aliased bits_types_h.uu_syscall_slong_t;  -- /usr/include/bits/timex.h:34
      tolerance : aliased bits_types_h.uu_syscall_slong_t;  -- /usr/include/bits/timex.h:35
      time : aliased bits_time_h.timeval;  -- /usr/include/bits/timex.h:36
      tick : aliased bits_types_h.uu_syscall_slong_t;  -- /usr/include/bits/timex.h:37
      ppsfreq : aliased bits_types_h.uu_syscall_slong_t;  -- /usr/include/bits/timex.h:38
      jitter : aliased bits_types_h.uu_syscall_slong_t;  -- /usr/include/bits/timex.h:39
      shift : aliased int;  -- /usr/include/bits/timex.h:40
      stabil : aliased bits_types_h.uu_syscall_slong_t;  -- /usr/include/bits/timex.h:41
      jitcnt : aliased bits_types_h.uu_syscall_slong_t;  -- /usr/include/bits/timex.h:42
      calcnt : aliased bits_types_h.uu_syscall_slong_t;  -- /usr/include/bits/timex.h:43
      errcnt : aliased bits_types_h.uu_syscall_slong_t;  -- /usr/include/bits/timex.h:44
      stbcnt : aliased bits_types_h.uu_syscall_slong_t;  -- /usr/include/bits/timex.h:45
      tai : aliased int;  -- /usr/include/bits/timex.h:47
      field_21 : aliased int;
      field_22 : aliased int;
      field_23 : aliased int;
      field_24 : aliased int;
      field_25 : aliased int;
      field_26 : aliased int;
      field_27 : aliased int;
      field_28 : aliased int;
      field_29 : aliased int;
      field_30 : aliased int;
      field_31 : aliased int;
   end record;
   pragma Convention (C_Pass_By_Copy, timex);  -- /usr/include/bits/timex.h:25

  -- time offset (usec)  
  -- frequency offset (scaled ppm)  
  -- maximum error (usec)  
  -- estimated error (usec)  
  -- clock command/status  
  -- pll time constant  
  -- clock precision (usec) (ro)  
  -- clock frequency tolerance (ppm) (ro)  
  -- (read only)  
  -- (modified) usecs between clock ticks  
  -- pps frequency (scaled ppm) (ro)  
  -- pps jitter (us) (ro)  
  -- interval duration (s) (shift) (ro)  
  -- pps stability (scaled ppm) (ro)  
  -- jitter limit exceeded (ro)  
  -- calibration intervals (ro)  
  -- calibration errors (ro)  
  -- stability limit exceeded (ro)  
  -- TAI offset (ro)  
  -- ???  
  -- Mode codes (timex.mode)  
  -- xntp 3.4 compatibility names  
  -- Status codes (timex.status)  
  -- Read-only bits  
end bits_timex_h;
