--
-- Copyright (C) 2020  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--



with ada.real_time; use ada.real_time;
with interfaces.c; use interfaces.c;
with ada.directories;
with sysutils;
with text_io; use text_io;


package body musical is

	pidstr : idtype;
	last: natural;
	ok: boolean;
	fid: file_type;

	tch: character;

	dfil: file_type;
	d1fname: constant string := "m1Dbg.txt";
	d2fname: constant string := "m2Dbg.txt";



	task body musictask1 is
	begin

	loop

	 select

		accept Play( ch: character; cmd: string; utime: out time ) do
			tch:=ch;
			sysutils.Shell( cmd, Ok );
			utime := clock;
		end Play;

	 or
		terminate;
	 end select;

	end loop;

	exception
		when others=>
			create(dfil,out_file,tch&d1fname);
			put_line(dfil,"m1.Play error "&tch);
			close(dfil);
			raise;

	end musictask1;





	task body musictask2 is
	begin

	loop

	 select

		accept getPID( fname: string; idstr: out idtype; len: out natural ) do

			loop
				exit when ada.directories.Exists(fname);
				delay 0.1;
			end loop;

			--System controls this file;
			--Existence => Sound is Active

			open(fid, in_file, fname);
			get_line(fid, pidstr, last);
			close(fid);
			idstr:=pidstr;
			len:=last;
		end getPID;

	 or
		terminate;
	 end select;

	end loop;

	exception
		when others=>
			create(dfil,out_file,tch&d2fname);
			put_line(dfil,"m2.getPID error "&tch);
			close(dfil);
			raise;

	end musictask2;

end musical;
