--
-- Copyright (C) 2020  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--




--This package defines a minimalist sound loop capability
--for Linux using the ubiquitous command line sound player
--"aplay" using ALSA sound that handles WAV sound files.
--
--Short & transient sounds are easily handled using a
--"system" shell background command initiator.
--
--Controlling sound loop files, on the other hand,
--requires the ability to interrupt them at odd times, 
--and the ability to replay them indefinitely.
--
--Those interrupts and replays are herein controlled
--using Ada tasking.

with musical; use musical;
with ada.real_time; use ada.real_time;

package sndloop is

	task type sndtask is
		entry Start(name: string; dur: time_span; ch: character);
		entry Stop;
	end sndtask;

end sndloop;

