--
-- Copyright (C) 2020  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--



separate (adagate)




procedure InitGlfw( 
	name: string; 
	wid,hit,fwd,fht: out glint;
	hiDpiDesired: in boolean := true
	) is

	use system;

	title : interfaces.c.strings.chars_ptr := new_string(name&ascii.nul);

	maj,min,rev : aliased glint;

	axs, ays : aliased float;
	awwid,awhit, afwid, afhit : aliased glint;

	ret: glint;
begin

	put_line("...using fastrgv's Jan2020 Ada Binding to GLFW332...");

	GlfwGetVersion(maj'access,min'access,rev'access); --naturals
	put("GLFW ver: ");
	put(glint'image(maj));
	put(":"&glint'image(min));
	put(":"&glint'image(rev));
	New_Line;



	ret:=glfwInit;
	if ret /= gl_true then
		new_line;
		put_line("glfwInit failed");
		raise program_error;
	else
		put("glfwInit Ok"); new_line;
	end if;


	-- use version here that your graphics card would support:
	GlfwWindowHint( glfw_context_version_major, 3);
	GlfwWindowHint( glfw_context_version_minor, 3);
	GlfwWindowHint( glfw_opengl_forward_compat, gl_true);
	GlfwWindowHint( glfw_opengl_profile, glfw_opengl_core_profile);

	GlfwWindowHint( glfw_samples, 4);
	GlfwWindowHint( glfw_client_api, glfw_opengl_api);

	-- should have no effect on fullscreen...
	-- YET [on sl77, OpenSuse] height = 981 w/o, 1018 with:
	GlfwWindowHint( glfw_decorated, glfw_false);

	--GlfwWindowHint( glfw_scale_to_monitor, glfw_true);noDiff


	if osx and not hiDpiDesired then
		GlfwWindowHint( glfw_cocoa_retina_framebuffer, glfw_false);
	end if;





	declare
		monit: access glfwMonitor := glfwGetPrimaryMonitor;
		vmode: access constant glfwVidMode 
			:= glfwGetVideoMode(monit);
	begin

		if monit=null then 
		put_line("null monitor");
		else 
		put_line("NoN-null monitor"); --mint
		end if;

		--get current video mode size [full screen]
		wid:=vmode.width;
		hit:=vmode.height;

		mainWindow := glfwcreatewindow(
			wid, hit,	title, 
			monit, null );

	end;

	--mainWindow := glfwcreatewindow(
	--	wid, hit,	title, 
	--	glfwGetPrimaryMonitor, null );


put("prelim Wid x Hit: ");
put(glint'image(wid)); -- 1920
put(" x ");
put(glint'image(hit)); -- 1080 !!!
new_line;

	--glfwSetWindowSize(mainWindow,wid,hit);



		

	if mainWindow = null then
		new_line;
		put_line("glfwCreateWindow failed");
		raise program_error;
	end if;

	glfwmakecontextcurrent( mainWindow );

	--glfwSetWindowSize(mainWindow,wid,hit);
	--glfwSetWindowPos(mainWindow,0,0);
	--glfwSetWindowSize(mainWindow,1920,1080);



--HiDpi queries:
	glfwGetWindowSize(mainWindow, awwid'access, awhit'access);
	glfwGetFramebufferSize(mainWindow, afwid'access,afhit'access);
	glfwGetWindowContentScale(mainWindow, axs'access,ays'access);

	--define out parms:
	Fwd:=afwid;
	Fht:=afhit;
	wid:=awwid;
	hit:=awhit;

	put_line("HighDpi Queries:");
	put_line("Wsize: "&glint'image(awwid)&","&glint'image(awhit));
	put_line("FrmBuf: "&glint'image(afwid)&","&glint'image(afhit));
	put_line("Scale: "&float'image(axs)&","&float'image(ays));

	if axs>1.5 or ays>1.5 then
		hidpi:=true;
	else
		hidpi:=false;
	end if;



	if glfwJoystickPresent(glfw_joystick_1)=glfw_true then

		if glfwJoystickIsGamepad(glfw_joystick_1)=glfw_true then
			put_line("Gamepad is present");
			gamepad:=true;
		else
			put_line("Joystick is present");
			joystik:=true;
		end if;

	end if;

	glfwSetInputMode(mainWindow, glfw_cursor, glfw_cursor_disabled);


	-- I don't think this code is needed:
	--if glfwRawMouseMotionSupported=glfw_true then
	--	put_line("setting RAW mouse motion");
	--	glfwSetInputMode(mainWindow,glfw_raw_mouse_motion, glfw_true);
	--else
	--	put_line("RAW mouse motion NOT supported");
	--end if;



	if    linux then put_line("system is linux");
	elsif mswin then put_line("system is MsWin");
	elsif   osx then put_line("system is OSX");
	end if;
	if hidpi then
		put_line("HiDpi");
	else
		put_line("NOT HiDpi");
	end if;

end InitGlfw;





