
separate (adagate)

-- island prologue
--
-- involves a large cubemapped ocean-setting skybox
-- with round body of water and a annular island of sand at center
-- Walking about is done by keeping the eye @ (0,0,0) and moving
-- the sandy island in the opposite direction.  This is done
-- to preserve the proper skybox perspective.  Thus, within
-- this skybox, we maintain 2 distinct view matrices:
-- mviewMatrix [& mmvp] with eyepos @ (0,0,0)
-- iviewMatrix [& imvp] with eyepos @ island-virtual-position
--
function drawisland( 
	ibkgd: integer:= 0;
	skipFly: boolean := true  -- skipFlyover only false 1st time
	) return integer is

	bkg : integer := 0;
	foglev : glint := 0;
	fogclr : glint := 1;

	use gl;
	use matutils;
	use type interfaces.c.c_float;

	use interfaces.c;
	use interfaces.c.strings;
	use glext;
	use glext.pointers;
	use glext.binding;
	use gl.binding;
	use gl.pointers;





-- to draw sandweeds in order from far to near
procedure ssort( 
	f2n: in out ssortarray; 
	nx,px,nz,pz : slimarray;  
	eyex,eyez : float;  
	avgdist: out float ) is

	n, isave : integer;
	fn, ni,pi,di, nj,pj,dj : float;
begin
	n:=nsrng'last; --nptex
	fn := float(n);

	for i in nsrng loop
		f2n(i):=i; -- initialize permutation
	end loop;
	avgdist:=0.0;

	for i in reverse nsrng loop
		ni := sqr( nx( f2n(i) ) - eyex ) + sqr( nz( f2n(i) ) - eyez );
		pi := sqr( px( f2n(i) ) - eyex ) + sqr( pz( f2n(i) ) - eyez );
		di := min( ni, pi );
		avgdist := avgdist + fmath.sqrt(di)/fn;

		for j in 1..i loop

			ni := sqr( nx( f2n(i) ) - eyex ) + sqr( nz( f2n(i) ) - eyez );
			pi := sqr( px( f2n(i) ) - eyex ) + sqr( pz( f2n(i) ) - eyez );
			di := min( ni, pi );

			nj := sqr( nx( f2n(j) ) - eyex ) + sqr( nz( f2n(j) ) - eyez );
			pj := sqr( px( f2n(j) ) - eyex ) + sqr( pz( f2n(j) ) - eyez );
			dj := min( nj, pj );

			if( di > dj ) then -- swap i,j
				isave:=f2n(i);
				f2n(i):=f2n(j);
				f2n(j):=isave;
			end if;

		end loop; -- for j

	end loop; -- for i

end ssort;











-- to draw seaweed in order from far to near
procedure wsort( 
	f2n: in out wsortarray; 
	nx,px,nz,pz : wlimarray;  
	eyex,eyez : float;  
	avgdist: out float ) is

	n, isave : integer;
	fn, ni,pi,di, nj,pj,dj : float;
begin
	n:=nwrng'last; --nptex
	fn := float(n);

	for i in nwrng loop
		f2n(i):=i; -- initialize permutation
	end loop;
	avgdist:=0.0;

	for i in reverse nwrng loop
		ni := sqr( nx( f2n(i) ) - eyex ) + sqr( nz( f2n(i) ) - eyez );
		pi := sqr( px( f2n(i) ) - eyex ) + sqr( pz( f2n(i) ) - eyez );
		di := min( ni, pi );
		avgdist := avgdist + fmath.sqrt(di)/fn;

		for j in 1..i loop

			ni := sqr( nx( f2n(i) ) - eyex ) + sqr( nz( f2n(i) ) - eyez );
			pi := sqr( px( f2n(i) ) - eyex ) + sqr( pz( f2n(i) ) - eyez );
			di := min( ni, pi );

			nj := sqr( nx( f2n(j) ) - eyex ) + sqr( nz( f2n(j) ) - eyez );
			pj := sqr( px( f2n(j) ) - eyex ) + sqr( pz( f2n(j) ) - eyez );
			dj := min( nj, pj );

			if( di > dj ) then -- swap i,j
				isave:=f2n(i);
				f2n(i):=f2n(j);
				f2n(j):=isave;
			end if;

		end loop; -- for j

	end loop; -- for i

end wsort;









-- We need to draw trees/bamboo in order from far to near
procedure sort( 
	f2n: in out psortarray; 
	nx,px,nz,pz : plimarray;  
	eyex,eyez : float;  
	avgdist: out float ) is

	n, isave : integer;
	fn, ni,pi,di, nj,pj,dj : float;
begin
	n:=nprng'last; --nptex
	fn := float(n);

	for i in nprng loop
		f2n(i):=i; -- initialize permutation
	end loop;
	avgdist:=0.0;

	for i in reverse nprng loop
		ni := sqr( nx( f2n(i) ) - eyex ) + sqr( nz( f2n(i) ) - eyez );
		pi := sqr( px( f2n(i) ) - eyex ) + sqr( pz( f2n(i) ) - eyez );
		di := min( ni, pi );
		avgdist := avgdist + fmath.sqrt(di)/fn;

		for j in 1..i loop

			ni := sqr( nx( f2n(i) ) - eyex ) + sqr( nz( f2n(i) ) - eyez );
			pi := sqr( px( f2n(i) ) - eyex ) + sqr( pz( f2n(i) ) - eyez );
			di := min( ni, pi );

			nj := sqr( nx( f2n(j) ) - eyex ) + sqr( nz( f2n(j) ) - eyez );
			pj := sqr( px( f2n(j) ) - eyex ) + sqr( pz( f2n(j) ) - eyez );
			dj := min( nj, pj );

			if( di > dj ) then -- swap i,j
				isave:=f2n(i);
				f2n(i):=f2n(j);
				f2n(j):=isave;
			end if;

		end loop; -- for j

	end loop; -- for i

end sort;




















-- until flyover is false, (oxme,oyme,ozme) holds original position

procedure fly(
currenttime: gldouble; xme,yme,zme, xlook,cylook,zlook : in out float;
flyover : in out boolean ) is
	tt : constant float := float((currenttime - flystart)/flyduration);
	ang0 : constant float := fmath.arctan(ozme,oxme);
	rxz : float;
begin

if tt>1.0 then
	flyover:=false;
else

	yme:=(1.0-tt)*yfly + tt*oyme;
	horiang := tt*onepi*3.0 + ang0;


	-- nice...looking in direction of flight
	--xme := oxme*cos(-horiang+onepi) - ozme*sin(-horiang+onepi);
	--zme := oxme*sin(-horiang+onepi) + ozme*cos(-horiang+onepi);

	-- best...looking between island center and direction of flight
	xme := oxme*fmath.cos(-horiang+1.2*onepi) - ozme*fmath.sin(-horiang+1.2*onepi);
	zme := oxme*fmath.sin(-horiang+1.2*onepi) + ozme*fmath.cos(-horiang+1.2*onepi);

	rxz := fmath.sqrt( xme*xme+zme*zme );
	vertang := -onepi/12.0 - fmath.arctan(yme,rxz);

	xlook := fmath.cos(vertang)*fmath.sin(horiang);
	cylook := fmath.sin(vertang);
	zlook := fmath.cos(vertang)*fmath.cos(horiang);

	slewToAvLook;
	updateCamera;

end if;

end fly;








-- Simplified version of update used for prolog (on beach) 
-- where jumping is disallowed...
-- this must also initiate beach-ZPM rolls
procedure mupdatezpm( currenttime : gldouble ) is

	barrelwasmoved, barrelhitko : boolean := false;
	dist, nbx,nby,nbz : float;
	--k: integer := 0;
begin

	if 
		pauseatlevelchange and then
		currenttime-wormstart>islandwormduration+1.0 
	then
		pauseatlevelchange:=false; --27mar20
	end if;

	nbx:=0.0; nby:=0.0; nbz:=0.0;

	---------- begin barrel logic -------------------------------

	-- initiate roll when appropriate:
	if not mrolling then

		barrl := mposbar;
		-- xme,zme are used in this next ftn:
		mtestbarrel( nbx,nby,nbz, barrelwasmoved, barrelhitko);

		if barrelhitko then
			forwardok := false;
			badhoriang := horiang;
		end if;


		if forwardok and barrelwasmoved  then

			nubarrl(1):=nbx;
			nubarrl(2):=nby;
			nubarrl(3):=nbz;
			mrolling:=true;
			mseated:=false;
			if dhdstate/=5 then
				dhdstate:=0;
			end if;
			timeofroll:=currenttime;
			olbarrl:=barrl;
			incbarrl:=olbarrl;

			-- barrel can only roll in 2 directions
			if (nubarrl(3)=olbarrl(3)) then
				rolldir := 3 * integer( signum(nubarrl(1)-olbarrl(1)) );
			elsif (nubarrl(1)=olbarrl(1)) then
				rolldir := 1 * integer( signum(nubarrl(3)-olbarrl(3)) );
			end if;
			snd4ada.playSnd(beachkick); --4dec18

		end if;

	end if;



	-- check whether barrel is on receptacle:
	if  not mrolling  and not mseated then

		dist := fmath.sqrt( 
			sqr(mposbar(1)-barx) +
			sqr(mposbar(3)-barz) );
		if (dist<0.1) then 
			mseated:=true; -- barrel is on receptacle
		end if;

		if mseated then
			snd4ada.playSnd(qport); --sbQport signals empowerment 11nov14

			if dhdstate=5 then
				dhdtime:=currenttime;
				snd4ada.playSnd(kwush);
				snd4ada.playLoop(kbub);
			end if;

		end if;

	end if;

	if not mseated then --4dec18
		snd4ada.stopLoop(kbub);
	end if;

	---------- end barrel logic -------------------------------

	lasttime := currenttime;

end mupdatezpm;








-- this assumes mm=ID, (xme,yme,zme)=virtual pos on island
-- [ actual pos is always (0,0,0) ]
procedure myst_update3MVPs( bkgdNum: integer; 
currentTime:gldouble; wid,hit : float) is
	pmx,pmy,pmz,madeg,
	mang,
	xlk,ylk,zlk,
	xrt,yrt,zrt,
	xpos,ypos,zpos,
	xup,yup,zup : float;
	degtilt: constant float := -60.0; -- -45.0;
begin

	if thirdPerson and not worming then

		xpos:=xcam; ypos:=ycam; zpos:=zcam;
		-- camera look + choriang are already defined

	else -- firstPerson

		xpos:=xme; ypos:=yme; zpos:=zme;

		choriang:=horiang;
		cxlook := fmath.cos(vertang)*fmath.sin(choriang);
		cylook := fmath.sin(vertang);
		czlook := fmath.cos(vertang)*fmath.cos(choriang);

	end if;


	-- Look Vector
	xlk:=xpos+cxlook;
	ylk:=ypos+cylook;
	zlk:=zpos+czlook;

	-- Right unit-Direction
	xrt:= fmath.sin(choriang-halfpi);
	yrt:= 0.0;
	zrt:= fmath.cos(choriang-halfpi);

	-- calculate UP unit-Direction
	cross( xrt,yrt,zrt, cxlook,cylook,czlook, xup,yup,zup );

	perspective(projMatrix, 45.0, wid/hit,  0.1, 100.0);

	lookat(mviewMatrix, 0.0,0.0,0.0, cxlook,cylook,czlook, xup,yup,zup );
	lookat(iviewMatrix, xpos,ypos,zpos, xlk,ylk,zlk, xup,yup,zup );

	mmvp:=mviewMatrix; --use only for skybox
	imvp:=iviewMatrix;
	imv:=iviewMatrix;

	matXmat(mmvp,projMatrix); -- for skybox only
	matXmat(imvp,projMatrix); -- for all else



---------------------------------------------
	-- orbit pos (myrad,mrad=20)
	if bkgdNum=4 then --night stars
		mang:=float(currentTime)*twopi*0.002; --0.002
		pmx:=8.0*fmath.sin(mang);
		pmz:=8.0*fmath.cos(mang);
		pmy:=15.0;
	elsif bkgdNum=3 then --evening
		mang:=float(currentTime)*twopi*0.005; --0.005
		pmx:=2.0*fmath.sin(mang);
		pmz:=2.0*fmath.cos(mang);
		pmy:=15.0;
	elsif bkgdNum=2 then -- icy, foggy
		pmx:=-0.5; pmz:=-0.5; pmy:=15.0;
	elsif bkgdNum=1 then -- clouds, fog
		pmx:=1.0; pmz:=-4.0; pmy:=15.0;
	elsif bkgdNum=0 then -- sunny, clouds
		mang:=float(currentTime)*twopi*0.01; --0.01
		pmx:=5.0*fmath.sin(mang);
		pmz:=5.0*fmath.cos(mang);
		pmy:=15.0;
	else
		raise program_error;
	end if;


	-- spinAngle
	madeg := -float(currentTime)*twopi*rad2deg*0.1; -- 10sec/rev

	mars.setpos( pmx, pmy, pmz );
	ellobj.setpos(jupit,pmx,pmy,pmz);

---------------------------------------------


	satmm:=identity;
	translate(satmm, -pmx,-pmy,-pmz); --first, move to origin

-- begin rotations

	--spin on polar axis:
	degRotate(satmm, madeg, 0.0,1.0,0.0); -- Y=polar-axis (best 4 mars)

	--axis-tilt:
	degRotate(satmm, degtilt, 1.0, 0.0, 0.0);

-- end rotations

	translate(satmm, pmx,pmy,pmz); --now, move back

	satmv:=satmm;
	matXmat(satmv,mviewMatrix);
	satmvp:=satmv;
	matXmat(satmvp,projMatrix);
---------------------------------------------



end myst_update3MVPs;




procedure aimu(x,y,z: out float) is
	x0,y0,z0, x1,y1,z1, tt : float := 0.0;
	yplane : constant float := dhdy+dhdh; -- Y-coord of DHD Face
begin

	x0:=xme;
	y0:=yme;
	z0:=zme;
	x1:=x0;
	y1:=y0;
	z1:=z0;

	while (y1>yplane) loop
		tt:=tt+1.0;
		x1 := x0 + tt*xlook;
		y1 := y0 + tt*cylook;
		z1 := z0 + tt*zlook;
	end loop;
	tt := (yplane-y0)/(y1-y0);
	x := x0 + tt*(x1-x0);
	z := z0 + tt*(z1-z0);
	y := yplane;

end aimu;




	darkness : interfaces.c.int := 0; -- 0..4

	rr : float;


	vmt,vcc: vec4;
	ang2dhd, adiff, dist,xap,yap,zap: float;

	beach_error : exception;

	extension, et: float;
	
	kz: glfloat;

	bubbling: boolean := false;

	xeye,yeye,zeye: float;



procedure drawMisc is separate;

procedure drawStargate is separate;

procedure drawPalms is separate;

procedure drawRocks is separate;

procedure drawOcean(ibkg: integer) is separate;

procedure drawSeaweed is separate;
procedure drawWeeds is separate;

procedure drawsand is separate;

--procedure drawZPM is separate;
procedure rustyZPM is separate;

procedure drawDHD is separate;

procedure drawfish is separate;

procedure drawSkybox is separate;

procedure redefineKOs is separate;



	dbx, dbz : float;

	onmusic: boolean := false;

begin ------------- begin main drawisland ###############


	onmusic:=false;
	bubbling:=false;

	mars.setpos( 0.0, 0.0, 0.0 );
	jupit.setpos( 0.0, 0.0, 0.0 );

		currentTime:=glfwGetTime;

	myassert( npt = nprng'last, 113 );

	--3apr18 begin
	if 
		skipFly
	then

		-- in this case, we are exitting the stargate:
		xme := gatex+0.0; -- -4.0;
		zme := gatez+0.5; -- -3.5;
		yme := eyeht + sandht(xme,zme,hmax,mwaterlevel,r1,r2);


		vertang:=0.0;
		horiang:=0.0;

		if dbug then --set ZPM onto its receptacle; power-up SG.

			mposbar(1):=barx;
			mposbar(3):=barz;
			bary := -0.02 + barad +  --25may18
				sandht( mposbar(1), mposbar(3), hmax,mwaterlevel,r1,r2);
			mposbar(2):= bary;
			cyl2obj.setcyl2( mbarrel, mposbar(1),mposbar(2),mposbar(3), barad );
			cyl2lit.setcyl2( rbarrel, mposbar(1),mposbar(2),mposbar(3), barad );
			mseated:=true;

		else

			dbx:=-1.0*mrolldist;  dbz:=+1.0*mrolldist;
			if solved(1) then
				dbx := dbx - mrolldist;
			elsif solved(2) then
				dbz := dbz + mrolldist;
			elsif solved(3) then
				null;
			elsif solved(4) then
				dbz := dbz - mrolldist;
			end if;

			--move ZPM so player must reset:
			mposbar(1):=barx+dbx;
			mposbar(3):=barz+dbz;
			bary := -0.02 + barad +  --25may18
				sandht( mposbar(1), mposbar(3), hmax,mwaterlevel,r1,r2);
			mposbar(2):= bary;
			cyl2obj.setcyl2( mbarrel, mposbar(1),mposbar(2),mposbar(3), barad );
			cyl2lit.setcyl2( rbarrel, mposbar(1),mposbar(2),mposbar(3), barad );
			mseated:=false;

		end if;


	else --first arrival @ island

		xme := 4.0;
		zme := 1.0;
		yme := eyeht + sandht(xme,zme,hmax,mwaterlevel,r1,r2);

		vertang:=0.0;
		horiang:=-onepi;

	end if;
	--3apr18 end


	xlook := fmath.cos(vertang)*fmath.sin(horiang);
	cylook := fmath.sin(vertang);
	zlook := fmath.cos(vertang)*fmath.cos(horiang);

	slewToAvLook;
	updateCamera(true);


	if not flyover then
		toIsland:=true;
		-- note:  as written, tunnel requires horiang be a multiple of halfpi
		prepwormhole( currenttime, 
			xme-40.0*xlook, yme, zme-40.0*zlook, xme,yme,zme, xme,yme,zme);
	end if;

	--hold pos until after flyover
	oxme:=xme; oyme:=yme; ozme:=zme;
	flystart:=glfwGetTime;

	if skipFly then
		flyover:=false; -- debug only
	end if;


	jupit.yseteli(0.5,0.5,0.5); -- +Y=Npole
	mars.yseteli(0.4,0.4,0.4); -- +Y=Npole



	redefineKOs;
	-- these keepout zones must be
	-- reinitialized here at each return to the island since the
	-- same ko arrays are also used in the dungeon rooms:



	bkg:=0;
	if solved(1) then bkg:=bkg+1; end if;
	if solved(2) then bkg:=bkg+1; end if;
	if solved(3) then bkg:=bkg+1; end if;
	if solved(4) then bkg:=bkg+1; end if;

	if dbug then bkg:=ibkgd; end if; --1dec19 addendum (debug only)


	if bkg=0 then
		mcubemap_texid := tropical_cubemap_texid; -- sunny day
		foglev:=0;
	elsif bkg=1 then
		mcubemap_texid := blue_cubemap_texid;     -- cloudy day
		foglev:=2;
	elsif bkg=2 then
		mcubemap_texid := sargas_cubemap_texid;   -- icy, colorful
		foglev:=1;
	elsif bkg=3 then
		mcubemap_texid := sunset_cubemap_texid;   -- evening
		foglev:=0;
	elsif bkg=4 then
		mcubemap_texid := moon_cubemap_texid;     -- night
		foglev:=0; -- 13dec17

		nko:=nko-1; --16jan18: remove DHD as KO zone

	end if;
	darkness:=interfaces.c.int(bkg);

	mystexit:=false;
	mrolling:=false;


	updateCamera(true);
	myst_update3MVPs(bkg, currentTime, float(winwidth), float(winheight) );


	dhdstate:=0;
	if( solved(1) and solved(2) and solved(3) and solved(4) ) then
		dhdstate:=5; -- allow going directly to epilogue
	end if;


	xmonk:=-4.5;
	zmonk:=+3.5;
	ymonk:=sandht(xmonk,zmonk,hmax,mwaterlevel,r1,r2);
	mang:=0.0;
	mdir:=1;

	if flyover then
		snd4ada.playLoop(beach); -- tradewinds & surf
		onmusic:=true;
	end if;



	----------------------- main event loop begin -----------------------
   while not mystexit loop

		direction:=0; --stop avatar's legs, unless moving

		currentTime:=glfwGetTime;

		glfwPollEvents;



--tentative addendum 9feb22 (per AV):
--camdist:=float(zoomwheel.zdist);
--problem: this disables proper function of
-- Z-keys: n, f, z




		getKeyInputs(mainWindow); --sets detales
		exit when mystexit;

		currentTime := glfwGetTime;


	if not flyover and not worming then

		-- 20nov19 now wait until AFTER arrival:
		if not onmusic and not worming then
			snd4ada.playLoop(beach); -- tradewinds & surf
			onmusic:=true;
		end if;




------ begin mouse button -----------------------------------------

-- Here, I am assuming dhdy < yme ...
-- so if we are close enough to the DHD
-- and if we are looking down then we test:


		dist:=fmath.sqrt( sqr(xme-dhdx) + sqr(zme-dhdz) );



----------- force 1st person insert 25jan18 -----------------------
		if dist<dhdnear1 and thirdperson then

			restoreThird:=true;
			thirdperson:=false;

		elsif dist>dhdnear1 and restoreThird then

			thirdperson:=true;
			restoreThird:=false;

		end if;
----------- force 1st person insert 25jan18 -----------------------


		if dist>0.001 then

			--difference between DHD and look direction...since we are using sine
			--we must test halfangle so that test fails @ delta=onepi
			--adiff := abs(fmath.sin( 0.5*fmath.arctan(dhdx-xme,dhdz-zme) - 0.5*horiang ));
			ang2dhd:=branchnear(horiang,fmath.arctan(dhdx-xme,dhdz-zme));
			adiff := abs(fmath.sin( 0.5*(ang2dhd-horiang) ));

			if thirdPerson then
				--neardhd:=((dist<dhdnear1)and(cylook<-0.1)and(adiff<fmath.sin(eighthpi)));
				neardhd := ( (dist<dhdnear1) and (adiff<fmath.sin(eighthpi)) );
			else
				-- must be looking down at 30 degrees or more below horizontal
				neardhd:=((dist<dhdnear1) and (cylook<-0.5) and (adiff<fmath.sin(eighthpi)));
			end if;

		else
			neardhd:=false; --too close for calculations
		end if;

		if dhdstate=5 then neardhd:=false; end if; --14jan18 fix


		if mseated and neardhd and (dhdstate<5) then
			handle_mouse_click(currenttime);
		end if;
		handle_mouse_move(currentTime); -- change look direction here

		handle_gamepad(currenttime);



		-- 24feb20 revision:
		if inwater then

			if moving then
				if not splashing then
					snd4ada.stopLoop(treadsplash); --new
					tsplashing:=false;
					snd4ada.playLoop(swimsplash);
					splashing:=true;
				end if;
			else --not moving but inwater
				if not tsplashing then
					snd4ada.stopLoop(swimsplash);
					splashing:=false;
					snd4ada.playLoop(treadsplash);
					tsplashing:=true;
				end if;
			end if;

		else -- not inwater

			if tsplashing or splashing then
				snd4ada.stopLoop(swimsplash); --new
				snd4ada.stopLoop(treadsplash); --new
				splashing:=false;
				tsplashing:=false;
			end if;

		end if;

----------- end game controller ---------------------------------




----///////////////////// end response to user inputs /////////////////////////


	else -- flyover or worming is taking place
		if flyover then
			fly(currenttime, xme,yme,zme, xlook,cylook,zlook,flyover);
		elsif worming then
			vertang:=0.0;
			worm(currenttime, xme,yme,zme); --, worming);
		end if;
	end if; -- not flyover





		updateCamera; -- main call within myst event loop

		myst_update3MVPs(bkg,currentTime, float(winwidth), float(winheight) );


		mupdatezpm(currenttime); -- 6nov15 addition ???
		-- much simpler version of updategamestate for beach


		glClear(GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT);


		if thirdperson then
			xeye:=xcam; yeye:=ycam; zeye:=zcam;
		else
			xeye:=xme; yeye:=yme; zeye:=zme;
		end if;


--/////// begin draw textured objects ////////////////////////////////


		drawsand; --and planet

		drawSkyBox;

		drawSeaweed;

		drawMisc;
		-- crab, bones, jar, woodsign,
		-- SoS, ZPMreceptacle, airplane-nose

		drawFish;

		updateMonkey(currenttime,xme,zme, xmonk,ymonk,zmonk,mang,mdir);
		drawMonkey(currenttime,xmonk,ymonk,zmonk,mang,mdir);

		if thirdPerson then

			if neardhd and mseated  then --translucent
				fadeAvatar:=true;
			else
				fadeAvatar:=false;
			end if;

			drawAvatar(currenttime, xme,yme,zme,horiang); --draw after DHD
		end if;


		drawOcean(bkg); --AFTER all undersea objects are drawn

		drawRocks; -- coconuts + rocks
		drawDHD;

		--drawZPM;
		rustyZPM;


		drawStargate;

		sort(far2near,nx,px,nz,pz, xeye,zeye, avgdist); --palmtrees
		drawPalms;

		drawWeeds;





		if neardhd and mseated  then -- show hand-cursor

			-- "`" => rightPalm in my alphabet
			aimu(xap,yap,zap);
			vmt:=(xap,yap,zap,1.0);
			matXvec(imvp,vmt,vcc);
			wtex.print3d("`",vcc(1),vcc(2),vcc(3),vcc(4), 40, 1.0);

		end if;




		if worming then -- draw passage thru wormhole
				drawWormHole( currentTime, imvp );


		elsif help then
			wtex.print2d(" Help Screen Tips:",0.02, 0.70,15);
			wtex.print2d(" m-key => toggle Avatar",0.02, 0.60,15);
			wtex.print2d(" ...and if avatar is showing...",0.02, 0.55,15);
			wtex.print2d(" n-key => zoom_Nearer;  f-key => zoom_Further;  z-key[hold] => default_zoom", 0.02, 0.5, 15);

			wtex.print2d(" <esc> => quit", 0.02, 0.40, 20);

			wtex.print2d(" <h> => toggle-this-help-screen", 0.02, 0.35, 20);


		elsif detales then -- debug info (x-key)

			wtex.print2d(" ME: "&float'image(xme)&","&float'image(zme),0.02,0.9,25 );

			wtex.print2d(" bkg="& integer'image(bkg), 0.02, 0.8, 25);
			wtex.print2d(" hdpi: " &
				interfaces.c.int'image(Fwid)&" X "
				& interfaces.c.int'image(Fhit), 0.02, 0.7, 25 );

--------- begin OGL queries -----------------------------------------

			glGetIntegerv(GL_CONTEXT_PROFILE_MASK, profile'address);
			if( profile = GL_CONTEXT_CORE_PROFILE_BIT ) then
				wtex.print2d("ogl-query:  Core Profile", 0.02, 0.6, 20);
			end if;

			-- Note that OSX currently requires the forward_compatible flag!
			glGetIntegerv(GL_CONTEXT_FLAGS, flags'address);
			if( flags = GL_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT ) then
				wtex.print2d("ogl-query:  Forward-Compatible bit is set", 0.02, 0.55, 10);
			end if;

			glgetintegerv(gl_major_version, major'address);
			glgetintegerv(gl_minor_version, minor'address);
			wtex.print2d( "ogl-query: OGL-major: "&glint'image(major), 0.02, 0.5, 10);
			wtex.print2d( "ogl-query: OGL-minor: "&glint'image(minor), 0.02, 0.45, 10);

			glgetintegerv(gl_max_texture_units, mtu'address);
			wtex.print2d( "ogl-query: maxTexUnits: "&glint'image(mtu), 0.02, 0.4, 10);

			glgetintegerv(gl_max_texture_image_units, mtu'address);
			wtex.print2d( "ogl-query: maxTexImgUnits: "&glint'image(mtu), 0.02, 0.35, 10);

			glgetintegerv(gl_max_combined_texture_image_units, mtu'address);
			wtex.print2d( "ogl-query: maxComwtexImgUnits: "&glint'image(mtu), 0.02, 0.3, 10);

			glgetintegerv(gl_max_uniform_buffer_bindings, mul'address);
			wtex.print2d("ogl-query: maxUnifBufferBindings: "&glint'image(mul),0.02,0.25,10);

			glgetintegerv(gl_max_uniform_locations, mul'address);
			wtex.print2d("ogl-query: maxUniformLocations: "&glint'image(mul), 0.02,0.20,10);


--------- end OGL queries -----------------------------------------





		end if; -- worming/detales





		--minimal gl error check if dbug
		if dbug then
			if dumpGLerrorQueue("gameutils.island_ftn loop end")>0 then
				--raise beach_error;
				null;
			end if;
		end if;




		glflush;
		glfwSwapBuffers( mainWindow );

   end loop; 
	----------------------- main event loop end -----------------------

	if not userexit then
		snd4ada.stopLoops;
	end if; --otherwise stopSnd is called at end of main


	myassert( (dhdstate>0) or userexit , 114 );
	myassert( dhdstate <= 5, 115 );

	return dhdstate;


exception -- added 8jan18

	when ada.numerics.argument_error =>

		new_line;
		put("iFtn:  xme="&float'image(xme));
		put("iFtn:  zme="&float'image(zme));
		new_line;

		put("iFtn:  xcam="&float'image(xcam));
		put("iFtn:  zcam="&float'image(zcam));
		new_line;

		put("iFtn:  xme-xcam="&float'image(xme-xcam));
		put("iFtn:  zme-zcam="&float'image(zme-zcam));
		new_line;

		raise;



end drawisland;


