
--
-- Copyright (C) 2020  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--

with system;
with gl, gl.binding, gl.pointers;
with glu, glu.binding, glu.pointers;
with glext, glext.binding, glext.pointers;

with interfaces.c;
use type interfaces.c.unsigned_short;


with ada.finalization;
with unchecked_deallocation;

with matutils; use matutils;

	with text_io;

package body frameobj is  -- textured frame for rectangular region
-- 1-sided only



procedure initialize( rect: in out frame ) is
begin
	rect.vert := new varray;
	rect.norm := new varray;
	rect.txuv := new tarray;
	rect.elem := new earray;
end initialize;

procedure vfree is new unchecked_deallocation(varray,vap);
procedure tfree is new unchecked_deallocation(tarray,tap);
procedure efree is new unchecked_deallocation(earray,eap);

procedure finalize( rect: in out frame ) is
begin
	vfree( rect.vert );
	vfree( rect.norm );
	tfree( rect.txuv );
	efree( rect.elem );
	--text_io.put_line("rect Free");
end finalize;





-- this initializer is intended for texture images
-- that must not be reversed, EG. when lettering exists.
procedure setrect( rect: frame;
xc,yc,zc, xr,yr,zr, ww : float;
iwhich : integer  -- 1=>Z+=no, 2=>X+=we, 3=>Z-=so, 4=>X-=ea
) is

	k, j : integer := 0;
	xm,xp, ym,yp, zm,zp: float;
	mx,px, my,py, mz,pz: float;
	ax,ay,az, bx,by,bz, nx,ny,nz : float;
	jj: glushort;
begin

	if iwhich<1 or iwhich>4 then
		text_io.put_line("frameobj::iwhich not in 1..4");
		raise program_error;
	end if;

	xm  := xc-xr;
	xp  := xc+xr;
	ym  := yc-yr;
	yp  := yc+yr;
	zm  := zc-zr;
	zp  := zc+zr;

if iwhich=1 then -- Z+=No
	-- front
	--rect.vert(k+ 1):=xp;  rect.vert(k+ 2):=ym;  rect.vert(k+ 3):=zp;
	--rect.vert(k+ 4):=xm;  rect.vert(k+ 5):=ym;  rect.vert(k+ 6):=zp;
	--rect.vert(k+ 7):=xm;  rect.vert(k+ 8):=yp;  rect.vert(k+ 9):=zp;
	--rect.vert(k+10):=xp;  rect.vert(k+11):=yp;  rect.vert(k+12):=zp;

	--left
	px:=xp+ww; mx:=xp;
	py:=yp+ww; my:=ym-ww;
	rect.vert(k+ 1):=px;  rect.vert(k+ 2):=my;  rect.vert(k+ 3):=zp;
	rect.vert(k+ 4):=mx;  rect.vert(k+ 5):=my;  rect.vert(k+ 6):=zp;
	rect.vert(k+ 7):=mx;  rect.vert(k+ 8):=py;  rect.vert(k+ 9):=zp;
	rect.vert(k+10):=px;  rect.vert(k+11):=py;  rect.vert(k+12):=zp;
-------- begin insert ---------------------------------------
	ax:=rect.vert(k+1)-rect.vert(k+4);
	ay:=rect.vert(k+2)-rect.vert(k+5);
	az:=rect.vert(k+3)-rect.vert(k+6);
	bx:=rect.vert(k+7)-rect.vert(k+4);
	by:=rect.vert(k+8)-rect.vert(k+5);
	bz:=rect.vert(k+9)-rect.vert(k+6);
	cross(ax,ay,az, bx,by,bz, nx,ny,nz);
	normalize(nx,ny,nz);
	----------------------------------------------------------
	rect.norm(k+ 1):=nx;  rect.norm(k+ 2):=ny;  rect.norm(k+ 3):=nz;
	rect.norm(k+ 4):=nx;  rect.norm(k+ 5):=ny;  rect.norm(k+ 6):=nz;
	rect.norm(k+ 7):=nx;  rect.norm(k+ 8):=ny;  rect.norm(k+ 9):=nz;
	rect.norm(k+10):=nx;  rect.norm(k+11):=ny;  rect.norm(k+12):=nz;
-------- end insert ---------------------------------------
	k:=k+12;

	--right
	px:=xm; mx:=xm-ww;
	py:=yp+ww; my:=ym-ww;
	rect.vert(k+ 1):=px;  rect.vert(k+ 2):=my;  rect.vert(k+ 3):=zp;
	rect.vert(k+ 4):=mx;  rect.vert(k+ 5):=my;  rect.vert(k+ 6):=zp;
	rect.vert(k+ 7):=mx;  rect.vert(k+ 8):=py;  rect.vert(k+ 9):=zp;
	rect.vert(k+10):=px;  rect.vert(k+11):=py;  rect.vert(k+12):=zp;
-------- begin insert ---------------------------------------
	ax:=rect.vert(k+1)-rect.vert(k+4);
	ay:=rect.vert(k+2)-rect.vert(k+5);
	az:=rect.vert(k+3)-rect.vert(k+6);
	bx:=rect.vert(k+7)-rect.vert(k+4);
	by:=rect.vert(k+8)-rect.vert(k+5);
	bz:=rect.vert(k+9)-rect.vert(k+6);
	cross(ax,ay,az, bx,by,bz, nx,ny,nz);
	normalize(nx,ny,nz);
	----------------------------------------------------------
	rect.norm(k+ 1):=nx;  rect.norm(k+ 2):=ny;  rect.norm(k+ 3):=nz;
	rect.norm(k+ 4):=nx;  rect.norm(k+ 5):=ny;  rect.norm(k+ 6):=nz;
	rect.norm(k+ 7):=nx;  rect.norm(k+ 8):=ny;  rect.norm(k+ 9):=nz;
	rect.norm(k+10):=nx;  rect.norm(k+11):=ny;  rect.norm(k+12):=nz;
-------- end insert ---------------------------------------
	k:=k+12;


	--top
	px:=xp; mx:=xm;
	py:=yp+ww; my:=yp;
	rect.vert(k+ 1):=px;  rect.vert(k+ 2):=my;  rect.vert(k+ 3):=zp;
	rect.vert(k+ 4):=mx;  rect.vert(k+ 5):=my;  rect.vert(k+ 6):=zp;
	rect.vert(k+ 7):=mx;  rect.vert(k+ 8):=py;  rect.vert(k+ 9):=zp;
	rect.vert(k+10):=px;  rect.vert(k+11):=py;  rect.vert(k+12):=zp;
-------- begin insert ---------------------------------------
	ax:=rect.vert(k+1)-rect.vert(k+4);
	ay:=rect.vert(k+2)-rect.vert(k+5);
	az:=rect.vert(k+3)-rect.vert(k+6);
	bx:=rect.vert(k+7)-rect.vert(k+4);
	by:=rect.vert(k+8)-rect.vert(k+5);
	bz:=rect.vert(k+9)-rect.vert(k+6);
	cross(ax,ay,az, bx,by,bz, nx,ny,nz);
	normalize(nx,ny,nz);
	----------------------------------------------------------
	rect.norm(k+ 1):=nx;  rect.norm(k+ 2):=ny;  rect.norm(k+ 3):=nz;
	rect.norm(k+ 4):=nx;  rect.norm(k+ 5):=ny;  rect.norm(k+ 6):=nz;
	rect.norm(k+ 7):=nx;  rect.norm(k+ 8):=ny;  rect.norm(k+ 9):=nz;
	rect.norm(k+10):=nx;  rect.norm(k+11):=ny;  rect.norm(k+12):=nz;
-------- end insert ---------------------------------------
	k:=k+12;

	--bottom
	px:=xp; mx:=xm;
	py:=ym; my:=ym-ww;
	rect.vert(k+ 1):=px;  rect.vert(k+ 2):=my;  rect.vert(k+ 3):=zp;
	rect.vert(k+ 4):=mx;  rect.vert(k+ 5):=my;  rect.vert(k+ 6):=zp;
	rect.vert(k+ 7):=mx;  rect.vert(k+ 8):=py;  rect.vert(k+ 9):=zp;
	rect.vert(k+10):=px;  rect.vert(k+11):=py;  rect.vert(k+12):=zp;
-------- begin insert ---------------------------------------
	ax:=rect.vert(k+1)-rect.vert(k+4);
	ay:=rect.vert(k+2)-rect.vert(k+5);
	az:=rect.vert(k+3)-rect.vert(k+6);
	bx:=rect.vert(k+7)-rect.vert(k+4);
	by:=rect.vert(k+8)-rect.vert(k+5);
	bz:=rect.vert(k+9)-rect.vert(k+6);
	cross(ax,ay,az, bx,by,bz, nx,ny,nz);
	normalize(nx,ny,nz);
	----------------------------------------------------------
	rect.norm(k+ 1):=nx;  rect.norm(k+ 2):=ny;  rect.norm(k+ 3):=nz;
	rect.norm(k+ 4):=nx;  rect.norm(k+ 5):=ny;  rect.norm(k+ 6):=nz;
	rect.norm(k+ 7):=nx;  rect.norm(k+ 8):=ny;  rect.norm(k+ 9):=nz;
	rect.norm(k+10):=nx;  rect.norm(k+11):=ny;  rect.norm(k+12):=nz;
-------- end insert ---------------------------------------
	k:=k+12;




elsif iwhich=3 then -- Z-=So
	-- back
	--rect.vert(k+ 1):=xm;  rect.vert(k+ 2):=ym;  rect.vert(k+ 3):=zm;
	--rect.vert(k+ 4):=xp;  rect.vert(k+ 5):=ym;  rect.vert(k+ 6):=zm;
	--rect.vert(k+ 7):=xp;  rect.vert(k+ 8):=yp;  rect.vert(k+ 9):=zm;
	--rect.vert(k+10):=xm;  rect.vert(k+11):=yp;  rect.vert(k+12):=zm;


	px:=xm; mx:=xm-ww;
	py:=yp+ww; my:=ym-ww;
	rect.vert(k+ 1):=mx;  rect.vert(k+ 2):=my;  rect.vert(k+ 3):=zm;
	rect.vert(k+ 4):=px;  rect.vert(k+ 5):=my;  rect.vert(k+ 6):=zm;
	rect.vert(k+ 7):=px;  rect.vert(k+ 8):=py;  rect.vert(k+ 9):=zm;
	rect.vert(k+10):=mx;  rect.vert(k+11):=py;  rect.vert(k+12):=zm;
-------- begin insert ---------------------------------------
	ax:=rect.vert(k+1)-rect.vert(k+4);
	ay:=rect.vert(k+2)-rect.vert(k+5);
	az:=rect.vert(k+3)-rect.vert(k+6);
	bx:=rect.vert(k+7)-rect.vert(k+4);
	by:=rect.vert(k+8)-rect.vert(k+5);
	bz:=rect.vert(k+9)-rect.vert(k+6);
	cross(ax,ay,az, bx,by,bz, nx,ny,nz);
	normalize(nx,ny,nz);
	----------------------------------------------------------
	rect.norm(k+ 1):=nx;  rect.norm(k+ 2):=ny;  rect.norm(k+ 3):=nz;
	rect.norm(k+ 4):=nx;  rect.norm(k+ 5):=ny;  rect.norm(k+ 6):=nz;
	rect.norm(k+ 7):=nx;  rect.norm(k+ 8):=ny;  rect.norm(k+ 9):=nz;
	rect.norm(k+10):=nx;  rect.norm(k+11):=ny;  rect.norm(k+12):=nz;
-------- end insert ---------------------------------------
	k:=k+12;

	px:=xp+ww; mx:=xp;
	py:=yp+ww; my:=ym-ww;
	rect.vert(k+ 1):=mx;  rect.vert(k+ 2):=my;  rect.vert(k+ 3):=zm;
	rect.vert(k+ 4):=px;  rect.vert(k+ 5):=my;  rect.vert(k+ 6):=zm;
	rect.vert(k+ 7):=px;  rect.vert(k+ 8):=py;  rect.vert(k+ 9):=zm;
	rect.vert(k+10):=mx;  rect.vert(k+11):=py;  rect.vert(k+12):=zm;
-------- begin insert ---------------------------------------
	ax:=rect.vert(k+1)-rect.vert(k+4);
	ay:=rect.vert(k+2)-rect.vert(k+5);
	az:=rect.vert(k+3)-rect.vert(k+6);
	bx:=rect.vert(k+7)-rect.vert(k+4);
	by:=rect.vert(k+8)-rect.vert(k+5);
	bz:=rect.vert(k+9)-rect.vert(k+6);
	cross(ax,ay,az, bx,by,bz, nx,ny,nz);
	normalize(nx,ny,nz);
	----------------------------------------------------------
	rect.norm(k+ 1):=nx;  rect.norm(k+ 2):=ny;  rect.norm(k+ 3):=nz;
	rect.norm(k+ 4):=nx;  rect.norm(k+ 5):=ny;  rect.norm(k+ 6):=nz;
	rect.norm(k+ 7):=nx;  rect.norm(k+ 8):=ny;  rect.norm(k+ 9):=nz;
	rect.norm(k+10):=nx;  rect.norm(k+11):=ny;  rect.norm(k+12):=nz;
-------- end insert ---------------------------------------
	k:=k+12;


	--top
	px:=xp; mx:=xm;
	py:=yp+ww; my:=yp;
	rect.vert(k+ 1):=mx;  rect.vert(k+ 2):=my;  rect.vert(k+ 3):=zm;
	rect.vert(k+ 4):=px;  rect.vert(k+ 5):=my;  rect.vert(k+ 6):=zm;
	rect.vert(k+ 7):=px;  rect.vert(k+ 8):=py;  rect.vert(k+ 9):=zm;
	rect.vert(k+10):=mx;  rect.vert(k+11):=py;  rect.vert(k+12):=zm;
-------- begin insert ---------------------------------------
	ax:=rect.vert(k+1)-rect.vert(k+4);
	ay:=rect.vert(k+2)-rect.vert(k+5);
	az:=rect.vert(k+3)-rect.vert(k+6);
	bx:=rect.vert(k+7)-rect.vert(k+4);
	by:=rect.vert(k+8)-rect.vert(k+5);
	bz:=rect.vert(k+9)-rect.vert(k+6);
	cross(ax,ay,az, bx,by,bz, nx,ny,nz);
	normalize(nx,ny,nz);
	----------------------------------------------------------
	rect.norm(k+ 1):=nx;  rect.norm(k+ 2):=ny;  rect.norm(k+ 3):=nz;
	rect.norm(k+ 4):=nx;  rect.norm(k+ 5):=ny;  rect.norm(k+ 6):=nz;
	rect.norm(k+ 7):=nx;  rect.norm(k+ 8):=ny;  rect.norm(k+ 9):=nz;
	rect.norm(k+10):=nx;  rect.norm(k+11):=ny;  rect.norm(k+12):=nz;
-------- end insert ---------------------------------------
	k:=k+12;

	--bottom
	px:=xp; mx:=xm;
	py:=ym; my:=ym-ww;
	rect.vert(k+ 1):=mx;  rect.vert(k+ 2):=my;  rect.vert(k+ 3):=zm;
	rect.vert(k+ 4):=px;  rect.vert(k+ 5):=my;  rect.vert(k+ 6):=zm;
	rect.vert(k+ 7):=px;  rect.vert(k+ 8):=py;  rect.vert(k+ 9):=zm;
	rect.vert(k+10):=mx;  rect.vert(k+11):=py;  rect.vert(k+12):=zm;
-------- begin insert ---------------------------------------
	ax:=rect.vert(k+1)-rect.vert(k+4);
	ay:=rect.vert(k+2)-rect.vert(k+5);
	az:=rect.vert(k+3)-rect.vert(k+6);
	bx:=rect.vert(k+7)-rect.vert(k+4);
	by:=rect.vert(k+8)-rect.vert(k+5);
	bz:=rect.vert(k+9)-rect.vert(k+6);
	cross(ax,ay,az, bx,by,bz, nx,ny,nz);
	normalize(nx,ny,nz);
	----------------------------------------------------------
	rect.norm(k+ 1):=nx;  rect.norm(k+ 2):=ny;  rect.norm(k+ 3):=nz;
	rect.norm(k+ 4):=nx;  rect.norm(k+ 5):=ny;  rect.norm(k+ 6):=nz;
	rect.norm(k+ 7):=nx;  rect.norm(k+ 8):=ny;  rect.norm(k+ 9):=nz;
	rect.norm(k+10):=nx;  rect.norm(k+11):=ny;  rect.norm(k+12):=nz;
-------- end insert ---------------------------------------
	k:=k+12;






elsif iwhich=4 then -- X-=Ea
	-- left
	--rect.vert(k+ 1):=xm;  rect.vert(k+ 2):=ym;  rect.vert(k+ 3):=zm;
	--rect.vert(k+ 4):=xm;  rect.vert(k+ 5):=ym;  rect.vert(k+ 6):=zp;
	--rect.vert(k+ 7):=xm;  rect.vert(k+ 8):=yp;  rect.vert(k+ 9):=zp;
	--rect.vert(k+10):=xm;  rect.vert(k+11):=yp;  rect.vert(k+12):=zm;


	--lf/rt
	mz:=zp; pz:=zp+ww;
	my:=ym-ww; py:=yp+ww;
	rect.vert(k+ 1):=xm;  rect.vert(k+ 2):=my;  rect.vert(k+ 3):=mz;
	rect.vert(k+ 4):=xm;  rect.vert(k+ 5):=my;  rect.vert(k+ 6):=pz;
	rect.vert(k+ 7):=xm;  rect.vert(k+ 8):=py;  rect.vert(k+ 9):=pz;
	rect.vert(k+10):=xm;  rect.vert(k+11):=py;  rect.vert(k+12):=mz;
-------- begin insert ---------------------------------------
	ax:=rect.vert(k+1)-rect.vert(k+4);
	ay:=rect.vert(k+2)-rect.vert(k+5);
	az:=rect.vert(k+3)-rect.vert(k+6);
	bx:=rect.vert(k+7)-rect.vert(k+4);
	by:=rect.vert(k+8)-rect.vert(k+5);
	bz:=rect.vert(k+9)-rect.vert(k+6);
	cross(ax,ay,az, bx,by,bz, nx,ny,nz);
	normalize(nx,ny,nz);
	----------------------------------------------------------
	rect.norm(k+ 1):=nx;  rect.norm(k+ 2):=ny;  rect.norm(k+ 3):=nz;
	rect.norm(k+ 4):=nx;  rect.norm(k+ 5):=ny;  rect.norm(k+ 6):=nz;
	rect.norm(k+ 7):=nx;  rect.norm(k+ 8):=ny;  rect.norm(k+ 9):=nz;
	rect.norm(k+10):=nx;  rect.norm(k+11):=ny;  rect.norm(k+12):=nz;
-------- end insert ---------------------------------------
	k:=k+12;

	--lf/rt
	mz:=zm-ww; pz:=zm;
	my:=ym-ww; py:=yp+ww;
	rect.vert(k+ 1):=xm;  rect.vert(k+ 2):=my;  rect.vert(k+ 3):=mz;
	rect.vert(k+ 4):=xm;  rect.vert(k+ 5):=my;  rect.vert(k+ 6):=pz;
	rect.vert(k+ 7):=xm;  rect.vert(k+ 8):=py;  rect.vert(k+ 9):=pz;
	rect.vert(k+10):=xm;  rect.vert(k+11):=py;  rect.vert(k+12):=mz;
-------- begin insert ---------------------------------------
	ax:=rect.vert(k+1)-rect.vert(k+4);
	ay:=rect.vert(k+2)-rect.vert(k+5);
	az:=rect.vert(k+3)-rect.vert(k+6);
	bx:=rect.vert(k+7)-rect.vert(k+4);
	by:=rect.vert(k+8)-rect.vert(k+5);
	bz:=rect.vert(k+9)-rect.vert(k+6);
	cross(ax,ay,az, bx,by,bz, nx,ny,nz);
	normalize(nx,ny,nz);
	----------------------------------------------------------
	rect.norm(k+ 1):=nx;  rect.norm(k+ 2):=ny;  rect.norm(k+ 3):=nz;
	rect.norm(k+ 4):=nx;  rect.norm(k+ 5):=ny;  rect.norm(k+ 6):=nz;
	rect.norm(k+ 7):=nx;  rect.norm(k+ 8):=ny;  rect.norm(k+ 9):=nz;
	rect.norm(k+10):=nx;  rect.norm(k+11):=ny;  rect.norm(k+12):=nz;
-------- end insert ---------------------------------------
	k:=k+12;




	--top
	mz:=zm; pz:=zp;
	my:=yp; py:=yp+ww;
	rect.vert(k+ 1):=xm;  rect.vert(k+ 2):=my;  rect.vert(k+ 3):=mz;
	rect.vert(k+ 4):=xm;  rect.vert(k+ 5):=my;  rect.vert(k+ 6):=pz;
	rect.vert(k+ 7):=xm;  rect.vert(k+ 8):=py;  rect.vert(k+ 9):=pz;
	rect.vert(k+10):=xm;  rect.vert(k+11):=py;  rect.vert(k+12):=mz;
-------- begin insert ---------------------------------------
	ax:=rect.vert(k+1)-rect.vert(k+4);
	ay:=rect.vert(k+2)-rect.vert(k+5);
	az:=rect.vert(k+3)-rect.vert(k+6);
	bx:=rect.vert(k+7)-rect.vert(k+4);
	by:=rect.vert(k+8)-rect.vert(k+5);
	bz:=rect.vert(k+9)-rect.vert(k+6);
	cross(ax,ay,az, bx,by,bz, nx,ny,nz);
	normalize(nx,ny,nz);
	----------------------------------------------------------
	rect.norm(k+ 1):=nx;  rect.norm(k+ 2):=ny;  rect.norm(k+ 3):=nz;
	rect.norm(k+ 4):=nx;  rect.norm(k+ 5):=ny;  rect.norm(k+ 6):=nz;
	rect.norm(k+ 7):=nx;  rect.norm(k+ 8):=ny;  rect.norm(k+ 9):=nz;
	rect.norm(k+10):=nx;  rect.norm(k+11):=ny;  rect.norm(k+12):=nz;
-------- end insert ---------------------------------------
	k:=k+12;

	--bottom
	mz:=zm; pz:=zp;
	my:=ym-ww; py:=ym;
	rect.vert(k+ 1):=xm;  rect.vert(k+ 2):=my;  rect.vert(k+ 3):=mz;
	rect.vert(k+ 4):=xm;  rect.vert(k+ 5):=my;  rect.vert(k+ 6):=pz;
	rect.vert(k+ 7):=xm;  rect.vert(k+ 8):=py;  rect.vert(k+ 9):=pz;
	rect.vert(k+10):=xm;  rect.vert(k+11):=py;  rect.vert(k+12):=mz;
-------- begin insert ---------------------------------------
	ax:=rect.vert(k+1)-rect.vert(k+4);
	ay:=rect.vert(k+2)-rect.vert(k+5);
	az:=rect.vert(k+3)-rect.vert(k+6);
	bx:=rect.vert(k+7)-rect.vert(k+4);
	by:=rect.vert(k+8)-rect.vert(k+5);
	bz:=rect.vert(k+9)-rect.vert(k+6);
	cross(ax,ay,az, bx,by,bz, nx,ny,nz);
	normalize(nx,ny,nz);
	----------------------------------------------------------
	rect.norm(k+ 1):=nx;  rect.norm(k+ 2):=ny;  rect.norm(k+ 3):=nz;
	rect.norm(k+ 4):=nx;  rect.norm(k+ 5):=ny;  rect.norm(k+ 6):=nz;
	rect.norm(k+ 7):=nx;  rect.norm(k+ 8):=ny;  rect.norm(k+ 9):=nz;
	rect.norm(k+10):=nx;  rect.norm(k+11):=ny;  rect.norm(k+12):=nz;
-------- end insert ---------------------------------------
	k:=k+12;






elsif iwhich=2 then -- X+=We
	-- right
	--rect.vert(k+ 1):=xp;  rect.vert(k+ 2):=ym;  rect.vert(k+ 3):=zp;
	--rect.vert(k+ 4):=xp;  rect.vert(k+ 5):=ym;  rect.vert(k+ 6):=zm;
	--rect.vert(k+ 7):=xp;  rect.vert(k+ 8):=yp;  rect.vert(k+ 9):=zm;
	--rect.vert(k+10):=xp;  rect.vert(k+11):=yp;  rect.vert(k+12):=zp;


	--lf/rt
	mz:=zp; pz:=zp+ww;
	my:=ym-ww; py:=yp+ww;
	rect.vert(k+ 1):=xp;  rect.vert(k+ 2):=my;  rect.vert(k+ 3):=pz;
	rect.vert(k+ 4):=xp;  rect.vert(k+ 5):=my;  rect.vert(k+ 6):=mz;
	rect.vert(k+ 7):=xp;  rect.vert(k+ 8):=py;  rect.vert(k+ 9):=mz;
	rect.vert(k+10):=xp;  rect.vert(k+11):=py;  rect.vert(k+12):=pz;
-------- begin insert ---------------------------------------
	ax:=rect.vert(k+1)-rect.vert(k+4);
	ay:=rect.vert(k+2)-rect.vert(k+5);
	az:=rect.vert(k+3)-rect.vert(k+6);
	bx:=rect.vert(k+7)-rect.vert(k+4);
	by:=rect.vert(k+8)-rect.vert(k+5);
	bz:=rect.vert(k+9)-rect.vert(k+6);
	cross(ax,ay,az, bx,by,bz, nx,ny,nz);
	normalize(nx,ny,nz);
	----------------------------------------------------------
	rect.norm(k+ 1):=nx;  rect.norm(k+ 2):=ny;  rect.norm(k+ 3):=nz;
	rect.norm(k+ 4):=nx;  rect.norm(k+ 5):=ny;  rect.norm(k+ 6):=nz;
	rect.norm(k+ 7):=nx;  rect.norm(k+ 8):=ny;  rect.norm(k+ 9):=nz;
	rect.norm(k+10):=nx;  rect.norm(k+11):=ny;  rect.norm(k+12):=nz;
-------- end insert ---------------------------------------
	k:=k+12;

	--lf/rt
	mz:=zm-ww; pz:=zm;
	my:=ym-ww; py:=yp+ww;
	rect.vert(k+ 1):=xp;  rect.vert(k+ 2):=my;  rect.vert(k+ 3):=pz;
	rect.vert(k+ 4):=xp;  rect.vert(k+ 5):=my;  rect.vert(k+ 6):=mz;
	rect.vert(k+ 7):=xp;  rect.vert(k+ 8):=py;  rect.vert(k+ 9):=mz;
	rect.vert(k+10):=xp;  rect.vert(k+11):=py;  rect.vert(k+12):=pz;
-------- begin insert ---------------------------------------
	ax:=rect.vert(k+1)-rect.vert(k+4);
	ay:=rect.vert(k+2)-rect.vert(k+5);
	az:=rect.vert(k+3)-rect.vert(k+6);
	bx:=rect.vert(k+7)-rect.vert(k+4);
	by:=rect.vert(k+8)-rect.vert(k+5);
	bz:=rect.vert(k+9)-rect.vert(k+6);
	cross(ax,ay,az, bx,by,bz, nx,ny,nz);
	normalize(nx,ny,nz);
	----------------------------------------------------------
	rect.norm(k+ 1):=nx;  rect.norm(k+ 2):=ny;  rect.norm(k+ 3):=nz;
	rect.norm(k+ 4):=nx;  rect.norm(k+ 5):=ny;  rect.norm(k+ 6):=nz;
	rect.norm(k+ 7):=nx;  rect.norm(k+ 8):=ny;  rect.norm(k+ 9):=nz;
	rect.norm(k+10):=nx;  rect.norm(k+11):=ny;  rect.norm(k+12):=nz;
-------- end insert ---------------------------------------
	k:=k+12;



	--top
	mz:=zm; pz:=zp;
	my:=yp; py:=yp+ww;
	rect.vert(k+ 1):=xp;  rect.vert(k+ 2):=my;  rect.vert(k+ 3):=pz;
	rect.vert(k+ 4):=xp;  rect.vert(k+ 5):=my;  rect.vert(k+ 6):=mz;
	rect.vert(k+ 7):=xp;  rect.vert(k+ 8):=py;  rect.vert(k+ 9):=mz;
	rect.vert(k+10):=xp;  rect.vert(k+11):=py;  rect.vert(k+12):=pz;
-------- begin insert ---------------------------------------
	ax:=rect.vert(k+1)-rect.vert(k+4);
	ay:=rect.vert(k+2)-rect.vert(k+5);
	az:=rect.vert(k+3)-rect.vert(k+6);
	bx:=rect.vert(k+7)-rect.vert(k+4);
	by:=rect.vert(k+8)-rect.vert(k+5);
	bz:=rect.vert(k+9)-rect.vert(k+6);
	cross(ax,ay,az, bx,by,bz, nx,ny,nz);
	normalize(nx,ny,nz);
	----------------------------------------------------------
	rect.norm(k+ 1):=nx;  rect.norm(k+ 2):=ny;  rect.norm(k+ 3):=nz;
	rect.norm(k+ 4):=nx;  rect.norm(k+ 5):=ny;  rect.norm(k+ 6):=nz;
	rect.norm(k+ 7):=nx;  rect.norm(k+ 8):=ny;  rect.norm(k+ 9):=nz;
	rect.norm(k+10):=nx;  rect.norm(k+11):=ny;  rect.norm(k+12):=nz;
-------- end insert ---------------------------------------
	k:=k+12;

	--bottom
	mz:=zm; pz:=zp;
	my:=ym-ww; py:=ym;
	rect.vert(k+ 1):=xp;  rect.vert(k+ 2):=my;  rect.vert(k+ 3):=pz;
	rect.vert(k+ 4):=xp;  rect.vert(k+ 5):=my;  rect.vert(k+ 6):=mz;
	rect.vert(k+ 7):=xp;  rect.vert(k+ 8):=py;  rect.vert(k+ 9):=mz;
	rect.vert(k+10):=xp;  rect.vert(k+11):=py;  rect.vert(k+12):=pz;
-------- begin insert ---------------------------------------
	ax:=rect.vert(k+1)-rect.vert(k+4);
	ay:=rect.vert(k+2)-rect.vert(k+5);
	az:=rect.vert(k+3)-rect.vert(k+6);
	bx:=rect.vert(k+7)-rect.vert(k+4);
	by:=rect.vert(k+8)-rect.vert(k+5);
	bz:=rect.vert(k+9)-rect.vert(k+6);
	cross(ax,ay,az, bx,by,bz, nx,ny,nz);
	normalize(nx,ny,nz);
	----------------------------------------------------------
	rect.norm(k+ 1):=nx;  rect.norm(k+ 2):=ny;  rect.norm(k+ 3):=nz;
	rect.norm(k+ 4):=nx;  rect.norm(k+ 5):=ny;  rect.norm(k+ 6):=nz;
	rect.norm(k+ 7):=nx;  rect.norm(k+ 8):=ny;  rect.norm(k+ 9):=nz;
	rect.norm(k+10):=nx;  rect.norm(k+11):=ny;  rect.norm(k+12):=nz;
-------- end insert ---------------------------------------
	k:=k+12;



end if;




	-- texture UV coords
	for i in 0..3 loop
		j := i*8;
		rect.txuv(j+1):=1.0;  rect.txuv(j+2):=0.0;
		rect.txuv(j+3):=0.0;  rect.txuv(j+4):=0.0;
		rect.txuv(j+5):=0.0;  rect.txuv(j+6):=1.0;
		rect.txuv(j+7):=1.0;  rect.txuv(j+8):=1.0;
	end loop;


	-- element indices:
	for i in 0..3 loop
		jj:=glushort(i*4);
		j := i*6;
		rect.elem(j+1):=jj+0;
		rect.elem(j+2):=jj+1;
		rect.elem(j+3):=jj+2;
		rect.elem(j+4):=jj+2;
		rect.elem(j+5):=jj+3;
		rect.elem(j+6):=jj+0;
	end loop;


end setrect;









--
-- note:  the shaders for these objects must have two 
-- input "layouts", as well as whatever uniforms are needed:
--
-- layout(location=0) in vec3 vertPosName
-- layout(location=1) in vec3 vertRgbName
--
-- ...where their actual names can be whatever is convenient
--

use gl;
use glext;
use glext.binding;
use gl.binding;

procedure draw( rect: frame; vertbuff, uvbuff, elembuff : gluint ) is
begin

	-- 0th attribute:  vertices
	glBindBuffer(gl_array_buffer, vertbuff);
	glBufferData(gl_array_buffer, glsizeiptr(4*nvert), rect.vert(1)'address, gl_static_draw);
	glEnableVertexAttribArray(0);
	glVertexAttribPointer(0,3,gl_float,gl_false,0, system.null_address);

	-- 1st attribute:  texture UV
	glBindBuffer(gl_array_buffer, uvbuff);
	glBufferData(gl_array_buffer, glsizeiptr(4*nuv), rect.txuv(1)'address, gl_static_draw);
	glEnableVertexAttribArray(1);
	glVertexAttribPointer(1,2,gl_float,gl_false,0, system.null_address);

	-- element indices:
	glBindBuffer(gl_element_array_buffer, elembuff);
	glBufferData(gl_element_array_buffer, glsizeiptr(2*nelm), rect.elem(1)'address, gl_static_draw);

	glEnable(gl_blend);
	glBlendFunc(gl_src_alpha, gl_one_minus_src_alpha);


	glDrawElements( gl_triangles, glint(nvert), gl_unsigned_short, system.null_address );


	glDisableVertexAttribArray(0);
	glDisableVertexAttribArray(1);

end draw;




procedure ldraw( rect: frame; vertbuff, uvbuff, normbuff, elembuff : gluint ) is
begin

	-- 0th attribute:  vertices
	glBindBuffer(gl_array_buffer, vertbuff);
	glBufferData(gl_array_buffer, glsizeiptr(4*nvert), rect.vert(1)'address, gl_static_draw);
	glEnableVertexAttribArray(0);
	glVertexAttribPointer(0,3,gl_float,gl_false,0, system.null_address);

	-- 1st attribute:  texture UV
	glBindBuffer(gl_array_buffer, uvbuff);
	glBufferData(gl_array_buffer, glsizeiptr(4*nuv), rect.txuv(1)'address, gl_static_draw);
	glEnableVertexAttribArray(1);
	glVertexAttribPointer(1,2,gl_float,gl_false,0, system.null_address);


	-- 2nd attribute:  normals
	glBindBuffer(gl_array_buffer, normbuff);
	glBufferData(gl_array_buffer, glsizeiptr(4*nvert), rect.norm(1)'address, gl_static_draw);
	glEnableVertexAttribArray(2);
	glVertexAttribPointer(2,3,gl_float,gl_false,0, system.null_address);



	-- element indices:
	glBindBuffer(gl_element_array_buffer, elembuff);
	glBufferData(gl_element_array_buffer, glsizeiptr(2*nelm), rect.elem(1)'address, gl_static_draw);

	glEnable(gl_blend);
	glBlendFunc(gl_src_alpha, gl_one_minus_src_alpha);


	glDrawElements( gl_triangles, glint(nvert), gl_unsigned_short, system.null_address );


	glDisableVertexAttribArray(0);
	glDisableVertexAttribArray(1);
	glDisableVertexAttribArray(2);

end ldraw;









end frameobj;

