#version 330 core
layout(location = 0) in vec3 vertexPos;
out vec2 UV;

out vec4 vEyeSpacePos;



uniform mat4 MVP;
uniform mat4 MV;
uniform float mytime;

uniform vec3 wPos;
uniform vec3 wRad;

uniform float waterlevel;

const float myamplitude=0.05;







#define OCTAVES 5


float rand(vec2 n) { 
	return fract(sin(dot(n, vec2(13, 5))) * 43758.5453);
}

float noise(vec2 n) {
	const vec2 d = vec2(0.0, 1.0);
	vec2 b = floor(n), f = smoothstep(vec2(0.0), vec2(1.0), fract(n));
	return 
		mix(mix(rand(b), rand(b + d.yx), f.x), 
			mix(rand(b + d.xy), rand(b + d.yy), f.x), f.y);
}

float fbm(vec2 n) {
	float total = 0.0, amplitude = 1.0;
	for (int i = 0; i < OCTAVES; i++) {
		total += noise(n) * amplitude;
		n += n;
		amplitude *= 0.5;
	}
	return total;
}

vec3 tex(vec2 pos) {

	const vec3 c1 = vec3(.1,0,0);
	const vec3 c2 = vec3(.7,0,0);
	const vec3 c3 = vec3(.2,0,0);
	const vec3 c4 = vec3(1,.9,0);
	const vec3 c5 = vec3(.1);
	const vec3 c6 = vec3(.9);

	float ltime = mytime/4.0;

	vec2 p = pos;
	float q = fbm(p - ltime * -0.1);
	vec2 r = vec2(
		fbm(p + q - ltime - p.x - p.y), 
			fbm(p + q - ltime));

	// (lava colors):
	vec3 c = mix(c1, c2, fbm(p + r)) 
		+ mix(c3, c4, r.x) - mix(c5, c6, r.y);


	//return c-0.2; // a touch more black
	return c;
}








void main(){
	vec3 pos = vertexPos;

	float xmin=wPos.x-wRad.x;
	float xmax=wPos.x+wRad.x;
	float zmin=wPos.z-wRad.z;
	float zmax=wPos.z+wRad.z;
	UV = vec2( (pos.x-xmin)/(xmax-xmin), (pos.z-zmin)/(zmax-zmin) );


    vec3 color = tex(UV*20.);

	//float hotness = clamp( length(color), 0.0, 1.0);
	float hotness = clamp( color.r, 0.0, 1.0);
	hotness -= 0.5;
	hotness *= 2.0;
	//hotness *= -1.0;


	pos.y = waterlevel + myamplitude*hotness;
	
	gl_Position =  MVP * vec4(pos,1.0);
	vEyeSpacePos =  MV * vec4(pos,1.0);
}



