#version 330 core

// volcano frag shader with fog



in vec2 UV;
in vec4 aPos;
out vec4 color_final;


const float fStart=0.0;
const float fEnd=20.0;

float getFogFactor(float fFogCoord)
{
	float fResult = 0.0;
	fResult = (fEnd-fFogCoord)/(fEnd-fStart);
	fResult = 1.0-clamp(fResult, 0.0, 1.0);
	
	return sqrt(fResult);
}


//////// insert 20dec17 begin /////////////////////////////////////
uniform int fogcolr=2; // 0=>noFog, 1=>white, 2=>brown, 3=>purple, 4=>gray
uniform int foglevl=1; // 0=>noFog, 1=>Fog, 2=>heavy

const vec4 vFogColor=vec4(0.8,0.8,0.8,1.0); //normal white
const vec4 vDfogColor=vec4(0.3,0.3,0.3,1.0); //gray
const vec4 vSootColor=vec4(50.0/255,30.0/255,10.0/255,1.0); // brown
const vec4 vMystColor=vec4(0.7,0.5,0.7,1.0); // purple
//////// insert 20dec17 end /////////////////////////////////////




// halfspace discard uniforms: ////////////////////////////////////

uniform int iside=0; // 0=>noDiscard

uniform vec3 eyePos;

uniform vec3  port1;
uniform vec3  port2;

// halfspace discard uniforms end /////////////////////////////////








uniform float mytime;
uniform vec2 resolution;


vec2 cmul(const vec2 c1, const vec2 c2)
{
	return vec2(
		c1.x * c2.x - c1.y * c2.y,
		c1.x * c2.y + c1.y * c2.x
	);
}



void main( void )
{
	//vec2 uPos = ( gl_FragCoord.xy / resolution.y );//normalize wrt y axis
	vec2 uPos = UV; //( UV.xy / resolution.y );//normalize wrt y axis
	uPos -= vec2((0.25*resolution.x/resolution.y), 0.5);//shift origin to center
	uPos *= 3.0;
		
	vec3 color = vec3(0.0);
	float vertColor = 0.0;
	for( float i = 0.0; i < 3.0; ++i )
	{
		float t = mytime *(0.6) + 1.0;
	
		vec2 origPos = uPos;
		uPos.y += sin( uPos.y/2.0+uPos.x/2.0*(i/0.5+1.0)+t ) * 1.1;
		//uPos.x += sin( uPos.y/2.0+uPos.x/1.0*(i/0.5+1.0)+t ) * 2.1;
		
		uPos =  cmul(origPos, uPos);
		
		float fTemp = abs(9.0 / uPos.y/0.09 / 100.0);
		vertColor += fTemp;
		color += vec3( fTemp*i/5.0, fTemp*i/40.0, pow(fTemp,i/24.0)/64.0 );
		//color += vec3( fTemp*i/4.0, 0.0, 0.0 );
	}
	
	color_final = vec4(color, 1.0);



	vec4 vEyePos = vec4( aPos.xyz-eyePos, 1.0 );

	if( foglevl>0 ) {

		float dist2 = pow(vEyePos.x,2) + pow(vEyePos.z,2);
		float dist = sqrt(dist2);

		if( fogcolr==4 )
			color_final = mix(color_final,  vDfogColor, getFogFactor(dist)); //gray
		else if( fogcolr==3 )
			color_final = mix(color_final, vMystColor, getFogFactor(dist)); //purple
		else if( fogcolr==2 )
			color_final = mix(color_final, vSootColor, getFogFactor(dist)); //brown
		else if( fogcolr==1 )
			color_final = mix(color_final,  vFogColor, getFogFactor(dist)); //white

	}



	// fastrgv:  my halfspace-discard addendum:
	vec3 cP1 =  port1 - eyePos;
	vec3 cP2 =  port2 - eyePos;
	vec3 vP0 = aPos.xyz - eyePos;
	float PRAD = 0.80; // larger, but synched with adagate.adb
	float FOV1 = atan(PRAD/length(cP1));
	float FOV2 = atan(PRAD/length(cP2));
	vec3 nP1 = normalize(cP1);
	vec3 nP2 = normalize(cP2);
	vec3 nP0 = normalize(vP0);
	float d1=dot(nP0,nP1);
	float d2=dot(nP0,nP2);
	float a1=acos(d1);
	float a2=acos(d2);
	if( iside != 0 ) {
		if( (iside==2) && (a1>FOV1) ) discard;
		if( (iside==1) && (a2>FOV2) ) discard;
	}


}

