#version 330 core

//in float mywye;
in vec4 aPos;

out vec4 final_color;

uniform float waterlevel;

uniform sampler2D myTextureSampler;

// color assigned to match radial perturbations







const float fStart=0.0;
const float fEnd=20.0;

float getFogFactor(float fFogCoord)
{
	float fResult = 0.0;
	fResult = (fEnd-fFogCoord)/(fEnd-fStart);
	fResult = 1.0-clamp(fResult, 0.0, 1.0);
	
	return sqrt(fResult);
}


//////// insert 20dec17 begin /////////////////////////////////////
uniform int fogcolr=2; // 0=>noFog, 1=>white, 2=>brown, 3=>purple, 4=>gray
uniform int foglevl=1; // 0=>noFog, 1=>Fog, 2=>heavy

const vec4 vFogColor=vec4(0.8,0.8,0.8,1.0); //normal white
const vec4 vDfogColor=vec4(0.3,0.3,0.3,1.0); //gray
const vec4 vSootColor=vec4(50.0/255,30.0/255,10.0/255,1.0); // brown
const vec4 vMystColor=vec4(0.7,0.5,0.7,1.0); // purple
//////// insert 20dec17 end /////////////////////////////////////





// halfspace discard uniforms: ////////////////////////////////////

uniform int iside=0; // 0=>noDiscard

uniform vec3 eyePos;

uniform vec3  port1;
uniform vec3  port2;

// halfspace discard uniforms end /////////////////////////////////






void main(){

	float mxamp = 0.05; //namp=0.05
	float scale = 1.0/mxamp;
	float mywye = aPos.y;

	// 0.1 is fudge factor to push colors toward white:
	float yy = scale*(mywye-waterlevel) + 0.1;
	float tt = clamp(yy,0.0,1.0);

   vec2 tPos = vec2( 0.5, tt );
	// note:  scale = color "spread" factor
	//        const = average color [mean(mywye)=waterlevel]
	
	vec4 colr = texture( myTextureSampler, tPos).rgba;


	vec4 vEyePos = vec4( aPos.xyz-eyePos, 1.0 );

	if( foglevl>0 ) {

		float dist2 = pow(vEyePos.x,2) + pow(vEyePos.z,2);
		float dist = sqrt(dist2);

		if( fogcolr==4 )
			colr = mix(colr,  vDfogColor, getFogFactor(dist)); //gray
		else if( fogcolr==3 )
			colr = mix(colr, vMystColor, getFogFactor(dist)); //purple
		else if( fogcolr==2 )
			colr = mix(colr, vSootColor, getFogFactor(dist)); //brown
		else if( fogcolr==1 )
			colr = mix(colr,  vFogColor, getFogFactor(dist)); //white

	}

	colr.a = 1.0;
	final_color = colr;



	// fastrgv:  my halfspace-discard addendum:
	vec3 cP1 =  port1 - eyePos;
	vec3 cP2 =  port2 - eyePos;
	vec3 vP0 = aPos.xyz - eyePos;
	float PRAD = 0.80; // larger, but synched with adagate.adb
	float FOV1 = atan(PRAD/length(cP1));
	float FOV2 = atan(PRAD/length(cP2));
	vec3 nP1 = normalize(cP1);
	vec3 nP2 = normalize(cP2);
	vec3 nP0 = normalize(vP0);
	float d1=dot(nP0,nP1);
	float d2=dot(nP0,nP2);
	float a1=acos(d1);
	float a2=acos(d2);
	if( iside != 0 ) {
		if( (iside==2) && (a1>FOV1) ) discard;
		if( (iside==1) && (a2>FOV2) ) discard;
	}



}

/*
--
-- Copyright (C) 2019  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--
*/

