#version 330 core

// dark pool of purplish water frag shader

uniform float mytime;
in vec2 UV;
in vec4 vEyeSpacePos;
in vec4 aPos;
out vec4 color;



//////// insert 20dec17 begin /////////////////////////////////////
uniform int colr=3; //  0=>noFog, 1=>white, 2=>brownish, 3=>purple, 4=>gray
uniform int level=1; // 0=>noFog, 1=>Fog, 2=>heavy

const vec4 vFogColor=vec4(0.8,0.8,0.8,1.0); //normal white
const vec4 vDfogColor=vec4(0.3,0.3,0.3,1.0); //gray
const vec4 vSootColor=vec4(50.0/255,30.0/255,10.0/255,1.0); // brown
const vec4 vMystColor=vec4(0.7,0.5,0.7,1.0); // purple
//////// insert 20dec17 end /////////////////////////////////////





const float fStart=0.0;
const float fEnd=30.0;

float getFogFactor(float fFogCoord)
{
	float fResult = 0.0;
	fResult = (fEnd-fFogCoord)/(fEnd-fStart);
	fResult = 1.0-clamp(fResult, 0.0, 1.0);
	
	return sqrt(fResult);
}

const float yc=-2.85;




// halfspace discard uniforms: ////////////////////////////////////

uniform int iside=0; // 0=>noDiscard

uniform vec3 ME;

uniform vec3  port1;
uniform vec3  port2;

// halfspace discard uniforms end /////////////////////////////////





#define MAX_ITER 8
void main( void ) {


	vec2 sp = vec2( 2*UV.x-1, 2*UV.y-1 );
	vec2 p = sp*5.0 - vec2(10.0);
	vec2 i = p;
	float c = 1.0;
	
	float inten = .1;

	for (int n = 0; n < MAX_ITER; n++) 
	{
		float t = mytime * (1.0 - (3.0 / float(n+1)));
		i = p + vec2(cos(t - i.x) + sin(t + i.y), sin(t - i.y) + cos(t + i.x));
		c += 1.0/length(vec2(p.x / (sin(i.x+t)/inten),p.y / (cos(i.y+t)/inten)));
	}
	c /= float(MAX_ITER);
	c = 1.5-sqrt(c);

	float c4=c*c*c*c;
	vec4 col=vec4( 0.0, c4, 0.0, 1.0 );
	color = col + vec4(0.0, 0.0, 0.3, 1.0);
	color.a = 0.7; // ensure piranha show


	float dist2 = pow(vEyeSpacePos.x,2) + pow(vEyeSpacePos.z,2);
	float dist = abs( sqrt(dist2)/vEyeSpacePos.w );

	if( level>0 ) {

		if( colr==4 )
			color = mix(color,  vDfogColor, getFogFactor(dist)); //gray
		else if( colr==3 )
			color = mix(color, vMystColor, getFogFactor(dist)); //purple
		else if( colr==2 )
			color = mix(color, vSootColor, getFogFactor(dist)); //brown
		else if( colr==1 )
			color = mix(color,  vFogColor, getFogFactor(dist)); //white

	}


	// fastrgv:  my halfspace-discard addendum:
	vec3 cP1 =  port1 - ME;
	vec3 cP2 =  port2 - ME;
	vec3 vP0 = aPos.xyz - ME;
	float PRAD = 0.80; // larger, but synched with adagate.adb
	float FOV1 = atan(PRAD/length(cP1));
	float FOV2 = atan(PRAD/length(cP2));
	vec3 nP1 = normalize(cP1);
	vec3 nP2 = normalize(cP2);
	vec3 nP0 = normalize(vP0);
	float d1=dot(nP0,nP1);
	float d2=dot(nP0,nP2);
	float a1=acos(d1);
	float a2=acos(d2);
	if( iside != 0 ) {
		if( (iside==2) && (a1>FOV1) ) discard;
		if( (iside==1) && (a2>FOV2) ) discard;
	}



}


//--
//-- Copyright (C) 2018  <fastrgv@gmail.com>
//--
//-- This program is free software: you can redistribute it and/or modify
//-- it under the terms of the GNU General Public License as published by
//-- the Free Software Foundation, either version 3 of the License, or
//-- (at your option) any later version.
//--
//-- This program is distributed in the hope that it will be useful,
//-- but WITHOUT ANY WARRANTY; without even the implied warranty of
//-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//-- GNU General Public License for more details.
//--
//-- You may read the full text of the GNU General Public License
//-- at <http://www.gnu.org/licenses/>.
//--

