#version 330 core

// fragment shader for island palms, grasses

in vec2 UV;

in vec4 aPos;
in vec4 eyeSpacePos;


out vec4 color;

uniform sampler2D myTextureSampler;
uniform int darkness; // 0...4=darkest (bkgd)
const vec4 night = vec4(0.0,0.0,0.0,1.0);




//////// insert 20dec17 begin /////////////////////////////////////
uniform int fogcolr=1; //  0=>noFog, 1=>white, 2=>brownish, 3=>purple, 4=>gray
uniform int foglevl=0; // 0=>noFog, 1=>Fog

const vec4 vFogColor=vec4(0.7,0.7,0.7,1.0); //normal white
const vec4 vDfogColor=vec4(0.3,0.3,0.3,1.0); //gray
const vec4 vSootColor=vec4(50.0/255,30.0/255,10.0/255,1.0); // brown
const vec4 vMystColor=vec4(0.7,0.5,0.7,1.0); // purple
//////// insert 20dec17 end /////////////////////////////////////



const float fStart=0.0;
const float fEnd=12.0; // normal fog

float getFogFactor(float rng)
{

	float fResult = (fEnd-rng)/(fEnd-fStart);
	
	fResult = 1.0-clamp(fResult, 0.0, 1.0);
	
	return sqrt(fResult);
}



// this is for palms, grasses, bamboo & seaweed




void main(){
	color = texture( myTextureSampler, UV).rgba;

	float df=0;
	if( darkness < 3 ) df=0.0;
	else if( darkness==3 ) df=0.3;
	else if( darkness==4 ) df=0.6;
	float asave=color.a;
	color = mix(color, night, df);
	color.a = asave;
	if( color.a < 0.1 ) discard;


	if(foglevl>0) {

		const float yc=-1.0;
		float dist = exp(-1.0*abs(aPos.y-yc)) * length( eyeSpacePos );

		if( fogcolr==4 )
			color = mix(color,  vDfogColor, getFogFactor(dist)); //gray
		else if( fogcolr==3 )
			color = mix(color, vMystColor, getFogFactor(dist)); //purple
		else if( fogcolr==2 )
			color = mix(color, vSootColor, getFogFactor(dist)); //brown
		else if( fogcolr==1 )
			color = mix(color,  vFogColor, getFogFactor(dist)); //white

	}



}



//--
//-- Copyright (C) 2018  <fastrgv@gmail.com>
//--
//-- This program is free software: you can redistribute it and/or modify
//-- it under the terms of the GNU General Public License as published by
//-- the Free Software Foundation, either version 3 of the License, or
//-- (at your option) any later version.
//--
//-- This program is distributed in the hope that it will be useful,
//-- but WITHOUT ANY WARRANTY; without even the implied warranty of
//-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//-- GNU General Public License for more details.
//--
//-- You may read the full text of the GNU General Public License
//-- at <http://www.gnu.org/licenses/>.
//--

