#version 330 core
layout(location = 0) in vec3 vertexPos;
out vec2 UV;

out vec4 vEyeSpacePos;
out vec4 aPos;



uniform mat4 MVP;
uniform mat4 MV;
uniform float mytime;

uniform vec3 wPos;
uniform vec3 wRad;

uniform float waterlevel;

const float pi = 3.14159;
const float amplitude=0.03;
const float npeaks=5;
const float speed=0.1; //was 0.3

float wave(float r) {
    //return amplitude * sin( npeaks*(-mytime*speed+r)*2*pi); //original
    return amplitude * 2.0/(r+1.0) * sin( npeaks*(-mytime*speed+r)*2*pi);
}

float waveHeight(float x, float z) {
	float rad = sqrt(x*x+z*z);
   float height = 0.0;
   height += wave(rad);
   return height;
}


void main(){
	vec3 pos = vertexPos;
	aPos = vec4(pos,1.0);

	float xmin=wPos.x-wRad.x;
	float xmax=wPos.x+wRad.x;
	float zmin=wPos.z-wRad.z;
	float zmax=wPos.z+wRad.z;
	UV = vec2( (pos.x-xmin)/(xmax-xmin), (pos.z-zmin)/(zmax-zmin) );

	if
	( 
		( pos.y  > wPos.y + wRad.y/2 )  //only top surface
	)  
	{
	  pos.y = waterlevel + waveHeight( (vertexPos.x-wPos.x)/wRad.x, (vertexPos.z-wPos.z)/wRad.z);

	  aPos.y = (pos.y - waterlevel)/amplitude; // in -1..+1 (sent to lavaFog.fs)
	  aPos.y = 0.5*(1.0+aPos.y); // in [0..1] sent to lavaFog.fs
	}
	
	gl_Position =  MVP * vec4(pos,1.0);
	vEyeSpacePos =  MV * vec4(pos,1.0);
}


//--
//-- Copyright (C) 2018  <fastrgv@gmail.com>
//--
//-- This program is free software: you can redistribute it and/or modify
//-- it under the terms of the GNU General Public License as published by
//-- the Free Software Foundation, either version 3 of the License, or
//-- (at your option) any later version.
//--
//-- This program is distributed in the hope that it will be useful,
//-- but WITHOUT ANY WARRANTY; without even the implied warranty of
//-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//-- GNU General Public License for more details.
//--
//-- You may read the full text of the GNU General Public License
//-- at <http://www.gnu.org/licenses/>.
//--

