
--
-- Copyright (C) 2018  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--

with gl;  use gl;
with ada.finalization;
with unchecked_deallocation;




package tunnelobj is -- for rectangular textured interior (dungeon rooms)

type room is tagged private;



procedure setorect( rm: room;  xc,yc,zc, xr,yr,zr : float );

procedure draw( rm: room;  vertbuff, elembuff : gluint );


private

nvert : constant integer := 48; --84;
nelm : constant integer := 24; --42;

gap : boolean;


type varray is array(1..nvert) of float;
type vap is access varray;


type earray is array(1..nelm) of glushort;
type eap is access earray;



type room is new ada.finalization.controlled with record
vert : vap;
elem : eap;
end record;


procedure initialize(rm: in out room);
procedure finalize(rm: in out room);


end tunnelobj;
