pragma Style_Checks (Off);

with Interfaces.C; use Interfaces.C;
with Interfaces.C.Strings;
with System;
with bits_time_h;
with time_h;

package global_h is

   --  unsupported macro: ATTRIBUTE_UNUSED __attribute__ ((__unused__))
   --  unsupported macro: SND_DLSYM_BUILD_VERSION(name,version) static struct snd_dlsym_link __SND_DLSYM_VERSION(snd_dlsym_, name, version); void __SND_DLSYM_VERSION(snd_dlsym_constructor_, name, version) (void) __attribute__ ((constructor)); void __SND_DLSYM_VERSION(snd_dlsym_constructor_, name, version) (void) { __SND_DLSYM_VERSION(snd_dlsym_, name, version).next = snd_dlsym_start; __SND_DLSYM_VERSION(snd_dlsym_, name, version).dlsym_name = #name; __SND_DLSYM_VERSION(snd_dlsym_, name, version).dlsym_ptr = (void *)&name; snd_dlsym_start = &__SND_DLSYM_VERSION(snd_dlsym_, name, version); }
   --  arg-macro: procedure SND_DLSYM_VERSION (version)
   --    __STRING(version)
  --*
  -- * \file include/global.h
  -- * \brief Application interface library for the ALSA driver
  -- * \author Jaroslav Kysela <perex@perex.cz>
  -- * \author Abramo Bagnara <abramo@alsa-project.org>
  -- * \author Takashi Iwai <tiwai@suse.de>
  -- * \date 1998-2001
  -- *
  -- * Application interface library for the ALSA driver
  --  

  -- *   This library is free software; you can redistribute it and/or modify
  -- *   it under the terms of the GNU Lesser General Public License as
  -- *   published by the Free Software Foundation; either version 2.1 of
  -- *   the License, or (at your option) any later version.
  -- *
  -- *   This program is distributed in the hope that it will be useful,
  -- *   but WITHOUT ANY WARRANTY; without even the implied warranty of
  -- *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  -- *   GNU Lesser General Public License for more details.
  -- *
  -- *   You should have received a copy of the GNU Lesser General Public
  -- *   License along with this library; if not, write to the Free Software
  -- *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
  -- *
  --  

  -- for timeval and timespec  
  --*
  -- *  \defgroup Global Global defines and functions
  -- *  Global defines and functions.
  -- *  \par
  -- *  The ALSA library implementation uses these macros and functions.
  -- *  Most applications probably do not need them.
  -- *  \{
  --  

   function snd_asoundlib_version return Interfaces.C.Strings.chars_ptr;  -- ./alsa/global.h:47
   pragma Import (C, snd_asoundlib_version, "snd_asoundlib_version");

  --* do not print warning (gcc) when function parameter is not used  
  --* \hideinitializer \brief Helper macro for #SND_DLSYM_BUILD_VERSION.  
  --*
  -- * \hideinitializer
  -- * \brief Appends the build version to the name of a versioned dynamic symbol.
  --  

   type snd_dlsym_link is record
      next : access snd_dlsym_link;  -- ./alsa/global.h:67
      dlsym_name : Interfaces.C.Strings.chars_ptr;  -- ./alsa/global.h:68
      dlsym_ptr : System.Address;  -- ./alsa/global.h:69
   end record;
   pragma Convention (C_Pass_By_Copy, snd_dlsym_link);  -- ./alsa/global.h:66

   snd_dlsym_start : access snd_dlsym_link;  -- ./alsa/global.h:72
   pragma Import (C, snd_dlsym_start, "snd_dlsym_start");

  --* \hideinitializer \brief Helper macro for #SND_DLSYM_BUILD_VERSION.  
  --*
  -- * \hideinitializer
  -- * \brief Appends the build version to the name of a versioned dynamic symbol.
  --  

  --* \brief Return 'x' argument as string  
  --* \brief Returns the version of a dynamic symbol as a string.  
   function snd_dlopen (file : Interfaces.C.Strings.chars_ptr; mode : int) return System.Address;  -- ./alsa/global.h:100
   pragma Import (C, snd_dlopen, "snd_dlopen");

   function snd_dlsym
     (handle : System.Address;
      name : Interfaces.C.Strings.chars_ptr;
      version : Interfaces.C.Strings.chars_ptr) return System.Address;  -- ./alsa/global.h:101
   pragma Import (C, snd_dlsym, "snd_dlsym");

   function snd_dlclose (handle : System.Address) return int;  -- ./alsa/global.h:102
   pragma Import (C, snd_dlclose, "snd_dlclose");

  --* \brief alloca helper macro.  
  --*
  -- * \brief Internal structure for an async notification client handler.
  -- *
  -- * The ALSA library uses a pointer to this structure as a handle to an async
  -- * notification object. Applications don't access its contents directly.
  --  

   --  skipped empty struct u_snd_async_handler

   --  skipped empty struct snd_async_handler_t

  --*
  -- * \brief Async notification callback.
  -- *
  -- * See the #snd_async_add_handler function for details.
  --  

   type snd_async_callback_t is access procedure (arg1 : System.Address);
   pragma Convention (C, snd_async_callback_t);  -- ./alsa/global.h:121

   function snd_async_add_handler
     (handler : System.Address;
      fd : int;
      callback : snd_async_callback_t;
      private_data : System.Address) return int;  -- ./alsa/global.h:123
   pragma Import (C, snd_async_add_handler, "snd_async_add_handler");

   function snd_async_del_handler (handler : System.Address) return int;  -- ./alsa/global.h:125
   pragma Import (C, snd_async_del_handler, "snd_async_del_handler");

   function snd_async_handler_get_fd (handler : System.Address) return int;  -- ./alsa/global.h:126
   pragma Import (C, snd_async_handler_get_fd, "snd_async_handler_get_fd");

   function snd_async_handler_get_signo (handler : System.Address) return int;  -- ./alsa/global.h:127
   pragma Import (C, snd_async_handler_get_signo, "snd_async_handler_get_signo");

   function snd_async_handler_get_callback_private (handler : System.Address) return System.Address;  -- ./alsa/global.h:128
   pragma Import (C, snd_async_handler_get_callback_private, "snd_async_handler_get_callback_private");

   --  skipped empty struct snd_shm_area

   function snd_shm_area_create (shmid : int; ptr : System.Address) return System.Address;  -- ./alsa/global.h:130
   pragma Import (C, snd_shm_area_create, "snd_shm_area_create");

   function snd_shm_area_share (area : System.Address) return System.Address;  -- ./alsa/global.h:131
   pragma Import (C, snd_shm_area_share, "snd_shm_area_share");

   function snd_shm_area_destroy (area : System.Address) return int;  -- ./alsa/global.h:132
   pragma Import (C, snd_shm_area_destroy, "snd_shm_area_destroy");

   function snd_user_file (file : Interfaces.C.Strings.chars_ptr; result : System.Address) return int;  -- ./alsa/global.h:134
   pragma Import (C, snd_user_file, "snd_user_file");

  -- seconds  
  -- microseconds  
  -- seconds  
  -- nanoseconds  
  --* Timestamp  
   subtype snd_timestamp_t is bits_time_h.timeval;

  --* Hi-res timestamp  
   subtype snd_htimestamp_t is time_h.timespec;

  --* \}  
end global_h;
