--
-- Copyright (C) 2019  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--



separate (adagate)

procedure preplevel is
begin

			if( (level>=1) and (level<=mxlev) ) then 
			-- take care of sokwalls, barrels, receptacles here


				readPuzzle(level); --sokoban data


				-- setup sokoban arena:
				ib:=0;
				ir:=0;
				for row in 1..nrows loop
				for col in 1..ncols loop
					fcol:=float(col);
					frow:=float(row);
					
					xc:= xorigin(level)+1.0-(0.5+fcol)*rolldist; 
					ycb:=-ymax+0.01+barr; -- 22jan17
					yrw:=barr;
					ycw:=-ymax+0.01+yrw; -- 22jan17
					zc:= zorigin(level)+1.0-(0.5+frow)*rolldist;

					if( wall(row,col) = true ) then

						nko:=nko+1;
						rectobj.setrect( sokwall(row,col), xc,ycw,zc,
							rolldist*0.5, yrw, rolldist*0.5,  -- xrad,yrad,zrad
							koxlo(nko),koxhi(nko), koylo(nko),
							koyhi(nko), kozlo(nko),kozhi(nko) );
					end if;

					if( rcpt(row,col) = true ) then
						ir:=ir+1;
						recept(ir)(1):= xc;
						recept(ir)(2):= -ymax;
						recept(ir)(3):= zc;

						pictobj.setrect(sokrcpt(row,col),
							recept(ir)(1), recept(ir)(2), recept(ir)(3),
							barr,0.01,barr,
							xm,xp,ym,yp,zm,zp ); --discard
					end if;

					if( barl(row,col) = true ) then
						ib:=ib+1;
						posbar(ib)(1):= xc;
						posbar(ib)(2):= ycb;
						posbar(ib)(3):= zc;

						cyl2obj.setcyl2(barrel(ib), 
							posbar(ib)(1), posbar(ib)(2), posbar(ib)(3), barr);

					end if;

				end loop;
				end loop;


			end if; -- 1 <= level <= 4



--########################################################################
			if (level=1) then  -- nonreflective blue water



				pzlo:=-16.0; pzhi:=0.0;

				--xpcen:=0.0;  zpcen:=0.5*(pzhi+pzlo);  ypcen:=-ymax-margin;
				xpcen:=0.0;  zpcen:=0.5*(pzhi+pzlo);  ypcen:=-ymax+0.02+margin;
				xprad:=xmax; zprad:=0.5*(pzhi-pzlo);  yprad:=margin;
				waterlevel:= ypcen + yprad/2.0;

				mroomobj.setroomwithfloorgap( rmo, 0.125, 0.125, 0.125,
					pzlo,pzhi,  0.0,0.0,0.0, xmax,ymax,zmax);--10,3,20
				room_texid := loadPng(mirror,"data/myadobeT.png"); 
				rectsurf.setrect(rso,
					xpcen, zpcen, xprad, zprad); --normal water in gap
				nko:=nko+1;
				koxlo(nko):=xpcen-xprad;
				koxhi(nko):=xpcen+xprad;
				koylo(nko):=-ymax;
				koyhi(nko):=+ymax;
				kozlo(nko):=zpcen-zprad;
				kozhi(nko):=zpcen+zprad;
				pko:=nko; -- identify pool KO...does NOT obstruct portal gun

				fishx:=0.0;             --center of swim circle
				fishy:=waterlevel-0.10; --lower due to big waves...cuts off bottom fish
				fishz:=0.5*(pzlo+pzhi);
				fishr:=0.40*(pzhi-pzlo); --radius of swim circle
				fishs:=1.0;  -- swim speed
				fdx:=0.00001;
				fdy:=0.06;  -- fish size
				fdz:=0.24;
				myfish.setrect(pdfish, fdx,fdy,fdz);


				-- begin brick lining of pool

				rectobj.setrect(pxp, -- XP
					xmax-2.05*margin,ypcen+0.01,zpcen, 
					2.0*margin,      yprad+0.01, zprad, 
					xm,xp,ym,yp,zm,zp);

				rectobj.setrect(pxm, -- XM
					-xmax+2.05*margin,ypcen+0.01,zpcen, 
					2.0*margin,       yprad+0.01, zprad, 
					xm,xp,ym,yp,zm,zp);

				nko:=nko+1;
				rectobj.setrect(pzp, -- ZP
						0.0,        ypcen,  pzhi, 
						xprad-0.05, yprad, 2.0*margin, 
						koxlo(nko),koxhi(nko), koylo(nko),
						koyhi(nko), kozlo(nko),kozhi(nko) );
				koyhi(nko):=koyhi(nko)+barr;

				nko:=nko+1;
				rectobj.setrect(pzm, -- ZM
						0.0,        ypcen,  pzlo, 
						xprad-0.05, yprad, 2.0*margin, 
						koxlo(nko),koxhi(nko), koylo(nko),
						koyhi(nko), kozlo(nko),kozhi(nko) );
				koyhi(nko):=koyhi(nko)+barr;

				--bottom
				rectobj.setrect(pym,  
					0.0,  -ymax+0.05+0.02,zpcen, 
					xprad-0.05,      0.02, zprad, 
					xm,xp,ym,yp,zm,zp);



				--snd4ada_hpp.playLoop(water);
				--snd4ada_hpp.playLoop(falls); -- among-the-falls
				snd4ada_hpp.playSnd(wormx); --Xport



				-- ledge
				xc:=+0.75*xmax-0.06;
				yc:=-ymax/2.0+0.05;
				zc:=+0.50*zmax;
				xr:=+0.25*xmax;
				yr:=+ymax/2.0;
				zr:=+2.00;
				nko:=nko+1;
				rectobj.setrect(ledge,xc,yc,zc, xr,yr,zr, 
					koxlo(nko),	koxhi(nko),	koylo(nko),	
					koyhi(nko),	kozlo(nko),	kozhi(nko) );



-- begin define entry onto ledge ------------------------------------------------
				-- initial position:

				vertang := 0.0;
				horiang:=-halfpi; -- look toward puzzle
				xlook := fmath.cos(vertang)*fmath.sin(horiang);
				cylook := fmath.sin(vertang);
				zlook := fmath.cos(vertang)*fmath.cos(horiang);

				updateCamera(true);

				xme:= xc;
				yme := yc+yr+aheight;
				zme:= zc;

				-- entry [on ledge] after island stargate
				pyjump:=yme;
				vyjump:=0.0;
				jumptime:= float(sdl_getticks)/1000.0;
				jumping:=true;

-- end define entry onto ledge ------------------------------------------------



				-- ceiling (thatched)
				xc:=0.0;
				yc:=ymax-0.05;
				zc:=0.0;
				xr:=xmax-0.05;
				yr:=0.01;
				zr:=zmax-0.05;
				nko:=nko+1;
				rectobj.setrect(ceil1, xc,yc,zc, xr,yr,zr, 
					koxlo(nko),	koxhi(nko),	koylo(nko),	
					koyhi(nko),	kozlo(nko),	kozhi(nko) );

				--ceil_texid := loadPng(mirror,"data/roof1t.png"); 
				ceil_texid := loadPng(mirror,"data/roof1ts.png"); 
				-- great thatched roof!


				-- wall picture (ZPM diagram)
				xc:=0.0;
				yc:=0.0;
				zc:=zmax-0.05;
				xr:=2.0;
				yr:=2.0;
				zr:=0.01;
				nko:=nko+1;
				pictobj.setrect(pic,  xc,yc,zc, xr,yr,zr, 
					koxlo(nko),	koxhi(nko),	koylo(nko),	
					koyhi(nko),	kozlo(nko),	kozhi(nko) );

				--pic_texid := loadPng(mirror,"data/zpmtru.png");
				pic_texid := loadPng(mirror,"data/zpm0.png");

				frameobj.setrect(nfox,xc,yc,zc, xr,yr,zr, 0.3, 1); -- width, 1=North



				rectxobj.setrect(pox,x1picX,x1picY,-zmax+0.05, x1picw,x1pich,0.01); 
				--movingpic (cartoon palm tree)

				frameobj.setrect(sfox,x1picX,x1picY,-zmax+0.05, x1picw,x1pich,0.01, 
					0.3, 3); -- width, 3=South

				-- define exit box:
				xc:=-xmax;
				--yc:=-ymax+1.05;
				yc:=-ymax+0.75;
				zc:=-zmax+2.0;
				xr:=0.01;
				yr:=1.0;
				zr:=1.0;
				xboxpos(1):=xc;
				xboxpos(2):=yc;
				xboxpos(3):=zc;
				xboxrad(1):=xr;
				xboxrad(2):=yr;
				xboxrad(3):=zr;
				nko:=nko+1;
				twictobj.setrect2(xbox, xc,yc,zc, xr,yr,zr, 0.0,
					koxlo(nko),	koxhi(nko),	koylo(nko),	
					koyhi(nko),	kozlo(nko),	kozhi(nko) );
				-- use xbox1_texid, then xbox2_texid


				-- block wall partition
				xc:=-0.5*xmax+0.05;
				yc:=-1.0+0.05;
				zc:=0.0;
				xr:=0.5*xmax;
				yr:=ymax-1.0;
				zr:=0.1;
				nko:=nko+1;
				rectobj.setrect(bloc, xc,yc,zc, xr,yr,zr, 
					koxlo(nko),	koxhi(nko),	koylo(nko),	
					koyhi(nko),	kozlo(nko),	kozhi(nko) );

				myassert( nko <= maxnko, 1018 );


--########################################################################
			elsif (level=2) then  -- reflective clear water


				pzlo:= 3.0; pzhi:=zmax-4.0;

				yprad:=margin;
				ypcen:=-ymax+0.02+margin;

				xpcen:=0.0;  zpcen:=0.5*(pzhi+pzlo);  
				xprad:=xmax-0.02; zprad:=0.5*(pzhi-pzlo);  
				waterlevel:= ypcen + yprad/2.0;

				mroomobj.setroomwithfloorgap( rmo,  0.25, 0.25, 0.25,
					pzlo,pzhi,  0.0,0.0,0.0, xmax,ymax,zmax);--10,3,20

				room_texid := loadPng(mirror,"data/woodenceilingW.png");

				reflsurf.setrect(rfo,
					xpcen, zpcen, xprad, zprad); --reflective water in gap

				nko:=nko+1;
				koxlo(nko):=xpcen-xprad;
				koxhi(nko):=xpcen+xprad;
				koylo(nko):=-ymax;
				koyhi(nko):=+ymax;
				kozlo(nko):=zpcen-zprad;
				kozhi(nko):=zpcen+zprad;
				pko:=nko; -- identify pool KO...does NOT obstruct portal gun

				fishx:=0.0;
				--fishy:=waterlevel-0.06;
				fishy:=waterlevel-0.065; --vertical center lowered for big waves
				-- any lower cuts off bottom fish

				fishz:=0.5*(pzlo+pzhi);
				fishr:=0.40*(pzhi-pzlo); --radius of swim circle
				fishs:=1.0;  -- swim speed
				fdx:=0.00001;
				fdy:=0.06;  -- fish size
				fdz:=0.24;
				myfish.setrect(pdfish, fdx,fdy,fdz);


				-- begin brick lining of pool

				rectobj.setrect(pxp, --XP west
					xmax-2.05*margin,ypcen+0.01,zpcen, 
					2.0*margin,      yprad+0.01, zprad, 
					xm,xp,ym,yp,zm,zp);

				rectobj.setrect(pxm, --XM east
					-xmax+2.05*margin,ypcen+0.01,zpcen, 
					2.0*margin,       yprad+0.01, zprad, 
					xm,xp,ym,yp,zm,zp);

				nko:=nko+1;
				rectobj.setrect(pzp,  --ZP north
					0.0,        ypcen,  pzhi, 
					xprad-0.05, yprad, 2.0*margin, 
							koxlo(nko),koxhi(nko), koylo(nko),
							koyhi(nko), kozlo(nko),kozhi(nko) );
				koyhi(nko):=koyhi(nko)+barr;


				nko:=nko+1;
				rectobj.setrect(pzm,  --ZM south
					0.0,        ypcen,  pzlo, 
					xprad-0.05, yprad, 2.0*margin, 
							koxlo(nko),koxhi(nko), koylo(nko),
							koyhi(nko), kozlo(nko),kozhi(nko) );
				koyhi(nko):=koyhi(nko)+barr;


				rectobj.setrect(pym,  --bottom
					0.0,  -ymax+0.05+0.02, zpcen, 
					xprad-0.05,      0.02, zprad, 
					xm,xp,ym,yp,zm,zp);


				--snd4ada_hpp.playLoop(water); --Water;
				--snd4ada_hpp.playLoop(dark); --dark-metal
				snd4ada_hpp.playSnd(wormx); --Xport


				--ledge
				xc:=+0.5*xmax-0.05;
				yc:=-0.25;
				zc:= 0.0;
				xr:= 0.5*xmax;
				yr:= 0.25;
				zr:=+2.00;
				nko:=nko+1;
				rectobj.setrect(ledge,xc,yc,zc, xr,yr,zr, 
					koxlo(nko),	koxhi(nko),	koylo(nko),	
					koyhi(nko),	kozlo(nko),	kozhi(nko) );




-- begin define entry onto ledge -----------------------------------------------

				vertang := 0.0;
				horiang:=-halfpi; --twopi;
				xlook := fmath.cos(vertang)*fmath.sin(horiang);
				cylook := fmath.sin(vertang);
				zlook := fmath.cos(vertang)*fmath.cos(horiang);

				updateCamera(true);


				-- initial position:
				xme:= xc; -- 4.95
				yme := yc+yr+aheight; -- 0.7
				zme:= zc; -- 0.0

				-- entry on ledge after island stargate
				pyjump:=yme;
				vyjump:=0.0;
				jumptime:= float(sdl_getticks)/1000.0;
				jumping:=true;

-- end define entry onto ledge ------------------------------------------------


				-- pool wall (+zmax):
				rectxobj.setrect(pox2,
					x2picX,x2picY,+zmax-0.05, x2picws,x2pichs,0.01); 
				--movingpic (pox2=>mountainscape)

				frameobj.setrect(nfox,x2picX,x2picY, +zmax-0.05, 
					x2picws,x2pichs,0.01, 0.3, 1); -- width, 1=no

				-- puzzle wall (-zmax):
				rectxobj.setrect(pox,
					x2picX,x2picY,-zmax+0.05, x2picwb,x2pichb,0.01); 
				--movingpic (pox=>waterworld)

				frameobj.setrect(sfox,x2picX,x2picY, -zmax+0.05, 
					x2picwb,x2pichb,0.01, 0.3, 3); -- width, 3=south



				-- ceiling (bluish grunge to show off water)
				xc:=0.0;
				yc:=ymax-0.05;
				zc:=0.0;
				xr:=xmax-0.05;
				yr:=0.01;
				zr:=zmax-0.05;

				-- 13jan18 : ceiling does NOT need to define KO !
				pictobj.setrect(ceil2, xc,yc,zc, xr,yr,zr, j1,j2,j3,j4,j5,j6);



				--27jan18
				rectxobj.setrect(rox,xc,yc-0.02,-11.0, xr,yr,8.95); --starceilx

				yr:=0.3; -- radius of cylindrical edge to grunge ceiling
				hcylobj.setcylx( cyl, xc, yc-yr, zc-2.0, xr, yr, j1,j2,j3,j4,j5,j6); --27jan18


				--exit box
				xc:=+xmax;
				--yc:=-ymax+1.05;
				yc:=-ymax+0.75;
				zc:=+zmax-2.0;
				xr:=0.01;
				yr:=1.0;
				zr:=1.0;
				xboxpos(1):=xc;
				xboxpos(2):=yc;
				xboxpos(3):=zc;
				xboxrad(1):=xr;
				xboxrad(2):=yr;
				xboxrad(3):=zr;
				nko:=nko+1;
				twictobj.setrect2(xbox, xc,yc,zc, xr,yr,zr, 0.0,
					koxlo(nko),	koxhi(nko),	koylo(nko),	
					koyhi(nko),	kozlo(nko),	kozhi(nko) );
				-- use xbox1_texid, then xbox2_texid


				-- partition wall
				yr:=0.5*ymax-0.03;
				xc:=-0.0;
				yc:=-0.5*ymax;
				zc:=+2.0;
				xr:=xmax-0.05;
				zr:=0.1;
				nko:=nko+1;
				pictobj.setrect(bloc2, xc,yc,zc, xr,yr,zr, 
					koxlo(nko),	koxhi(nko),	koylo(nko),	
					koyhi(nko),	kozlo(nko),	kozhi(nko) );

				myassert( nko <= maxnko, 1019 );





--########################################################################
			elsif (level=3) then -- lavapool



				pzlo:= 3.0; pzhi:=zmax-4.0;

				yprad:=margin;
				ypcen:=-ymax+0.02+yprad;

				xpcen:=0.0;  zpcen:=0.5*(pzhi+pzlo);  
				xprad:=xmax-0.02; zprad:=0.5*(pzhi-pzlo);
				waterlevel:= ypcen; -- + yprad/2.0;

				mroomobj.setroomwithfloorgap( rmo,  0.25, 0.25, 0.25,
					pzlo,pzhi,  0.0,0.0,0.0, xmax,ymax,zmax);--10,3,20

				room_texid := loadPng(mirror,"data/bricksr.png");

				--NOTE:  all 3 work here...a) reflsurfobj, 
				--			b)finesurfobj, c)rectsurfobj.
				--       which proves they all work.
				lavasurf.setrect(fso,xpcen, zpcen, xprad-0.03, zprad); 
				--lava in gap

				nko:=nko+1;
				koxlo(nko):=xpcen-xprad;
				koxhi(nko):=xpcen+xprad;
				koylo(nko):=-ymax;
				koyhi(nko):=+ymax;
				kozlo(nko):=zpcen-zprad;
				kozhi(nko):=zpcen+zprad;
				pko:=nko; -- identify pool KO...does NOT obstruct portal gun


				-- begin brick lining of pool
				rectobj.setrect(pxp, --west edge
					xmax-2.05*margin, ypcen+0.01, zpcen, 
					2.0*margin,       yprad+0.01, zprad, 
					xm,xp,ym,yp,zm,zp);

				rectobj.setrect(pxm, --east edge
					-xmax+2.05*margin, ypcen+0.01,zpcen, 
					2.0*margin,        yprad+0.01, zprad, 
					xm,xp,ym,yp,zm,zp);

				nko:=nko+1;
				rectobj.setrect(pzp,  --north edge
					     0.0,   ypcen,  pzhi, 
					xprad-0.05, yprad, 2.0*margin, 
							koxlo(nko),koxhi(nko), koylo(nko),
							koyhi(nko), kozlo(nko),kozhi(nko) );
				koyhi(nko):=koyhi(nko)+barr;

				nko:=nko+1;
				rectobj.setrect(pzm,  --south edge
					     0.0,   ypcen,  pzlo, 
					xprad-0.05, yprad, 2.0*margin, 
							koxlo(nko),koxhi(nko), koylo(nko),
							koyhi(nko), kozlo(nko),kozhi(nko) );
				koyhi(nko):=koyhi(nko)+barr;


				rectobj.setrect(pym,  --bottom
					     0.0,    -ymax+0.05+0.02,   zpcen, 
					xprad-0.05,             0.02,   zprad, 
					xm,xp,ym,yp,zm,zp);



				--snd4ada_hpp.playLoop(lava); --Lava;
				--snd4ada_hpp.playLoop(gothic); --gothic-dutch
				snd4ada_hpp.playSnd(wormx); --Xport


				-- wooden ledge
				xc:=+0.5*xmax-0.05;
				yc:=-0.25;
				zc:= 0.0;
				xr:= 0.5*xmax;
				yr:= 0.25;
				zr:=+2.00;
				nko:=nko+1;
				rectobj.setrect(ledge,xc,yc,zc, xr,yr,zr, 
					koxlo(nko),	koxhi(nko),	koylo(nko),	
					koyhi(nko),	kozlo(nko),	kozhi(nko) );




-- begin define entry onto ledge -----------------------------------------------

				vertang := 0.0;
				horiang:= -halfpi; --onepi;
				xlook := fmath.cos(vertang)*fmath.sin(horiang);
				cylook := fmath.sin(vertang);
				zlook := fmath.cos(vertang)*fmath.cos(horiang);

				updateCamera(true);


				-- initial position:
				xme:= xc;
				yme := yc+yr+aheight;
				zme:= zc;

				-- entry on ledge after island stargate
				pyjump:=yme;
				vyjump:=0.0;
				jumptime:= float(sdl_getticks)/1000.0;
				jumping:=true;

-- end define entry onto ledge ------------------------------------------------


				--movingpic (DaliClock)
				-- lava pool wall (+zmax):
				rectxobj.setrect(pox,
					x3picX,x3picY,+zmax-0.05, x3picws,x3pichs,0.01); 

				frameobj.setrect(nfox,x3picX,x3picY, +zmax-0.05, 
					x3picws,x3pichs,0.01, 0.3, 1); -- width, 1=no

				--movingpic (redPlanet)
				-- puzzle wall (-zmax):
				rectxobj.setrect(pox2,
					x3picX,x3picY,-zmax+0.05, x3picwb,x3pichb,0.01); 

				frameobj.setrect(sfox,x3picX,x3picY, -zmax+0.05, 
					x3picwb,x3pichb,0.01, 0.3, 3); -- width, 3=so


				--exit box
				xc:=-xmax;
				--yc:=-ymax+1.05;
				yc:=-ymax+0.75;
				zc:=+zmax-2.0;
				xr:=0.01;
				yr:=1.0;
				zr:=1.0;
				xboxpos(1):=xc;
				xboxpos(2):=yc;
				xboxpos(3):=zc;
				xboxrad(1):=xr;
				xboxrad(2):=yr;
				xboxrad(3):=zr;
				nko:=nko+1;
				twictobj.setrect2(xbox, xc,yc,zc, xr,yr,zr, 0.0,
					koxlo(nko),	koxhi(nko),	koylo(nko),	
					koyhi(nko),	kozlo(nko),	kozhi(nko) );


				-- partition wall
				yr:=0.25*ymax;
				xc:=0.0;
				yc:=-ymax+0.05+yr;
				zc:=-2.0;
				xr:=xmax-0.05;
				zr:=0.1;
				nko:=nko+1;
				pictobj.setrect(bloc2, 
					xc,yc,zc, xr,yr,zr, 
					koxlo(nko),	koxhi(nko),	koylo(nko),	
					koyhi(nko),	kozlo(nko),	kozhi(nko) );

				myassert( nko <= maxnko, 1020 );




--########################################################################
			elsif (level=4) then  -- eerie dark green water



				pzlo:=-16.0; pzhi:=0.0;

				yprad:=margin;
				xpcen:=0.0;  zpcen:=0.5*(pzhi+pzlo);  ypcen:=-ymax+0.02+yprad;
				xprad:=xmax; zprad:=0.5*(pzhi-pzlo);
				waterlevel:= ypcen + yprad/2.0;

				mroomobj.setroomwithfloorgap( rmo,  0.25, 0.25, 0.25,
					pzlo,pzhi, 0.0,0.0,0.0, 
					xmax,ymax,zmax);--10,3,20

				room_texid := loadPng(mirror,"data/granitergb.png");
				--room_texid := loadPng(mirror,"data/granitergbSeamless.png");

				-- dark translucent water surface setup:
				rectsurf.setrect(rso,xpcen, zpcen, xprad, zprad);
				nko:=nko+1;
				koxlo(nko):=xpcen-xprad;
				koxhi(nko):=xpcen+xprad;
				koylo(nko):=-ymax;
				koyhi(nko):=+ymax;
				kozlo(nko):=zpcen-zprad;
				kozhi(nko):=zpcen+zprad;
				pko:=nko; -- identify pool KO...does NOT obstruct portal gun

				fishx:=0.0;             --center of swim circle
				fishy:=waterlevel-0.10; --lower due to big waves...cuts off bottom fish
				fishz:=0.5*(pzlo+pzhi);
				fishr:=0.40*(pzhi-pzlo); --radius of swim circle
				fishs:=1.0;  -- swim speed
				fdx:=0.00001;
				fdy:=0.06;  -- fish size
				fdz:=0.24;
				myfish.setrect(pdfish, fdx,fdy,fdz);


				-- begin brick lining of pool
				-- +X
				rectobj.setrect(pxp, 
					xmax-0.01-2.0*margin, ypcen+0.01, zpcen, 
					          2.0*margin, yprad+0.01, zprad, 
					xm,xp,ym,yp,zm,zp);

				-- -X
				rectobj.setrect(pxm,
					-xmax+0.01+2.0*margin, ypcen+0.01, zpcen, 
					           2.0*margin, yprad+0.01, zprad, 
					xm,xp,ym,yp,zm,zp);

				nko:=nko+1;
				-- +Z
				rectobj.setrect(pzp,  
					0.0,        ypcen,  pzhi, 
					xprad-0.05, yprad, 2.0*margin, 
							koxlo(nko),koxhi(nko), koylo(nko),
							koyhi(nko), kozlo(nko),kozhi(nko) );
				koyhi(nko):=koyhi(nko)+barr;

				nko:=nko+1;
				-- -Z
				rectobj.setrect(pzm,  
					0.0,        ypcen,  pzlo, 
					xprad-0.05, yprad, 2.0*margin, 
							koxlo(nko),koxhi(nko), koylo(nko),
							koyhi(nko), kozlo(nko),kozhi(nko) );
				koyhi(nko):=koyhi(nko)+barr;



				--bottom
				rectobj.setrect(pym,  
					0.0,    -ymax+0.05+0.02, zpcen, 
					xprad-0.05,        0.02, zprad, 
					xm,xp,ym,yp,zm,zp);



				--snd4ada_hpp.playLoop(water); --Water;
				--snd4ada_hpp.playLoop(neptune); --portals-to-neptune
				snd4ada_hpp.playSnd(wormx); --Xport



				--25jan18: a more useful position
				xc:=+xmax-1.55;
				yc:=-0.25;
				zc:=-zmax+1.55;
				xr:= 1.5;
				yr:= 0.25;
				zr:= 1.5;

				nko:=nko+1;
				rectobj.setrect(ledge,xc,yc,zc, xr,yr,zr, 
				koxlo(nko),	koxhi(nko),	
				koylo(nko),	koyhi(nko),	kozlo(nko),	kozhi(nko) );




	-- begin define entry 
				horiang:=onepi;
				vertang:=0.0;
				xlook := fmath.cos(vertang)*fmath.sin(horiang);
				cylook := fmath.sin(vertang);
				zlook := fmath.cos(vertang)*fmath.cos(horiang);

					xme:= 1.0;
					yme := -ymax+aheight;
					zme:=18.0;

				updateCamera(true);

	-- end define entry



				-- frag shader controls ceiling:
				xc:=0.0;
				yc:=ymax-0.05;
				zc:=0.0;
				xr:=xmax-0.05;
				yr:=0.01;
				zr:=zmax-0.05;
				rectxobj.setrect(rox,xc,yc,zc, xr,yr,zr); --starceilx
				-- no texture needed here;  fancy fragshader used instead
		

				--movingpic: spiral galaxy
				rectxobj.setrect(pox,x4picX,x4picY,-zmax+0.05,x4picw,x4pich,0.01); 

				frameobj.setrect(sfox,x4picx,x4picy,-zmax+0.05,
					x4picw,x4pich,0.01, 0.3, 3); -- width, 3=so


				-- uru picture
				xc:=0.0;
				yc:=0.0;
				zc:=zmax-0.03;
				xr:=2.0;
				yr:=2.0;
				zr:=0.01;
				pictobj.setrect(pic,  xc,yc,zc, xr,yr,zr, 
					xm,xp,ym,yp,zm,zp);

				pic_texid := loadPng(mirror,"data/ederu.png");

				frameobj.setrect(nfox,xc,yc,zc, xr,yr,zr, 0.3, 1); -- width, 1=no

				-- exit box
				xc:=-xmax+2.0;
				--yc:=-ymax+1.05;
				yc:=-ymax+0.75;
				zc:=+zmax;
				xr:=1.0;
				yr:=1.0;
				zr:=0.01;
				xboxpos(1):=xc;
				xboxpos(2):=yc;
				xboxpos(3):=zc;
				xboxrad(1):=xr;
				xboxrad(2):=yr;
				xboxrad(3):=zr;
				nko:=nko+1;
				twictobj.setrect2(xbox, xc,yc,zc, xr,yr,zr, 0.0,
				koxlo(nko),	koxhi(nko),	
				koylo(nko),	koyhi(nko),	kozlo(nko),	kozhi(nko) );


				--partition
				xc:=-3.0;
				yc:= 0.0;
				zc:= zmax*0.5;
				xr:=0.1;
				yr:=ymax-0.03;
				zr:= zmax*0.495;
				nko:=nko+1;
				rectobj.setrect(bloc, xc,yc,zc, xr,yr,zr, 
				koxlo(nko),	koxhi(nko),	
				koylo(nko),	koyhi(nko),	kozlo(nko),	kozhi(nko) );

				myassert( nko <= maxnko, 1021 );



--########################################################################
			elsif (level=5) then  -- epilog


				horiang:=+halfpi;

				vertang:=0.0;
				xlook := fmath.cos(vertang)*fmath.sin(horiang);
				cylook := fmath.sin(vertang);
				zlook := fmath.cos(vertang)*fmath.cos(horiang);


				xme:=0.0;
				yme:=0.0;
				zme:=0.0;

				thirdPerson:=false;
				slewToAvLook;
				updateCamera(true);



				usboxobj.setrect(usb5, rad5,1.0,rad5);

				circsurf.setround(cir,0.0,0.0,rad5);


				--snd4ada_hpp.playLoop(water); --Water;
				--snd4ada_hpp.playLoop(choir); --ChurchChoir
				-- this now begin AFTER arrival 20nov19
				snd4ada_hpp.playSnd(wormx); --Xport

			elsif (level>5) then
				myassert( mxlev=4, 1022 );
				put_line("only 4 levels");
				raise program_error;
			end if;


end preplevel;



