#version 330 core

in vec2 UV;
out vec4 color;

uniform sampler2D myTextureSampler;

uniform int darkness; // 0...4=darkest (bkgd)
const vec4 night = vec4(0.0,0.0,0.0,1.0);

void main(){
	color = texture( myTextureSampler, UV).rgba;
	if( color.a < 0.1 ) discard;

	float df=0;
	if( darkness < 3 ) df=0.0;
	else if( darkness==3 ) df=0.3;
	else if( darkness==4 ) df=0.6;
	float asave=color.a;
	color = mix(color, night, df);
	color.a = asave;

}


//--
//-- Copyright (C) 2016  <fastrgv@gmail.com>
//--
//-- This program is free software: you can redistribute it and/or modify
//-- it under the terms of the GNU General Public License as published by
//-- the Free Software Foundation, either version 3 of the License, or
//-- (at your option) any later version.
//--
//-- This program is distributed in the hope that it will be useful,
//-- but WITHOUT ANY WARRANTY; without even the implied warranty of
//-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//-- GNU General Public License for more details.
//--
//-- You may read the full text of the GNU General Public License
//-- at <http://www.gnu.org/licenses/>.
//--

