#version 330 core

// fragment shader
in vec2 UV;
in vec4 vEyeSpacePos;
in vec4 aPos;
out vec4 color;

uniform sampler2D myTextureSampler;
uniform int level; // 3=>purple, 2=>brown, 1=>gray


const float fStart=0.0;
const float fEnd=30.0; // normal fog
const float sEnd=20.0; // use this for soot (lava room)

const vec4 vFogColor=vec4(0.9,0.9,0.9,1.0); //normal
const vec4 vSootColor=vec4(50.0/255,30.0/255,10.0/255,1.0); // lava room
const vec4 vMystColor=vec4(0.7,0.5,0.7,1.0); // granite room

float getFogFactor(float fFogCoord)
{
	float fResult = 0.0;

	if(level==2)
		fResult = (sEnd-fFogCoord)/(sEnd-fStart);
	else
		fResult = (fEnd-fFogCoord)/(fEnd-fStart);

	fResult = 1.0-clamp(fResult, 0.0, 1.0);
	
	return fResult;
}


const float yc=-2.85;


float random( vec3 scale, float seed ){
	return 
		fract
		( 
		 	sin
			( 
				dot( gl_FragCoord.xyz + seed, scale ) 
			) * 43758.5453 + seed 
		);
}



void main(){

	// this term gives an interesting speckled-smearing effect:
	float r = 0.025 * random( vec3(12.9898,78.233,151.7182), 0.0 );
	// it is Ok to set r=0.0 if effect is unwanted

	float m=0.7; //1.0;
	float b=0.4; //0.3;
	float v2 = clamp( m*aPos.y + b + r, 0.0, 1.0);
   vec2 UV2 = vec2( 0, v2 ); // might add "r"

	color = texture( myTextureSampler, UV2).rgba;
	color.a = 1.0;
	//if(color.a < 0.1) discard;


/////// finally, set fog ////////////////////////////////////////
	float dist = length( vEyeSpacePos.xz );
	float fFogCoord = exp(-0.4*abs(aPos.y-yc)) * dist/vEyeSpacePos.w;

	if( level==3 )
		color = mix(color, vMystColor, getFogFactor(fFogCoord));
	else if( level==2 )
		color = mix(color, vSootColor, getFogFactor(fFogCoord));
	else
		color = mix(color, vFogColor, getFogFactor(fFogCoord));
}



//--
//-- Copyright (C) 2017  <fastrgv@gmail.com>
//--
//-- This program is free software: you can redistribute it and/or modify
//-- it under the terms of the GNU General Public License as published by
//-- the Free Software Foundation, either version 3 of the License, or
//-- (at your option) any later version.
//--
//-- This program is distributed in the hope that it will be useful,
//-- but WITHOUT ANY WARRANTY; without even the implied warranty of
//-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//-- GNU General Public License for more details.
//--
//-- You may read the full text of the GNU General Public License
//-- at <http://www.gnu.org/licenses/>.
//--

