#!/bin/sh
#
# Good
# Mac OS-X compile script for AdaGate assuming the
# presence of GNAT2015 or newer, as well as
# Xcode and its g++ compiler.
#
# This script uses static SDL2 & SFML libs,
# and osx-system-intrinsic OpenAL framework.
#
# ...this script should work on any recent
# standard configuration of OS-X so long as
# the 2015 GNU Ada compiler, gnatmake, is installed.
#
# important note:
# on linux, gcc requires libstdc++ but here on OSX,
# gcc == clang++, which requires libc++
#
#============================================================
# this script requires use of the "raw" frameworks exactly as
# downloaded from the SFML website [ v2.3.2 +extlibs -openal ]
#============================================================
# uses the Xlinker command to fix runtime link paths
# within the executable with the following 2 lines:
#
#-Xlinker -rpath -Xlinker @loader_path/adagate.app/Contents/Frameworks \
#-Xlinker -rpath -Xlinker @loader_path/../Frameworks \
#
# The first line sets path relative to the in-situ executable,
# while the 2nd line is needed just in case a Mac user copies
# the adagate bundle elsewhere with the command
# 		cp -r adagate.app destination
# whence the copy command resolves the softlink by copying
# the actual executable into its proper place under:
# adagate.app/Contents/MacOS/adagate_osx
#
# Thanks to Marco A. from the SFML genius bar for helping with this !
#====================================================================



# use this to ensure a complete recompilation:
if [ -d ./obj/ ]; then
	rm ./obj/*
else
	mkdir obj
fi


# prepare snd4ada.o file prior to gnatmake
g++ adabindings/sfmlAudio/snd4ada.cpp -c -Werror -fPIC -DSFML_STATIC -I./cppinclude

##################################################

gnatmake  adagate -O3  \
-o adagate_osx_s \
--subdirs=./obj \
-I$PWD/adabindings/gl \
-I$PWD/adabindings/sdlada \
-I$PWD/adabindings/AdaPngLib \
-I$PWD/adabindings/sfmlAudio \
-DSFML_STATIC \
-largs -lm -lz \
-lc++ \
$PWD/libs/osx/libSDL2.a \
$PWD/libs/osx/libiconv.a \
$PWD/libs/osx/libsfml-audio-s.a \
$PWD/libs/osx/libsfml-system-s.a \
\
$PWD/snd4ada.o \
\
-framework OpenGL \
-framework ForceFeedback \
-framework CoreFoundation \
-framework Carbon \
-framework Cocoa \
-framework QuartzCore \
-framework IOKit \
-framework CoreAudio \
-framework AudioUnit \
-framework OpenAL \
-pthread \
\
-Xlinker -rpath -Xlinker @loader_path/adagate.app/Contents/Frameworks \
-Xlinker -rpath -Xlinker @loader_path/../Frameworks \
\
-F$PWD/adagate.app/Contents/Frameworks/ \
-framework FLAC -framework ogg \
-framework vorbis -framework vorbisenc -framework vorbisfile


cp ./obj/adagate_osx_s .
cp adagate_osx_s adagate_osx




# -- Copyright (C) 2017  <fastrgv@gmail.com>
# --
# -- This program is free software: you can redistribute it and/or modify
# -- it under the terms of the GNU General Public License as published by
# -- the Free Software Foundation, either version 3 of the License, or
# -- (at your option) any later version.
# --
# -- This program is distributed in the hope that it will be useful,
# -- but WITHOUT ANY WARRANTY; without even the implied warranty of
# -- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# -- GNU General Public License for more details.
# --
# -- You may read the full text of the GNU General Public License
# -- at <http://www.gnu.org/licenses/>.

