#version 330 core
layout(location = 0) in vec3 vertexPos;
layout(location = 1) in vec2 vertexUV;
out vec2 UV;
uniform mat4 MVP;

//uniform float mytime;
//uniform vec3 wPos;
//uniform vec3 wRad;
uniform float waterlevel;

const float avglevel = -0.25; // eye level = 0

const float pi = 3.14159;
const float amplitude=0.03;
const float npeaks=1;

float wave(float r) {
    return amplitude * sin( npeaks*(r)*2*pi);
    //return amplitude * sin( npeaks*(r)*2*pi)/(r+1);
}

float waveHeight(float x, float z) {
	//float rad = sqrt(x*x+z*z);
	float rad = sqrt( sqrt(x*x*x*x+z*z*z*z) );
   float height = 0.0;
   height += wave(rad);
   return height;
}


void main(){
	vec3 pos = vertexPos;
	pos.y = waterlevel + waveHeight(vertexPos.x, vertexPos.z);
	gl_Position =  MVP * vec4(pos,1.0);
	UV = vertexUV;
}


//--
//-- Copyright (C) 2017  <fastrgv@gmail.com>
//--
//-- This program is free software: you can redistribute it and/or modify
//-- it under the terms of the GNU General Public License as published by
//-- the Free Software Foundation, either version 3 of the License, or
//-- (at your option) any later version.
//--
//-- This program is distributed in the hope that it will be useful,
//-- but WITHOUT ANY WARRANTY; without even the implied warranty of
//-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//-- GNU General Public License for more details.
//--
//-- You may read the full text of the GNU General Public License
//-- at <http://www.gnu.org/licenses/>.
//--

